# 通知設計書 135-FailedToRetrieveImagePullSecret

## 概要

本ドキュメントは、Kubernetesにおいてイメージプルシークレットの取得に失敗した際に発行されるWarningイベント「FailedToRetrieveImagePullSecret」の通知設計について記載する。

### 本通知の処理概要

本通知は、kubeletがPodのコンテナイメージ取得に必要なイメージプルシークレット（imagePullSecrets）をKubernetes SecretリソースからFetchする際に失敗した場合に発行されるWarningイベントである。

**業務上の目的・背景**：コンテナイメージのプルにはプライベートレジストリの認証情報が必要な場合がある。PodのSpec.ImagePullSecretsに指定されたSecretが取得できない場合、イメージのプルが認証なしで試行されることになり、プライベートレジストリからのイメージ取得に失敗する可能性が高い。本通知はこのような潜在的なイメージプル失敗を早期に検知し、管理者に対応を促すことを目的とする。

**通知の送信タイミング**：kubeletがPodの起動準備としてSyncPod処理内でgetPullSecretsForPodメソッドを呼び出した際に、1つ以上のイメージプルシークレットの取得に失敗した場合にイベントが発行される。全てのシークレットの取得を試みた後にまとめて1つのイベントとして発行される。

**通知の受信者**：対象Podに紐付くKubernetesイベントとして記録されるため、kubectl describe pod等でPodを参照するクラスタ管理者やアプリケーション開発者が受信者となる。

**通知内容の概要**：取得に失敗したシークレット名のリストと、イメージプルが成功しない可能性がある旨の警告メッセージ。

**期待されるアクション**：受信者はSecretリソースの存在確認（kubectl get secret）、Secretの作成または修正、Pod spec内のimagePullSecrets参照名の確認、およびSecretが正しいNamespaceに存在するかの確認を行う。RBAC権限の確認も必要である。

## 通知種別

Kubernetesイベント（Event API）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（kubelet SyncPod処理内でイベント記録） |
| 優先度 | 中 |
| リトライ | なし（次回SyncPodで再試行） |

### 送信先決定ロジック

イベントは対象PodのObjectReferenceに紐付けて記録される。

## 通知テンプレート

### Kubernetesイベント

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | FailedToRetrieveImagePullSecret |
| Component | kubelet |

### 本文テンプレート

```
Unable to retrieve some image pull secrets (%s); attempting to pull the image may not succeed.
```

パラメータ:
- `%s`: 取得に失敗したシークレット名のカンマ区切りリスト

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | Kubernetesイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| failedPullSecrets | 取得に失敗したシークレット名リスト | Pod.Spec.ImagePullSecrets[].Name（取得失敗分） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Pod同期 | kubelet SyncPod処理 | getPullSecretsForPodで1つ以上のSecret取得に失敗 | Pod起動準備時のSecret取得失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 全Secret取得成功 | failedPullSecretsリストが空の場合、イベントは発行されない |
| Secret名が空 | Pod.Spec.ImagePullSecrets[].Nameが空文字列の場合、API検証上の歴史的理由でスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[kubelet SyncPod] --> B[getPullSecretsForPod呼び出し]
    B --> C[ImagePullSecretsを順次取得]
    C --> D{Secret名が空?}
    D -->|Yes| E[スキップ]
    D -->|No| F[secretManager.GetSecret呼び出し]
    F --> G{取得成功?}
    G -->|Yes| H[pullSecretsリストに追加]
    G -->|No| I[failedPullSecretsリストに追加]
    E --> J{次のSecretRef?}
    H --> J
    I --> J
    J -->|Yes| C
    J -->|No| K{failedPullSecrets > 0?}
    K -->|Yes| L[FailedToRetrieveImagePullSecretイベント発行]
    K -->|No| M[正常終了]
    L --> N[取得成功分のpullSecretsを返却]
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Secret | イメージプルシークレットの取得 | secretManager経由 |
| Pod | ImagePullSecrets参照名の取得 | Podスペック |

### テーブル別参照項目詳細

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.ImagePullSecrets | シークレット参照名リスト | 対象Pod |

#### Secret

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Data | レジストリ認証情報 | Namespace + Secret名で取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | 警告イベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Type | Warning | イベントタイプ |
| INSERT | Reason | FailedToRetrieveImagePullSecret | イベント理由 |
| INSERT | Message | 失敗シークレット名リスト含む警告 | 動的生成 |
| INSERT | Source.Component | kubelet | イベントソース |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Secret未検出 | 指定されたSecret名がNamespaceに存在しない | イベント発行、取得成功分のみでイメージプルを試行 |
| Secret取得権限不足 | kubeletのServiceAccountにSecret参照権限がない | イベント発行、RBACの確認を推奨 |
| SecretManager一時エラー | キャッシュ同期中やAPI接続問題 | イベント発行、次回SyncPodで自動再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 直接的なリトライなし |
| リトライ間隔 | 次回SyncPodサイクル |
| リトライ対象エラー | Secret取得に失敗した全てのケース |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯制限なし。kubeletのSyncPod処理が実行されるたびに評価される。

## セキュリティ考慮事項

- イベントメッセージにはSecret名が含まれるが、Secret内の認証情報（パスワード、トークン等）は含まれない
- イメージプルシークレットの取得失敗は、認証なしでのイメージプル試行につながるため、プライベートレジストリ利用時はセキュリティリスクとなる
- Secret名の空チェック（kubernetes issue #99454への対応）により、不正なSecretRefによる不要な警告が抑制されている

## 備考

- getPullSecretsForPodは部分的な成功を許容する設計であり、一部のSecret取得に失敗しても取得成功分のSecretは返却される
- API validation歴史的な理由で空名のSecretRefが許容されており、これらはスキップされる（https://issue.k8s.io/99454）
- secretManagerはkubelet内のキャッシュ付きSecretマネージャであり、API Serverへの直接アクセスではなくキャッシュ経由でSecretを取得する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Pod specのImagePullSecretsフィールドの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/core/v1/types.go` | PodSpecのImagePullSecretsフィールド（LocalObjectReference型の配列） |

**読解のコツ**: ImagePullSecretsはLocalObjectReferenceの配列であり、各エントリにはNameフィールドのみが含まれる。Secretの取得はkubeletのsecretManagerが行う。

#### Step 2: エントリーポイントを理解する

getPullSecretsForPod関数の実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet_pods.go | `pkg/kubelet/kubelet_pods.go` | getPullSecretsForPodメソッド（1068-1093行目） |

**主要処理フロー**:
1. **1069-1070行目**: pullSecretsとfailedPullSecretsの初期化
2. **1072-1076行目**: ImagePullSecretsを順次走査、空名をスキップ
3. **1078行目**: secretManager.GetSecretでSecret取得
4. **1079-1082行目**: 取得失敗時にログ記録とfailedPullSecretsへの追加
5. **1085行目**: 取得成功時にpullSecretsへの追加
6. **1088-1089行目**: failedPullSecretsが空でない場合にWarningイベント発行
7. **1092行目**: 取得成功分のpullSecretsを返却

#### Step 3: 呼び出し元を理解する

SyncPod処理からの呼び出し経路を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet_pods.go | `pkg/kubelet/kubelet_pods.go` | SyncPod内からのgetPullSecretsForPod呼び出し箇所 |

### プログラム呼び出し階層図

```
kubelet.SyncPod
    |
    +-- getPullSecretsForPod (1068行目)
           |
           +-- secretManager.GetSecret (1078行目) [各SecretRef]
           |
           +-- recorder.Eventf "FailedToRetrieveImagePullSecret" (1089行目) [失敗時]
           |
           +-- return pullSecrets (1092行目) [成功分のみ]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Pod.Spec.ImagePullSecrets ----> getPullSecretsForPod ----+
                                       |                  |
                                       v                  +---> Kubernetes Event
                               secretManager.GetSecret    |     (FailedToRetrieveImagePullSecret)
                                       |                  |
                                       v                  +---> []v1.Secret
                               Secret API (キャッシュ)           (成功分のシークレット)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kubelet_pods.go | `pkg/kubelet/kubelet_pods.go` | ソース | getPullSecretsForPodメソッド。Secret取得とイベント発行 |
| kubelet_pods_test.go | `pkg/kubelet/kubelet_pods_test.go` | テスト | getPullSecretsForPodのユニットテスト |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | kubelet本体。SyncPodからの呼び出し |
| types.go | `staging/src/k8s.io/api/core/v1/types.go` | ソース | PodSpec.ImagePullSecretsの型定義 |
