# 通知設計書 15-ResizeCompleted

## 概要

本ドキュメントは、KubernetesのkubeletがPodのインプレースリサイズを正常に完了した際に発行されるイベント通知「ResizeCompleted」の設計を記述する。

### 本通知の処理概要

InPlacePodVerticalScaling機能の一部として、Podのリソースリサイズがコンテナランタイムレベルで完了し、割り当て済みリソースが実際のリソースと一致した場合に本通知を発行する。

**業務上の目的・背景**：InPlacePodVerticalScalingによるPodリサイズは、リソース割り当ての変更からコンテナランタイムへの反映まで複数のステップを経る。ResizeStartedイベントの後、コンテナランタイムが実際にリソースを変更し完了した時点でこの通知が発行される。ユーザーやオーケストレーションツールに対して、リサイズ操作が完全に完了したことを確認する手段を提供する。

**通知の送信タイミング**：kubeletのsyncPod処理中、コンテナランタイムがリサイズ中でないことが確認され（IsPodResizeInProgress = false）、かつstatusManagerのPodResizeInProgressConditionがクリアされた場合に発行される。

**通知の受信者**：Pod作成を要求したユーザー、Namespace管理者。Kubernetes Eventとして記録される。

**通知内容の概要**：「Pod resize completed: {リソースサマリーJSON}」という形式で、完了したリサイズのリソース情報が通知される。

**期待されるアクション**：ユーザーはリサイズが正常に完了したことを確認する。追加のアクションは不要。

## 通知種別

Kubernetes Event（クラスタ内部イベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncPod処理フロー内で即時発行） |
| 優先度 | 低（Normal） |
| リトライ | なし（完了通知のため） |

### 送信先決定ロジック

イベントの対象オブジェクトは、リサイズが完了したPodリソースである。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Normal |
| Reason | ResizeCompleted |
| Regarding | 対象Pod |
| 発行元 | kubelet |

### 本文テンプレート

```
Pod resize completed: {"initContainers":[...],"containers":[...],"generation":N}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| generation | クリアされたconditionのobservedGeneration | ClearPodResizeInProgressConditionの戻り値 | Yes |
| containers | コンテナ別のリソース割り当て | pod.Spec.Containers | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | syncPod実行 | IsPodResizeInProgress=false かつ ClearPodResizeInProgressConditionがcleared=true | コンテナランタイムでリサイズが完了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リサイズ中の場合 | IsPodResizeInProgressがtrueの場合、完了イベントは発行されない |
| InProgressConditionが存在しない場合 | ClearPodResizeInProgressConditionがcleared=falseの場合、イベントは発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncPod InPlacePodVerticalScaling処理] --> B[containerRuntime.IsPodResizeInProgress]
    B --> C{リサイズ中?}
    C -->|Yes| D[SetPodResizeInProgressCondition]
    C -->|No| E[ClearPodResizeInProgressCondition]
    E --> F{Conditionがクリアされた?}
    F -->|Yes, generation返却| G[PodResizeCompletedMsg生成]
    G --> H[Event発行: ResizeCompleted]
    F -->|No| I[スキップ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd (Pod) | Pod Specのリソース情報 | メッセージ生成用 |

### テーブル別参照項目詳細

#### Pod リソース

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.containers[].resources | リソース情報の表示 | リサイズ対象のPod |
| metadata.generation | generationの記録 | ClearPodResizeInProgressConditionの戻り値 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd (Event) | INSERT | Eventオブジェクトの作成 |
| statusManager (内部) | DELETE | PodResizeInProgressConditionのクリア |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | "ResizeCompleted" | イベント理由 |
| INSERT | message | "Pod resize completed: {JSON}" | リソースサマリー |
| INSERT | type | "Normal" | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| メッセージ生成失敗 | リソースサマリーのJSON化に失敗 | プレフィックスのみのメッセージが使用される（resize.go:65-66行目） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event Recorderのデフォルトレート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントメッセージにはPodのリソース情報のJSON表現が含まれるが、機密性は低い。

## 備考

- InPlacePodVerticalScaling機能ゲートが有効な場合のみ本通知は発生する。
- ClearPodResizeInProgressConditionはgenerationとcleared（bool）の2値を返す。generationはメッセージ生成に使用される。
- コンテナランタイムのIsPodResizeInProgressは、割り当て済みリソースと実際のリソースを比較して判定する。
- kubelet.go:1996-1997行目にイベント発行コードがある。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 39行目: `ResizeCompleted = "ResizeCompleted"` 定数 |
| 1-2 | resize.go | `pkg/kubelet/events/resize.go` | 43-45行目: PodResizeCompletedMsg関数 |

**読解のコツ**: PodResizeCompletedMsgはpodResizeMessage共通関数を呼び出し、errorMsgパラメータに空文字列を渡す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 1991-1998行目: リサイズ完了チェックとイベント発行 |

**主要処理フロー**:
1. **1992行目**: `kl.containerRuntime.IsPodResizeInProgress(pod, podStatus)` でリサイズ状態を確認
2. **1994行目**: `kl.statusManager.ClearPodResizeInProgressCondition(pod.UID)` でconditionをクリア
3. **1996行目**: `events.PodResizeCompletedMsg(logger, pod, generation)` でメッセージ生成
4. **1997行目**: `kl.recorder.Eventf(pod, v1.EventTypeNormal, events.ResizeCompleted, msg)` でイベント発行

### プログラム呼び出し階層図

```
Kubelet.syncPod (kubelet.go:1991)
    |
    +-- containerRuntime.IsPodResizeInProgress
    |       +-- (割り当て済み vs 実リソース比較)
    |
    +-- statusManager.ClearPodResizeInProgressCondition
    |       +-- (generation, cleared)を返却
    |
    +-- events.PodResizeCompletedMsg (resize.go:43)
    |       +-- podResizeMessage (resize.go:62)
    |           +-- makeResourceSummaryFromSpec (resize.go:72)
    |
    +-- recorder.Eventf
```

### データフロー図

```
[入力]                            [処理]                          [出力]

containerRuntime状態 -------> IsPodResizeInProgress判定
                                    |
                                    +-- (false) --> ClearCondition --> Event (Normal/ResizeCompleted)
                                    |
Pod Spec (resources) ---------> PodResizeCompletedMsg --> JSON形式サマリー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| resize.go | `pkg/kubelet/events/resize.go` | ソース | リサイズ完了メッセージ生成 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | syncPod内のリサイズ完了チェック |
| status_manager.go | `pkg/kubelet/status/status_manager.go` | ソース | PodResizeInProgressConditionの管理 |
