# 通知設計書 16-ResizeStarted

## 概要

本ドキュメントは、KubernetesのkubeletがPodのインプレースリサイズを開始した際に発行されるイベント通知「ResizeStarted」の設計を記述する。

### 本通知の処理概要

InPlacePodVerticalScaling機能の一部として、allocation_managerがPodのリサイズ要求をノードリソースの観点から受理し、リソース割り当てを更新した時点で本通知を発行する。この時点ではコンテナランタイムへの反映はまだ完了していない。

**業務上の目的・背景**：Podのインプレースリサイズは、リソース割り当ての変更（allocation_manager）とコンテナランタイムへの反映（syncPod）の2段階で実行される。この通知はリソース割り当ての変更が完了しリサイズプロセスが開始されたことを示す。ResizeCompletedイベントと対をなし、リサイズの進行状況を追跡する手段を提供する。

**通知の送信タイミング**：allocation_managerのhandlePodResourcesResize処理中、canResizePodがfit=trueを返し、SetAllocatedResourcesが成功した後に発行される。

**通知の受信者**：Pod作成を要求したユーザー、Namespace管理者。Kubernetes Eventとして記録される。

**通知内容の概要**：「Pod resize started: {リソースサマリーJSON}」という形式で、リサイズ対象のリソース情報が通知される。

**期待されるアクション**：ユーザーはリサイズが開始されたことを認識し、ResizeCompletedイベントの到着を待つ。リサイズ中はPodResizeInProgressConditionがPod statusに反映される。

## 通知種別

Kubernetes Event（クラスタ内部イベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（allocation_managerの処理フロー内で即時発行） |
| 優先度 | 低（Normal） |
| リトライ | なし（開始通知のため） |

### 送信先決定ロジック

イベントの対象オブジェクトは、リサイズが開始されたPodリソースである。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Normal |
| Reason | ResizeStarted |
| Regarding | 対象Pod |
| 発行元 | kubelet |

### 本文テンプレート

```
Pod resize started: {"initContainers":[...],"containers":[...],"generation":N}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| generation | Podのgeneration | pod.Generation | Yes |
| containers | コンテナ別のリソース要求 | pod.Spec.Containers | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | handlePodResourcesResize | canResizePod=fit かつ SetAllocatedResources成功 | リソース割り当て更新完了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リサイズ不可の場合 | canResizePodがfit=falseの場合、開始イベントは発行されない |
| 割り当て更新失敗の場合 | SetAllocatedResourcesがエラーの場合、イベントは発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[handlePodResourcesResize] --> B[UpdatePodFromAllocation]
    B --> C{リソース変更あり?}
    C -->|なし| D[終了]
    C -->|あり| E[各種制約チェック]
    E --> F[canResizePod]
    F -->|fit=true| G[SetAllocatedResources]
    G --> H{成功?}
    H -->|Yes| I[ClearPodResizePendingCondition]
    I --> J[ClearPodResizeInProgressCondition]
    J --> K[SetPodResizeInProgressCondition]
    K --> L[PodResizeStartedMsg生成]
    L --> M[Event発行: ResizeStarted]
    H -->|No| N[エラー返却]
    F -->|fit=false| O[Deferred/Infeasibleイベント]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd (Pod) | Pod Specのリソース要求確認 | リサイズ対象のリソース |
| etcd (Node) | ノードのAllocatable確認 | リサイズ可否判定 |

### テーブル別参照項目詳細

#### Pod リソース

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.containers[].resources | リサイズ後のリソース要求 | リサイズ対象のPod |
| metadata.generation | Pod世代番号 | メッセージに含める |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd (Event) | INSERT | Eventオブジェクトの作成 |
| allocation checkpoint | UPDATE | リソース割り当ての更新 |
| statusManager (内部) | UPDATE | PodResizeInProgressConditionの設定 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | "ResizeStarted" | イベント理由 |
| INSERT | message | "Pod resize started: {JSON}" | リソースサマリー |
| INSERT | type | "Normal" | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 割り当てチェックポイント保存失敗 | SetAllocatedResourcesが失敗 | リサイズはスキップされ、次回再試行される |
| メッセージ生成失敗 | JSON化に失敗 | プレフィックスのみのメッセージが使用される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（開始通知はリサイズ成功時に1回のみ） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event Recorderのデフォルトレート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントメッセージにはPodのリソース要求のJSON表現が含まれるが、機密性は低い。

## 備考

- InPlacePodVerticalScaling機能ゲートが有効な場合のみ本通知は発生する。
- allocation_manager.go:617-631行目にリサイズ開始の完全なフローがある。
- リサイズ開始時に以下の処理が順次実行される:
  1. SetAllocatedResources: 新しいリソース割り当てをチェックポイントに保存
  2. ClearPodResizePendingCondition: 保留状態をクリア
  3. ClearPodResizeInProgressCondition: 以前のエラーをクリア
  4. SetPodResizeInProgressCondition: 新しい進行中状態を設定
  5. イベント発行: ResizeStarted

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 40行目: `ResizeStarted = "ResizeStarted"` 定数 |
| 1-2 | resize.go | `pkg/kubelet/events/resize.go` | 48-50行目: PodResizeStartedMsg関数 |

**読解のコツ**: PodResizeStartedMsgはpodResizeMessage共通関数を呼び出し、errorMsgに空文字列を渡す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | allocation_manager.go | `pkg/kubelet/allocation/allocation_manager.go` | 615-631行目: リサイズ開始のフロー |

**主要処理フロー**:
1. **617行目**: `m.SetAllocatedResources(pod)` でリソース割り当てを更新
2. **620行目**: `allocatedPod = pod` で割り当て済みPodを更新
3. **621行目**: `ClearPodResizePendingCondition` で保留状態をクリア
4. **625行目**: `ClearPodResizeInProgressCondition` で以前のエラーをクリア
5. **626行目**: `SetPodResizeInProgressCondition` で進行中状態を設定
6. **628行目**: `PodResizeStartedMsg` でメッセージ生成
7. **629行目**: `recorder.Eventf` でイベント発行

### プログラム呼び出し階層図

```
allocation_manager.handlePodResourcesResize (allocation_manager.go:584)
    |
    +-- canResizePod (allocation_manager.go:709)
    |       +-- (fit=true)
    |
    +-- SetAllocatedResources
    +-- ClearPodResizePendingCondition
    +-- ClearPodResizeInProgressCondition
    +-- SetPodResizeInProgressCondition
    +-- events.PodResizeStartedMsg (resize.go:48)
    |       +-- podResizeMessage (resize.go:62)
    |           +-- makeResourceSummaryFromSpec (resize.go:72)
    |
    +-- recorder.Eventf
```

### データフロー図

```
[入力]                           [処理]                           [出力]

Pod Spec (desired resources) -> handlePodResourcesResize
                                    |
Node Allocatable ------------> canResizePod (fit=true)
                                    |
                                    +-- SetAllocatedResources --> チェックポイント更新
                                    +-- PodResizeStartedMsg ---> Event (Normal/ResizeStarted)
                                    +-- Set/Clear Conditions --> statusManager更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| resize.go | `pkg/kubelet/events/resize.go` | ソース | リサイズ開始メッセージ生成 |
| allocation_manager.go | `pkg/kubelet/allocation/allocation_manager.go` | ソース | リサイズ処理のメインロジック |
| status_manager.go | `pkg/kubelet/status/status_manager.go` | ソース | Resize Conditionの管理 |
