# 通知設計書 17-ResizeError

## 概要

本ドキュメントは、KubernetesのkubeletがPodのインプレースリサイズ中にエラーが発生した際に発行されるイベント通知「ResizeError」の設計を記述する。

### 本通知の処理概要

InPlacePodVerticalScaling機能の一部として、コンテナランタイムによるインプレースリサイズ（ResizePodInPlace）の実行中にエラーが発生した場合に本通知を発行する。リサイズのリソース割り当ては完了しているが、コンテナランタイムレベルでの反映に失敗したことを示す。

**業務上の目的・背景**：Podのインプレースリサイズは、allocation_managerによるリソース割り当て更新後、syncPod内でコンテナランタイムにリサイズを実行させる。このコンテナランタイムレベルでのリサイズが失敗した場合、ユーザーに問題を通知し、原因調査と対処を促す必要がある。

**通知の送信タイミング**：kubeletのsyncPod処理中、SyncResultにResizePodInPlaceアクションのエラーが含まれている場合に発行される。statusManagerのSetPodResizeInProgressConditionがエラー状態を新規に設定した場合（updated=true）のみ発行される。

**通知の受信者**：Pod作成を要求したユーザー、Namespace管理者、クラスタ管理者。Kubernetes Eventとして記録される。

**通知内容の概要**：「Pod resize error: {リソースサマリーJSON（エラーメッセージ含む）}」という形式で、エラー内容とリソース情報が通知される。

**期待されるアクション**：クラスタ管理者はコンテナランタイムのログを確認し、リサイズ失敗の原因を特定する。Pod Workerのresync時にリサイズは再試行される。

## 通知種別

Kubernetes Event（クラスタ内部イベント通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncPod処理フロー内で即時発行） |
| 優先度 | 高（Warning） |
| リトライ | 有（syncPodの再実行で自動リトライ） |

### 送信先決定ロジック

イベントの対象オブジェクトは、リサイズエラーが発生したPodリソースである。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| EventType | Warning |
| Reason | ResizeError |
| Regarding | 対象Pod |
| 発行元 | kubelet |

### 本文テンプレート

```
Pod resize error: {"initContainers":[...],"containers":[...],"generation":N,"error":"error message"}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| generation | InProgressConditionのobservedGeneration | SetPodResizeInProgressConditionの戻り値 | Yes |
| errorMsg | リサイズエラーのメッセージ | SyncResult.Message | Yes |
| containers | コンテナ別のリソース要求 | pod.Spec.Containers | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | syncPod結果処理 | SyncResultにResizePodInPlaceエラーあり かつ SetPodResizeInProgressCondition(Error)がupdated=true | コンテナランタイムでのリサイズ失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既にエラー状態の場合 | SetPodResizeInProgressConditionがupdated=falseの場合、イベントは発行されない（observedGenerationも更新されない） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncPod完了] --> B[SyncResultsをチェック]
    B --> C{ResizePodInPlaceエラーあり?}
    C -->|No| D[終了]
    C -->|Yes| E[SetPodResizeInProgressCondition with Error]
    E --> F{Conditionが更新された?}
    F -->|Yes, generation返却| G[PodResizeErrorMsg生成]
    G --> H[Event発行: ResizeError]
    F -->|No| I[イベント発行スキップ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd (Pod) | Pod Specのリソース情報 | メッセージ生成用 |

### テーブル別参照項目詳細

#### Pod リソース

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| spec.containers[].resources | リソース情報の表示 | リサイズ対象のPod |
| metadata.generation | generationの記録 | Conditionの更新に使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd (Event) | INSERT | Eventオブジェクトの作成 |
| statusManager (内部) | UPDATE | PodResizeInProgressConditionにエラー状態を設定 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | "ResizeError" | イベント理由 |
| INSERT | message | "Pod resize error: {JSON}" | エラー情報含むリソースサマリー |
| INSERT | type | "Warning" | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コンテナランタイムリサイズ失敗 | cgroup更新失敗、メモリ不足等 | コンテナランタイムのログ確認、ノードリソースの確認 |
| cgroupの更新失敗 | カーネルの制約やパーミッション問題 | ノードの設定確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | syncPodのresync間隔で再試行 |
| リトライ間隔 | resyncInterval + ジッタ |
| リトライ対象エラー | ResizePodInPlaceアクションのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event Recorderのデフォルトレート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントメッセージにはリサイズエラーの詳細とPodのリソース情報のJSON表現が含まれる。エラーメッセージにノード内部の状態情報が含まれる可能性がある。

## 備考

- InPlacePodVerticalScaling機能ゲートが有効な場合のみ本通知は発生する。
- kubelet.go:2167-2177行目にイベント発行コードがある。
- ResizeErrorのConditionは、既にエラー状態の場合にobservedGenerationが更新されない（kubelet.go:2170のコメント参照）。これにより、同じエラーが継続して発生してもイベントは最初の1回のみ発行される。
- PodResizeErrorMsg関数（resize.go:53-55行目）はerrorMsgパラメータを受け取り、JSON内のerrorフィールドに設定する。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 41行目: `ResizeError = "ResizeError"` 定数 |
| 1-2 | resize.go | `pkg/kubelet/events/resize.go` | 53-55行目: PodResizeErrorMsg関数 |
| 1-3 | resize.go | `pkg/kubelet/events/resize.go` | 39行目: podResourceSummary.Errorフィールド |

**読解のコツ**: PodResizeErrorMsgはerrorMsgを受け取り、podResizeMessage経由でJSON内のerrorフィールドに設定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 2167-2177行目: SyncResult処理とイベント発行 |

**主要処理フロー**:
1. **2168行目**: `result.SyncResults` をイテレート
2. **2169行目**: `r.Action == kubecontainer.ResizePodInPlace && r.Error != nil` でリサイズエラーをフィルタ
3. **2171行目**: `SetPodResizeInProgressCondition(pod.UID, v1.PodReasonError, r.Message, pod.Generation)` でエラー状態設定
4. **2172行目**: `PodResizeErrorMsg(logger, pod, generation, r.Message)` でメッセージ生成
5. **2173行目**: `recorder.Eventf` でイベント発行

### プログラム呼び出し階層図

```
Kubelet.syncPod (kubelet.go:2167)
    |
    +-- result.SyncResults iteration
    |       |
    |       +-- (Action == ResizePodInPlace && Error != nil)
    |
    +-- statusManager.SetPodResizeInProgressCondition(Error)
    |       +-- (generation, updated)を返却
    |
    +-- events.PodResizeErrorMsg (resize.go:53)
    |       +-- podResizeMessage (resize.go:62)
    |           +-- makeResourceSummaryFromSpec (resize.go:72)
    |
    +-- recorder.Eventf
```

### データフロー図

```
[入力]                           [処理]                           [出力]

SyncResult (ResizePodInPlace) -> エラーチェック
                                    |
                                    +-- SetCondition(Error) --> statusManager更新
                                    |
Pod Spec + Error Message -------> PodResizeErrorMsg --> Event (Warning/ResizeError)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| resize.go | `pkg/kubelet/events/resize.go` | ソース | リサイズエラーメッセージ生成 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | syncPod内のリサイズエラー処理 |
| status_manager.go | `pkg/kubelet/status/status_manager.go` | ソース | PodResizeInProgressConditionの管理 |
