# 通知設計書 2-Started

## 概要

本ドキュメントは、Kubernetesのkubeletがコンテナを正常に起動した際に発行する「Started」イベント通知の設計を記述する。

### 本通知の処理概要

kubeletのコンテナランタイムマネージャがCRI（Container Runtime Interface）のStartContainer RPCを呼び出し、コンテナが正常に起動した後、Kubernetes Event APIを用いて「Started」イベントを記録する通知である。

**業務上の目的・背景**：コンテナの起動成功はPodのライフサイクルにおける重要なマイルストーンである。このイベントにより、運用者はコンテナが作成だけでなく実際に起動まで完了したことを確認できる。デプロイメントの進捗監視や障害調査において、Created（作成）とStarted（起動）を区別することで、起動フェーズの問題を特定しやすくなる。

**通知の送信タイミング**：kubeletがCRIのStartContainer RPCを呼び出し、コンテナランタイムから正常応答を受信した直後に発行される。具体的には`startContainer`関数内の297行目で、StartContainerの成功確認直後に実行される。

**通知の受信者**：Kubernetes Event APIを通じて記録されるため、kubectl eventsやモニタリングツール、Event Watcherを利用するクラスタ管理者やオートメーションシステムが受信者となる。

**通知内容の概要**：イベントにはコンテナの参照情報（Pod名、Namespace、コンテナ名）、EventType（Normal）、Reason（Started）、メッセージ（"Container started"）が含まれる。

**期待されるアクション**：通常運用時は特にアクションは不要。デバッグ時には、Createdイベント後にStartedイベントが出ているかを確認することで、起動処理の正常完了を検証できる。Startedイベントが記録されていない場合、コンテナランタイムの起動処理に問題がある可能性がある。

## 通知種別

Kubernetes Eventオブジェクト（API内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Event APIへの書き込み） |
| 優先度 | 中（Normal Event） |
| リトライ | Event API書き込み失敗時はkubelet内部でリトライ |

### 送信先決定ロジック

kubeletが管理するPodに属するコンテナの参照（ObjectReference）を生成し、Kubernetes Event APIサーバへ送信する。送信先はkube-apiserverであり、イベントは対象Podの属するNamespaceに記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Event APIオブジェクトとして発行されるため、メール通知は該当しない。

### 本文テンプレート

```
Container started
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Pod名 | 対象Podの名前 | Pod.ObjectMeta.Name | Yes |
| Namespace | 対象PodのNamespace | Pod.ObjectMeta.Namespace | Yes |
| コンテナ名 | 対象コンテナの名前 | Container.Name | Yes |
| コンテナID | CRIから返却されたコンテナID | CreateContainer RPC応答 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（CRI） | StartContainer RPC成功 | CRIのStartContainer RPCが正常応答を返した場合 | kubeletがコンテナランタイムに対してコンテナ起動を要求し、正常応答を受信した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| コンテナ起動失敗 | CRI StartContainer RPCがエラーを返した場合はStartedイベントではなくFailedイベントが発行される |
| ObjectReference生成失敗 | コンテナの参照生成に失敗した場合はイベントが記録されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[startContainer呼び出し] --> B[イメージプル]
    B --> C[コンテナ作成]
    C --> D[recordContainerEvent: Created]
    D --> E[CRI StartContainer RPC]
    E --> F{起動成功?}
    F -->|成功| G[recordContainerEvent: Started]
    G --> H[PostStartフック実行]
    F -->|失敗| I[recordContainerEvent: Failed]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd（Podオブジェクト） | Pod・コンテナのメタデータ参照 | kube-apiserver経由 |

### テーブル別参照項目詳細

#### Podオブジェクト

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ObjectMeta.Name | イベントの対象Pod特定 | kubeletが管理するPod |
| ObjectMeta.Namespace | イベントの記録先Namespace | kubeletが管理するPod |
| Spec.Containers[].Name | コンテナ参照生成 | startContainer呼び出し時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd（Eventオブジェクト） | INSERT | Startedイベントオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "Started" | イベント理由 |
| INSERT | Event.Type | "Normal" | 正常イベント |
| INSERT | Event.Message | "Container started" | イベントメッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ObjectReference生成失敗 | コンテナ情報からの参照生成エラー | エラーログ出力、イベント記録スキップ |
| Event API書き込み失敗 | kube-apiserverとの通信障害 | kubelet内部のEventRecorderによるリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventRecorder内部のキューイングによる自動リトライ |
| リトライ間隔 | EventRecorderのバッチ送信間隔に依存 |
| リトライ対象エラー | kube-apiserver接続エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのバースト制限に依存（デフォルト25 QPS） |
| 1日あたり上限 | 明示的な上限なし（ただし同一イベントは集約される） |

### 配信時間帯

制限なし。kubeletの動作中は常時送信可能。

## セキュリティ考慮事項

- イベントにはコンテナIDが含まれるが、`recordContainerEvent`関数内でコンテナIDをコンテナ名に置換することで、イベントの重複排除を支援しつつ、内部IDの外部露出を軽減している。
- Event APIへのアクセスはRBACにより制御される。

## 備考

- 本イベントはkubelet内の`kubeGenericRuntimeManager.startContainer`関数（`kuberuntime_container.go` 297行目）で発行される。
- イベント定数は`pkg/kubelet/events/event.go` 22行目で`StartedContainer = "Started"`として定義されている。
- Created（作成）イベントとStarted（起動）イベントは同一のstartContainer関数内で順次発行される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベント定数の定義とKubernetes Eventオブジェクトの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 22行目: `StartedContainer = "Started"` の定数定義を確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/core/v1/types.go` | Event構造体の定義（Type, Reason, Message等） |

**読解のコツ**: StartedContainerとCreatedContainerは同じconstブロック（Container event reason list）内で定義されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるstartContainer関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | 199行目: `startContainer`関数。290-297行目のStartContainer処理に注目 |

**主要処理フロー**:
1. **288行目**: Createdイベント発行（先に作成完了を記録）
2. **291行目**: CRI StartContainer RPC呼び出し
3. **292-295行目**: 起動失敗時はFailedイベント発行
4. **297行目**: `recordContainerEvent`でStartedイベント発行

#### Step 3: イベント記録関数を理解する

recordContainerEvent関数の内部処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | 84行目: `recordContainerEvent`関数の実装 |

**主要処理フロー**:
- **86行目**: GenerateContainerRefでコンテナのObjectReference生成
- **98-100行目**: containerIDをコンテナ名に置換（イベント重複排除対策）
- **101行目**: recorder.Eventでイベント記録

### プログラム呼び出し階層図

```
kubeGenericRuntimeManager.SyncPod()
    |
    +-- startContainer()                    [kuberuntime_container.go:199]
           |
           +-- imagePuller.EnsureImageExists()
           +-- runtimeService.CreateContainer()  [CRI RPC]
           +-- recordContainerEvent(Created)     [kuberuntime_container.go:288]
           +-- runtimeService.StartContainer()   [CRI RPC]
           +-- recordContainerEvent(Started)     [kuberuntime_container.go:297]
           |      |
           |      +-- GenerateContainerRef()
           |      +-- recorder.Event()           [Event APIへ送信]
           |
           +-- executePostStartHook()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Pod Spec          ------>  startContainer()               ------>  Kubernetes Event
(Container定義)              |                                      (Type: Normal,
                             +-- CRI StartContainer                Reason: Started,
                             +-- recordContainerEvent              Message: "Container started")
                             |
Success Response  <------  CRI Response
(ランタイムから)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | ソース | コンテナ作成・起動処理およびイベント記録 |
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | Pod同期処理の全体管理 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | kubelet本体、Pod同期のトリガー |
