# 通知設計書 25-NodeReady

## 概要

本ドキュメントは、KubernetesノードがReady状態に遷移した際に発行されるイベント通知「NodeReady」の設計を定義する。

### 本通知の処理概要

kubeletがノードステータスの更新処理においてNodeReady条件がFalseからTrueに遷移したことを検知した際に、Normalイベントとして発行される通知である。

**業務上の目的・背景**：ノードのReady状態への遷移は、kubelet・コンテナランタイム・ネットワーク・ストレージの全てが正常に機能していることを意味する。ノードの障害からの回復やクラスタへの新規参加を運用者に通知し、ワークロードのスケジューリングが可能になったことを伝達する重要な通知である。

**通知の送信タイミング**：kubeletが定期的なノードステータス同期処理（syncNodeStatus）においてReadyConditionを評価し、前回のStatus値がConditionFalseで今回がConditionTrueとなった場合（ステータス遷移時）に発行される。初回ステータス設定時には遷移として扱われない。

**通知の受信者**：Kubernetes Event APIを通じて、Nodeオブジェクト（kl.nodeRef）に紐づくイベントとして記録される。kubectl describe node等で確認可能であり、クラスタ管理者・SREに伝達される。

**通知内容の概要**：ノード名とReady状態への遷移を示すメッセージが通知される。メッセージ形式は「Node {ノード名} status is now: NodeReady」となる。

**期待されるアクション**：通常、本通知は正常動作を示すため特別なアクションは不要である。ただし、頻繁なReady/NotReady遷移が発生している場合は、ノードの安定性に問題がある可能性があるため調査が必要。

## 通知種別

Kubernetes Event（APIリソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ノードステータス更新処理内で即時実行） |
| 優先度 | 通常（EventType: Normal） |
| リトライ | ノードステータス同期の一部として間接的にリトライ |

### 送信先決定ロジック

kubeletのnodeRef（Nodeオブジェクトへの参照）に対してイベントが記録される。recordNodeStatusEvent関数を通じてEventfが呼ばれる。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | テキスト |

### 本文テンプレート

```
Node {ノード名} status is now: NodeReady
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | Kubernetes Eventのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| kl.nodeName | ノード名 | kubelet設定 | Yes |
| event | イベント理由文字列 "NodeReady" | events.NodeReady定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期処理 | syncNodeStatus内のsetNodeStatus実行 | NodeReady条件がFalse→Trueに遷移 | ReadyCondition setter（setters.go 540-542行目） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータス変更なし | NodeReady条件のStatusが前回と同じ場合はイベント発行されない |
| 初回設定 | readyConditionUpdatedがfalseの場合（初回追加時）はneedToRecordEventがfalseのため発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncNodeStatus定期実行] --> B[setNodeStatus呼び出し]
    B --> C[ReadyCondition setter実行]
    C --> D[ランタイム・ネットワーク・ストレージエラーチェック]
    D --> E{エラーあり?}
    E -->|なし| F[newNodeReadyCondition.Status = True]
    E -->|あり| G[newNodeReadyCondition.Status = False]
    F --> H{前回のStatusと異なる?}
    G --> H
    H -->|異なる| I[needToRecordEvent = true]
    H -->|同じ| J[needToRecordEvent = false]
    I --> K{新Status = True?}
    K -->|はい| L[NodeReadyイベント発行]
    K -->|いいえ| M[NodeNotReadyイベント発行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Node APIリソース（etcd） | 現在のNodeReady条件の取得 | node.Status.Conditions |

### テーブル別参照項目詳細

#### Node.Status.Conditions

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Conditions[].Type | NodeReady条件の特定 | Type == v1.NodeReady |
| Conditions[].Status | 前回のReady状態の取得 | 上記条件のStatus値 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event APIリソース（etcd） | INSERT | Normalイベントの記録 |
| Node APIリソース（etcd） | UPDATE | NodeReady条件の更新（patchNodeStatus） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Type | Normal | EventType |
| INSERT | Reason | NodeReady | イベント理由 |
| INSERT | Message | "Node {ノード名} status is now: NodeReady" | ステータスメッセージ |
| INSERT | InvolvedObject | Node ObjectReference | 対象Node |
| INSERT | Source.Component | kubelet | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| patchNodeStatus失敗 | APIサーバーへのNode更新が失敗 | syncNodeStatusの次回実行時にリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | nodeStatusUpdateRetry回（updateNodeStatus内） |
| リトライ間隔 | 即時リトライ（updateNodeStatusのforループ） |
| リトライ対象エラー | APIサーバー通信エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | ノードステータス同期間隔に依存（デフォルト10秒間隔） |
| 1日あたり上限 | ステータス遷移時のみ発行のため実質的な制限なし |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

- ノード名がイベントメッセージに含まれるが、ノード名はクラスタ内で一般に公開される情報である
- RBACによるEventリソースおよびNodeリソースへのアクセス制御が適用される

## 備考

- ReadyConditionの判定は、runtimeErrors, networkErrors, storageErrors, nodeShutdownManagerErrors, containerManagerStatusの全てがエラーなしの場合にTrueとなる
- 必要なリソースキャパシティ（CPU, Memory, Pods, EphemeralStorage）がnode.Status.Capacityに存在しない場合もNotReadyとなる
- fastNodeStatusUpdate関数による初回のReady遷移検知もあるが、イベント発行はReadyCondition setter内で行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | NodeReady = "NodeReady" 定数定義（57行目） |

**読解のコツ**: NodeReady/NodeNotReadyはkubelet event reason listに定義されており、ノードステータスに関連するイベントである。

#### Step 2: ReadyCondition setterを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | setters.go | `pkg/kubelet/nodestatus/setters.go` | ReadyCondition関数（469-551行目） |

**主要処理フロー**:
1. **483行目**: 現在時刻を取得
2. **484-490行目**: デフォルトのNodeReady条件（Status: True）を構築
3. **491行目**: runtimeErrors, networkErrors, storageErrors, shutdownManagerErrorsを収集
4. **492-504行目**: 必須リソースキャパシティの存在確認
5. **505-513行目**: エラーがある場合はStatus: Falseに変更
6. **521-535行目**: 既存の条件と比較し、ステータス変更を検知
7. **540-542行目**: needToRecordEventがtrue かつ Status == True の場合にNodeReadyイベント発行

#### Step 3: イベント記録関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | recordNodeStatusEvent関数（633-636行目） |

**主要処理フロー**:
- **635行目**: Eventf呼び出し "Node %s status is now: %s" フォーマット

#### Step 4: ノードステータス同期処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | syncNodeStatus関数（449-464行目）、tryUpdateNodeStatus（485-534行目） |
| 4-2 | kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | defaultNodeStatusFuncs（676-703行目）でReadyCondition setterが登録される |

### プログラム呼び出し階層図

```
kubelet.go: goroutine (定期実行)
    |
    +-- syncNodeStatus()                    [kubelet_node_status.go:449]
            |
            +-- updateNodeStatus()           [kubelet_node_status.go:468]
                    |
                    +-- tryUpdateNodeStatus() [kubelet_node_status.go:485]
                            |
                            +-- updateNode()  [kubelet_node_status.go:546]
                            |       |
                            |       +-- setNodeStatus()  [kubelet_node_status.go:662]
                            |               |
                            |               +-- ReadyCondition setter  [setters.go:469]
                            |                       |
                            |                       +-- recordEventFunc()  [setters.go:542]
                            |                               |
                            |                               +-- recordNodeStatusEvent()  [kubelet_node_status.go:633]
                            |                                       |
                            |                                       +-- recorder.Eventf()
                            |
                            +-- patchNodeStatus()  [kubelet_node_status.go:588]
```

### データフロー図

```
[入力]                              [処理]                           [出力]

runtimeErrors()            --> ReadyCondition setter     --> NodeReady条件 (True/False)
networkErrors()                 |
storageErrors()                 +-- エラー集約
shutdownManagerErrors()         +-- リソースキャパシティチェック
node.Status.Capacity            +-- 前回ステータスとの比較
                                |
前回のNodeReady条件        --> 遷移検知                   --> Kubernetes Event API
  (node.Status.Conditions)      |                            (Normal/NodeReady)
                                +-- recordNodeStatusEvent()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | NodeReady定数定義 |
| setters.go | `pkg/kubelet/nodestatus/setters.go` | ソース | ReadyCondition setter、NodeReady判定ロジック |
| kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | ソース | recordNodeStatusEvent関数、syncNodeStatus、updateNodeStatus |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | syncNodeStatusの定期実行ゴルーチン |
| setters_test.go | `pkg/kubelet/nodestatus/setters_test.go` | テスト | ReadyCondition setterのテスト |
