# 通知設計書 26-NodeNotReady

## 概要

本ドキュメントは、KubernetesノードがNotReady状態に遷移した際に発行されるイベント通知「NodeNotReady」の設計を定義する。

### 本通知の処理概要

kubeletがノードステータスの更新処理においてNodeReady条件がTrueからFalseに遷移したことを検知した際に、Normalイベントとして発行される通知である。

**業務上の目的・背景**：ノードのNotReady状態への遷移は、kubelet・コンテナランタイム・ネットワーク・ストレージのいずれかに問題が発生していることを意味する。ノード障害の早期検知とワークロードへの影響を最小化するため、運用者・SREへの迅速な通知が必要である。NotReady状態のノードにはPodがスケジューリングされなくなり、既存Podのエビクションが発生する可能性がある。

**通知の送信タイミング**：kubeletが定期的なノードステータス同期処理（syncNodeStatus）においてReadyConditionを評価し、前回のStatusがConditionTrueで今回がConditionFalseとなった場合（ステータス遷移時）に発行される。

**通知の受信者**：Kubernetes Event APIを通じて、Nodeオブジェクト（kl.nodeRef）に紐づくイベントとして記録される。kubectl describe node等で確認可能。

**通知内容の概要**：ノード名とNotReady状態への遷移を示すメッセージが通知される。メッセージ形式は「Node {ノード名} status is now: NodeNotReady」となる。

**期待されるアクション**：受信者は(1)コンテナランタイムの状態確認、(2)ネットワーク接続性の確認、(3)ストレージの状態確認、(4)kubeletログの詳細調査、(5)ノードのリソース状態確認、を行い、根本原因を特定・解決する必要がある。

## 通知種別

Kubernetes Event（APIリソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ノードステータス更新処理内で即時実行） |
| 優先度 | 高（実質的に重要だが、EventTypeはNormal） |
| リトライ | ノードステータス同期の一部として間接的にリトライ |

### 送信先決定ロジック

kubeletのnodeRef（Nodeオブジェクトへの参照）に対してイベントが記録される。recordNodeStatusEvent関数を通じてEventfが呼ばれる。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | テキスト |

### 本文テンプレート

```
Node {ノード名} status is now: NodeNotReady
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | Kubernetes Eventのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| kl.nodeName | ノード名 | kubelet設定 | Yes |
| event | イベント理由文字列 "NodeNotReady" | events.NodeNotReady定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期処理 | syncNodeStatus内のsetNodeStatus実行 | NodeReady条件がTrue→Falseに遷移 | ReadyCondition setter（setters.go 543-544行目） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータス変更なし | NodeReady条件のStatusが前回と同じ場合はイベント発行されない |
| 初回設定 | 初回のNodeReady条件追加時はneedToRecordEventがfalseのため発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncNodeStatus定期実行] --> B[setNodeStatus呼び出し]
    B --> C[ReadyCondition setter実行]
    C --> D[ランタイム・ネットワーク・ストレージエラーチェック]
    D --> E{エラーあり?}
    E -->|あり| F[newNodeReadyCondition.Status = False]
    E -->|なし| G[newNodeReadyCondition.Status = True]
    F --> H{前回のStatusと異なる?}
    G --> H
    H -->|異なる| I[needToRecordEvent = true]
    H -->|同じ| J[needToRecordEvent = false]
    I --> K{新Status = True?}
    K -->|いいえ| L[NodeNotReadyイベント発行]
    K -->|はい| M[NodeReadyイベント発行]
    L --> N[klog.Infoでノード情報出力]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Node APIリソース（etcd） | 現在のNodeReady条件の取得 | node.Status.Conditions |

### テーブル別参照項目詳細

#### Node.Status.Conditions

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Conditions[].Type | NodeReady条件の特定 | Type == v1.NodeReady |
| Conditions[].Status | 前回のReady状態の取得 | 上記条件のStatus値 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event APIリソース（etcd） | INSERT | Normalイベントの記録 |
| Node APIリソース（etcd） | UPDATE | NodeReady条件の更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Type | Normal | EventType（注：Warningではない） |
| INSERT | Reason | NodeNotReady | イベント理由 |
| INSERT | Message | "Node {ノード名} status is now: NodeNotReady" | ステータスメッセージ |
| INSERT | InvolvedObject | Node ObjectReference | 対象Node |
| INSERT | Source.Component | kubelet | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| runtimeErrors | コンテナランタイムのエラー | コンテナランタイムの再起動・状態確認 |
| networkErrors | ネットワークプラグインのエラー | CNIプラグインの状態確認 |
| storageErrors | ストレージのエラー | ストレージドライバの状態確認 |
| nodeShutdownManagerErrors | ノードシャットダウンマネージャのエラー | シャットダウン処理の確認 |
| missingCapacities | 必須リソースキャパシティ未設定 | ノードのリソース情報の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | nodeStatusUpdateRetry回 |
| リトライ間隔 | 即時リトライ |
| リトライ対象エラー | APIサーバー通信エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | ステータス遷移時のみ発行 |
| 1日あたり上限 | ステータス遷移回数に依存 |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

- ノード名がイベントメッセージに含まれる
- NodeReady条件のReason/Messageにはエラー詳細が含まれ、クラスタ内部の状態が推測される可能性がある
- RBACによるアクセス制御が適用される

## 備考

- EventTypeはWarningではなくNormalである点に注意（setters.go 544行目: `recordEventFunc(v1.EventTypeNormal, events.NodeNotReady)`）
- NodeNotReady遷移時にはklog.Infoでノード情報と条件の詳細がログ出力される（setters.go 545-546行目）
- NodeReady条件のReasonは"KubeletNotReady"、Messageにはaggregated errorsの詳細が含まれる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | NodeNotReady = "NodeNotReady" 定数定義（58行目） |

#### Step 2: ReadyCondition setterを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | setters.go | `pkg/kubelet/nodestatus/setters.go` | ReadyCondition関数（469-551行目）、特に543-546行目のNodeNotReady発行ロジック |

**主要処理フロー**:
1. **491行目**: エラーソース（runtime, network, storage, shutdown）の収集
2. **505-513行目**: エラーがある場合、Status: False, Reason: "KubeletNotReady"に設定
3. **523-529行目**: 前回のStatusと比較してneedToRecordEventを判定
4. **543-544行目**: Status != True の場合にNodeNotReadyイベント発行
5. **545-546行目**: klog.InfoでNodeオブジェクトと条件の詳細をログ出力

#### Step 3: recordNodeStatusEvent関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | recordNodeStatusEvent関数（633-636行目） |

### プログラム呼び出し階層図

```
kubelet.go: goroutine (定期実行)
    |
    +-- syncNodeStatus()                    [kubelet_node_status.go:449]
            |
            +-- updateNodeStatus()           [kubelet_node_status.go:468]
                    |
                    +-- tryUpdateNodeStatus() [kubelet_node_status.go:485]
                            |
                            +-- updateNode()  [kubelet_node_status.go:546]
                            |       |
                            |       +-- setNodeStatus()  [kubelet_node_status.go:662]
                            |               |
                            |               +-- ReadyCondition setter  [setters.go:469]
                            |                       |
                            |                       +-- recordEventFunc()  [setters.go:544]
                            |                               |
                            |                               +-- recordNodeStatusEvent()
                            |                                       +-- recorder.Eventf()
                            |
                            +-- patchNodeStatus()
```

### データフロー図

```
[入力]                              [処理]                           [出力]

runtimeErrors()            --> ReadyCondition setter     --> NodeReady条件 (False)
networkErrors()                 |                            Reason: "KubeletNotReady"
storageErrors()                 +-- エラー集約               Message: aggregated errors
shutdownManagerErrors()         +-- 前回ステータス比較
                                |
前回のNodeReady条件        --> 遷移検知                   --> Kubernetes Event API
  (Status: True)                |                            (Normal/NodeNotReady)
                                +-- recordNodeStatusEvent()
                                +-- klog.Info()           --> kubeletログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | NodeNotReady定数定義 |
| setters.go | `pkg/kubelet/nodestatus/setters.go` | ソース | ReadyCondition setter、NodeNotReady判定ロジック |
| kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | ソース | recordNodeStatusEvent関数、syncNodeStatus |
| setters_test.go | `pkg/kubelet/nodestatus/setters_test.go` | テスト | ReadyCondition setterのテスト（NodeNotReadyケース） |
