# 通知設計書 27-NodeSchedulable

## 概要

本ドキュメントは、Kubernetesノードがスケジュール可能状態に遷移した際に発行されるイベント通知「NodeSchedulable」の設計を定義する。

### 本通知の処理概要

ノードのspec.unschedulableフィールドがtrueからfalseに変更された際に、kubeletがNormalイベントとしてKubernetes Event APIに記録する通知である。

**業務上の目的・背景**：ノードのスケジュール可能状態への遷移は、メンテナンス完了後のノード復帰やkubectl uncordon操作を示す。運用者にノードが再びPodのスケジューリング対象になったことを通知し、クラスタのキャパシティ管理を支援する。

**通知の送信タイミング**：kubeletがノードステータス同期処理（syncNodeStatus）内のsetNodeStatus実行時に、recordNodeSchedulableEvent関数でnode.Spec.Unschedulableの変更を検知した時点で発行される。前回のUnschedulable状態と現在の状態を比較し、trueからfalseへの遷移時に発行される。

**通知の受信者**：Kubernetes Event APIを通じて、Nodeオブジェクト（kl.nodeRef）に紐づくイベントとして記録される。kubectl describe node等で確認可能。

**通知内容の概要**：ノード名とNodeSchedulable状態を示すメッセージが通知される。メッセージ形式は「Node {ノード名} status is now: NodeSchedulable」となる。

**期待されるアクション**：通常、本通知は正常な運用操作（uncordon）の結果を示すため特別なアクションは不要。ノードのメンテナンス完了を確認する用途で利用される。

## 通知種別

Kubernetes Event（APIリソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ノードステータス更新処理内で即時実行） |
| 優先度 | 通常（EventType: Normal） |
| リトライ | ノードステータス同期の一部として間接的にリトライ |

### 送信先決定ロジック

kubeletのnodeRef（Nodeオブジェクトへの参照）に対してイベントが記録される。recordNodeStatusEvent関数を通じてEventfが呼ばれる。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | テキスト |

### 本文テンプレート

```
Node {ノード名} status is now: NodeSchedulable
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | Kubernetes Eventのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| kl.nodeName | ノード名 | kubelet設定 | Yes |
| event | イベント理由文字列 "NodeSchedulable" | events.NodeSchedulable定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期処理 | syncNodeStatus内のsetNodeStatus実行 | node.Spec.UnschedulableがTrue→Falseに遷移 | recordNodeSchedulableEvent関数（kubelet_node_status.go 644-656行目） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Unschedulable変更なし | lastNodeUnschedulableと現在のnode.Spec.Unschedulableが同じ場合は発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncNodeStatus → setNodeStatus] --> B[recordNodeSchedulableEvent呼び出し]
    B --> C[lastNodeUnschedulableLock取得]
    C --> D{lastNodeUnschedulable != node.Spec.Unschedulable?}
    D -->|はい| E{node.Spec.Unschedulable?}
    D -->|いいえ| F[処理なし]
    E -->|false| G[NodeSchedulableイベント発行]
    E -->|true| H[NodeNotSchedulableイベント発行]
    G --> I[lastNodeUnschedulable更新]
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Node APIリソース（etcd） | node.Spec.Unschedulableの取得 | Node specフィールド |

### テーブル別参照項目詳細

#### Node.Spec

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.Unschedulable | スケジュール可能状態の判定 | 直接参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event APIリソース（etcd） | INSERT | Normalイベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Type | Normal | EventType |
| INSERT | Reason | NodeSchedulable | イベント理由 |
| INSERT | Message | "Node {ノード名} status is now: NodeSchedulable" | ステータスメッセージ |
| INSERT | InvolvedObject | Node ObjectReference | 対象Node |
| INSERT | Source.Component | kubelet | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | recordNodeSchedulableEventは常にnilを返す | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（イベント記録のリトライはEventRecorder内部） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 状態遷移時のみ発行 |
| 1日あたり上限 | 状態遷移回数に依存 |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

- ノード名がイベントメッセージに含まれる
- RBACによるアクセス制御が適用される

## 備考

- recordNodeSchedulableEvent関数はdefaultNodeStatusFuncsの最後に登録されるsetter関数である（kubelet_node_status.go 701行目）
- lastNodeUnschedulableLockミューテックスにより排他制御が行われる
- kubectl cordon/uncordon操作がnode.Spec.Unschedulableを変更するトリガーとなる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | NodeSchedulable = "NodeSchedulable" 定数定義（59行目） |

#### Step 2: イベント発行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | recordNodeSchedulableEvent関数（644-656行目） |

**主要処理フロー**:
1. **645行目**: lastNodeUnschedulableLock取得
2. **647行目**: lastNodeUnschedulableと現在値の比較
3. **648-652行目**: Unschedulableがfalseの場合NodeSchedulableイベント発行
4. **653行目**: lastNodeUnschedulable更新

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | defaultNodeStatusFuncs内でのsetter登録（701行目） |
| 3-2 | kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | recordNodeStatusEvent関数（633-636行目） |

### プログラム呼び出し階層図

```
kubelet.go: goroutine (定期実行)
    |
    +-- syncNodeStatus()                       [kubelet_node_status.go:449]
            |
            +-- updateNodeStatus()              [kubelet_node_status.go:468]
                    |
                    +-- tryUpdateNodeStatus()    [kubelet_node_status.go:485]
                            |
                            +-- updateNode()     [kubelet_node_status.go:546]
                                    |
                                    +-- setNodeStatus()  [kubelet_node_status.go:662]
                                            |
                                            +-- recordNodeSchedulableEvent()  [kubelet_node_status.go:644]
                                                    |
                                                    +-- recordNodeStatusEvent()  [kubelet_node_status.go:633]
                                                            |
                                                            +-- recorder.Eventf()
```

### データフロー図

```
[入力]                              [処理]                              [出力]

node.Spec.Unschedulable    --> recordNodeSchedulableEvent()    --> Kubernetes Event API
  (APIサーバーから取得)           |                                   (Normal/NodeSchedulable)
                                +-- lastNodeUnschedulableと比較
lastNodeUnschedulable           +-- 遷移検知
  (kubelet内部状態)              +-- recordNodeStatusEvent()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | NodeSchedulable定数定義 |
| kubelet_node_status.go | `pkg/kubelet/kubelet_node_status.go` | ソース | recordNodeSchedulableEvent、recordNodeStatusEvent、defaultNodeStatusFuncs |
| kubelet_node_status_test.go | `pkg/kubelet/kubelet_node_status_test.go` | テスト | スケジューラブル状態遷移のテスト |
