# 通知設計書 29-Starting

## 概要

本ドキュメントは、kubeletが起動した際に発行されるイベント通知「Starting」の設計を定義する。

### 本通知の処理概要

kubeletプロセスが起動し、初期化処理を開始した時点で発行される「誕生通知（BirthCry）」イベントである。kubeletがNormalイベントとしてKubernetes Event APIに記録する。

**業務上の目的・背景**：kubeletの起動はノードのライフサイクルにおける重要なイベントであり、ノードの初回参加や再起動を示す。運用者にノード上のkubeletが正常に起動を開始したことを通知し、クラスタの状態変化を追跡可能にする。頻繁なkubelet再起動の検知にも利用される。

**通知の送信タイミング**：kubeletのBirthCry()メソッドが呼ばれた時点で即座に発行される。これはkubeletの起動シーケンスの一部として、主要な初期化処理が完了した後に実行される。

**通知の受信者**：Kubernetes Event APIを通じて、Nodeオブジェクト（kl.nodeRef）に紐づくイベントとして記録される。kubectl describe node等で確認可能。

**通知内容の概要**：固定メッセージ「Starting kubelet.」が通知される。

**期待されるアクション**：通常、計画された起動であれば特別なアクションは不要。予期しないkubelet再起動を検知した場合は、(1)ノードの再起動原因の調査、(2)kubeletのログ確認、(3)OOMやカーネルパニック等の確認を行う。

## 通知種別

Kubernetes Event（APIリソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（kubelet起動時に一度だけ実行） |
| 優先度 | 通常（EventType: Normal） |
| リトライ | EventRecorderの内部リトライに依存 |

### 送信先決定ロジック

kubeletのnodeRef（Nodeオブジェクトへの参照）に対してイベントが記録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | テキスト |

### 本文テンプレート

```
Starting kubelet.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | Kubernetes Eventのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロセス起動 | kubelet BirthCry()実行 | kubelet起動時に常に1回発行 | kubelet.go 3167-3169行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | kubelet起動時に必ず1回発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[kubeletプロセス起動] --> B[初期化処理]
    B --> C[BirthCry呼び出し]
    C --> D[Startingイベント発行]
    D --> E[kubelet通常運用開始]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | 起動時の固定イベントのため参照なし |

### テーブル別参照項目詳細

本通知はデータベースを直接参照しない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event APIリソース（etcd） | INSERT | Normalイベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Type | Normal | EventType |
| INSERT | Reason | Starting | イベント理由 |
| INSERT | Message | "Starting kubelet." | 固定メッセージ |
| INSERT | InvolvedObject | Node ObjectReference | 対象Node |
| INSERT | Source.Component | kubelet | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Event記録失敗 | APIサーバーに接続できない場合 | EventRecorderのバッファリング・リトライに依存 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | EventRecorder内部に依存 |
| リトライ間隔 | EventRecorder内部に依存 |
| リトライ対象エラー | APIサーバー通信エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | kubelet起動時に1回のみ |
| 1日あたり上限 | kubelet再起動回数に依存 |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

- 固定メッセージのため、機密情報の露出リスクはない
- RBACによるEventリソースへのアクセス制御が適用される

## 備考

- BirthCry関数はkubeletの起動シーケンスの一部として呼ばれる。関数名が示すように、kubeletの「誕生を告げる」ためのイベントである
- kubelet起動時にAPIサーバーに接続できない場合でも、EventRecorderのバッファリング機能により後で記録される可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | StartingKubelet = "Starting" 定数定義（61行目） |

**読解のコツ**: 定数名はStartingKubeletだが、イベント理由としては"Starting"が記録される。

#### Step 2: BirthCry関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | BirthCry関数（3167-3169行目） |

**主要処理フロー**:
1. **3166行目**: コメント「BirthCry sends an event that the kubelet has started up.」
2. **3168行目**: コメント「Make an event that kubelet restarted.」
3. **3169行目**: `kl.recorder.Eventf(kl.nodeRef, v1.EventTypeNormal, events.StartingKubelet, "Starting kubelet.")`

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet.go | `pkg/kubelet/kubelet.go` | kubeletのRun関数またはkubelet起動シーケンスからのBirthCry呼び出し |

### プログラム呼び出し階層図

```
cmd/kubelet/app/server.go: startKubelet()
    |
    +-- kubelet.BirthCry()           [kubelet.go:3167]
            |
            +-- recorder.Eventf()
                    |
                    +-- nodeRef
                    +-- EventTypeNormal
                    +-- events.StartingKubelet ("Starting")
                    +-- "Starting kubelet."
```

### データフロー図

```
[入力]                [処理]                         [出力]

kubelet起動     --> BirthCry()                --> Kubernetes Event API
                        |                         (Normal/Starting)
                        +-- recorder.Eventf()
                            nodeRef              --> Event.InvolvedObject = Node
                            "Starting kubelet."  --> Event.Message
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | StartingKubelet定数定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | BirthCry関数（Startingイベント発行） |
