# 通知設計書 30-KubeletSetupFailed

## 概要

本ドキュメントは、kubeletのセットアップに失敗した際に発行されるイベント通知「KubeletSetupFailed」の設計を定義する。

### 本通知の処理概要

kubeletの内部モジュール初期化（initializeModules）に失敗した場合に、WarningイベントとしてKubernetes Event APIに記録される通知である。このイベント発行後、kubeletプロセスはos.Exit(1)で終了する。

**業務上の目的・背景**：kubeletの初期化失敗はノードが正常にクラスタに参加できないことを意味する致命的なエラーである。運用者に初期化失敗の原因を伝達し、ノードの復旧作業を迅速に開始できるようにするために本通知が必要である。

**通知の送信タイミング**：kubeletのRun関数内でinitializeModules()が呼ばれ、エラーが返された時点で即座に発行される。その後kubeletプロセスは終了するため、この通知はプロセス終了前の最後のイベントとなる。

**通知の受信者**：Kubernetes Event APIを通じて、Nodeオブジェクト（kl.nodeRef）に紐づくイベントとして記録される。ただし、kubeletが起動初期段階でAPIサーバーに接続できない場合、イベントが記録されない可能性がある。

**通知内容の概要**：initializeModulesのエラーメッセージがそのまま通知される。エラー内容はモジュール初期化の具体的な失敗原因を含む。

**期待されるアクション**：受信者は(1)エラーメッセージの内容を確認、(2)kubeletのログ（journalctl等）で詳細を調査、(3)ノードの設定ファイル（kubelet設定）を確認、(4)必要なディレクトリやパーミッションの確認、(5)依存コンポーネント（CNIプラグイン等）の状態確認、を行い、kubeletを再起動する。

## 通知種別

Kubernetes Event（APIリソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（kubelet初期化処理内で即時実行） |
| 優先度 | 最高（EventType: Warning、プロセス終了を伴う） |
| リトライ | なし（イベント発行後にプロセスが終了するため） |

### 送信先決定ロジック

kubeletのnodeRef（Nodeオブジェクトへの参照）に対してイベントが記録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | テキスト |

### 本文テンプレート

```
{initializeModulesのエラーメッセージ}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | Kubernetes Eventのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err.Error() | initializeModulesのエラーメッセージ | initializeModules()の返却エラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロセス起動 | initializeModules()がエラーを返す | errがnilでない場合 | kubelet.go 1824-1827行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| initializeModules成功 | 初期化が正常に完了した場合はイベント発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[kubelet Run関数実行] --> B[initializeModules呼び出し]
    B --> C{初期化結果}
    C -->|成功| D[正常な起動処理続行]
    C -->|失敗| E[KubeletSetupFailedイベント発行]
    E --> F[klog.ErrorS出力]
    F --> G[os.Exit 1 - プロセス終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | 初期化処理の結果に基づくため直接参照なし |

### テーブル別参照項目詳細

本通知はデータベースを直接参照しない。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event APIリソース（etcd） | INSERT | Warningイベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Type | Warning | EventType |
| INSERT | Reason | KubeletSetupFailed | イベント理由 |
| INSERT | Message | err.Error() | 初期化エラーの詳細 |
| INSERT | InvolvedObject | Node ObjectReference | 対象Node |
| INSERT | Source.Component | kubelet | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 内部モジュール初期化失敗 | initializeModulesが失敗 | エラーメッセージに基づく原因調査、設定修正後にkubelet再起動 |
| Event記録失敗 | APIサーバーに接続できない | kubeletログ（journalctl）で直接確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（プロセスが終了するため） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | kubelet起動試行回数に依存 |
| 1日あたり上限 | kubelet起動試行回数に依存 |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

- initializeModulesのエラーメッセージにはファイルパスやシステム設定情報が含まれる可能性がある
- RBACによるEventリソースへのアクセス制御が適用される
- プロセス終了前のイベント記録のため、EventRecorderのフラッシュが完了しない可能性がある

## 備考

- このイベント発行後、kubeletプロセスはos.Exit(1)で強制終了する（kubelet.go 1827行目）
- systemdなどのプロセスマネージャによりkubeletが自動再起動される場合、繰り返しこのイベントが発行される可能性がある
- initializeModulesの具体的な初期化内容にはコンテナログディレクトリの作成、OOMウォッチャーの初期化、リソースアナライザの起動などが含まれる
- cgroupVersionCheckはinitializeModulesの後に実行されるため、cgroupエラーは本イベントのトリガーとならない（kubelet.go 1830-1832行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | KubeletSetupFailed = "KubeletSetupFailed" 定数定義（62行目） |

#### Step 2: イベント発行処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | initializeModulesエラーハンドリング（1824-1827行目） |

**主要処理フロー**:
1. **1824行目**: `if err := kl.initializeModules(ctx); err != nil {`
2. **1825行目**: `kl.recorder.Eventf(kl.nodeRef, v1.EventTypeWarning, events.KubeletSetupFailed, err.Error())`
3. **1826行目**: `klog.ErrorS(err, "Failed to initialize internal modules")`
4. **1827行目**: `os.Exit(1)` - プロセス終了

#### Step 3: initializeModules関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet.go | `pkg/kubelet/kubelet.go` | initializeModules関数の実装（具体的な初期化処理内容） |

### プログラム呼び出し階層図

```
cmd/kubelet/app/server.go: startKubelet()
    |
    +-- kubelet.Run()                    [kubelet.go]
            |
            +-- initializeModules()       [kubelet.go]
            |       |
            |       +-- (各内部モジュール初期化)
            |       +-- return error      (失敗時)
            |
            +-- (失敗時)
                    +-- recorder.Eventf()  [kubelet.go:1825]
                    |       +-- nodeRef
                    |       +-- EventTypeWarning
                    |       +-- events.KubeletSetupFailed
                    |       +-- err.Error()
                    |
                    +-- klog.ErrorS()      [kubelet.go:1826]
                    +-- os.Exit(1)         [kubelet.go:1827]
```

### データフロー図

```
[入力]                        [処理]                           [出力]

initializeModules()    --> エラー判定                   --> KubeletSetupFailedイベント
  return error              |                               (Warning)
                            +-- recorder.Eventf()
                            +-- klog.ErrorS()           --> kubeletログ
                            +-- os.Exit(1)              --> プロセス終了 (exit code 1)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | KubeletSetupFailed定数定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | initializeModulesエラーハンドリング、KubeletSetupFailedイベント発行 |
| watchdog_linux_test.go | `pkg/kubelet/watchdog/watchdog_linux_test.go` | テスト | KubeletSetupFailed関連のテスト |
