# 通知設計書 33-ContainerGCFailed

## 概要

本ドキュメントは、Kubernetesクラスタにおいてコンテナのガベージコレクション（GC）に失敗した際に発行されるContainerGCFailedイベント通知の設計を記述する。kubeletが定期的に実行するコンテナGC処理でエラーが発生した場合にこの通知が発行される。

### 本通知の処理概要

ContainerGCFailed通知は、kubeletのStartGarbageCollection関数内で定期実行されるコンテナGC処理が失敗した際に発行されるWarningイベントである。コンテナGCは停止済みコンテナを削除してディスクスペースを回収する処理であり、失敗が発生するたびにイベントが記録される。

**業務上の目的・背景**：停止済みコンテナが蓄積するとディスクスペースが枯渇し、ノードの正常動作に影響を及ぼす。コンテナGCの失敗を通知することで、運用者がディスクスペースの枯渇やコンテナランタイムの問題に早期に気づくことができる。

**通知の送信タイミング**：kubeletが定期的（ContainerGCPeriod間隔）に実行するコンテナGC処理でエラーが返された時点で発行される。GCが失敗するたびに毎回イベントが記録される。

**通知の受信者**：Kubernetes APIサーバを通じてイベントが記録され、ノードオブジェクトに紐づけられる。クラスタ管理者、モニタリングシステムが受信者となる。

**通知内容の概要**：イベントメッセージにはGC処理で発生したエラーの詳細（err.Error()）がそのまま含まれる。

**期待されるアクション**：クラスタ管理者はエラー内容を確認し、コンテナランタイムの状態やディスクスペースの確認を行う。必要に応じてノードの手動メンテナンスを実施する。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（定期GCゴルーチン内で発行） |
| 優先度 | 高（Warning EventType） |
| リトライ | なし（次回GCサイクルで再試行される） |

### 送信先決定ロジック

イベントはkubeletが管理するノードオブジェクト（nodeRef）に対して記録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | Kubernetes Event Object |

### 本文テンプレート

```
{err.Error() の内容がそのままメッセージとして記録される}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | GC処理のエラーオブジェクト | containerGC.GarbageCollect()の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期実行 | ContainerGCPeriod間隔のGC処理 | containerGC.GarbageCollect()がエラーを返した場合 | wait.Untilで定期実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| GC成功時 | GC処理が正常に完了した場合はイベントは発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ContainerGCPeriod経過] --> B[containerGC.GarbageCollect実行]
    B --> C{エラー発生?}
    C -->|Yes| D[エラーログ出力]
    D --> E[Warning Event記録]
    E --> F[loggedContainerGCFailure = true]
    C -->|No| G{前回失敗していたか?}
    G -->|Yes| H[成功ログをV=1で出力]
    G -->|No| I[成功ログをV=4で出力]
    F --> J[次回GCサイクルまで待機]
    H --> J
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| コンテナランタイム | 停止済みコンテナ一覧の取得 | CRI経由 |

### テーブル別参照項目詳細

#### コンテナランタイム

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| コンテナ一覧 | GC対象のコンテナ特定 | 停止済みコンテナ |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events | INSERT | ContainerGCFailedイベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "ContainerGCFailed" | Kubernetes Eventオブジェクト |
| INSERT | Event.Type | "Warning" | EventTypeWarning |
| INSERT | Event.Message | エラーメッセージ | err.Error()の内容 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コンテナGC失敗 | コンテナランタイムとの通信エラー等 | エラーログ出力 + Eventf記録、次回GCサイクルで再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（定期GCサイクルにより自動再試行） |
| リトライ間隔 | ContainerGCPeriod |
| リトライ対象エラー | containerGC.GarbageCollect()の全エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GCサイクルの頻度に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯の制限なし。定期GCサイクルに基づいて発行される。

## セキュリティ考慮事項

- エラーメッセージにコンテナランタイムの内部状態が含まれる可能性がある
- イベントはKubernetes RBACにより閲覧権限が制御される

## 備考

- GC成功後の最初の成功ログはV=1レベルで出力され、復旧を明示的に示す
- loggedContainerGCFailureフラグにより、成功時のログレベルが制御される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 76行目: `ContainerGCFailed = "ContainerGCFailed"` 定数定義 |

**読解のコツ**: ContainerGCFailedイベントはkubelet本体のStartGarbageCollection関数内で直接発行される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 1628-1646行目: StartGarbageCollection関数のコンテナGC部分 |

**主要処理フロー**:
1. **1631行目**: `go wait.Until(func() {` - 定期実行ゴルーチン開始
2. **1633行目**: `kl.containerGC.GarbageCollect(ctx)` - GC処理実行
3. **1635行目**: `kl.recorder.Eventf(kl.nodeRef, v1.EventTypeWarning, events.ContainerGCFailed, err.Error())` - 失敗時にイベント記録

### プログラム呼び出し階層図

```
kubelet.StartGarbageCollection()
    |
    +-- go wait.Until(func() { ... }, ContainerGCPeriod, ...)
           |
           +-- containerGC.GarbageCollect(ctx)
           |       |
           |       +-- [CRI経由でコンテナ削除]
           |
           +-- [エラー時] recorder.Eventf(nodeRef, Warning, "ContainerGCFailed", err)
```

### データフロー図

```
[入力]                    [処理]                             [出力]

ContainerGCPeriod         kubelet.StartGarbageCollection     Kubernetes Event
タイマー          ----->   (kubelet.go:1628-1646)       ----> (Reason: "ContainerGCFailed",
                           containerGC.GarbageCollect          Type: Warning)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント定数定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | StartGarbageCollection関数（GCスレッドの起動） |
