# 通知設計書 34-ImageGCFailed

## 概要

本ドキュメントは、Kubernetesクラスタにおいてイメージのガベージコレクション（GC）に失敗した際に発行されるImageGCFailedイベント通知の設計を記述する。kubeletが定期的に実行するイメージGC処理が連続で失敗した場合にこの通知が発行される。

### 本通知の処理概要

ImageGCFailed通知は、kubeletのStartGarbageCollection関数内で定期実行されるイメージGC処理が連続して2回以上失敗した際に発行されるWarningイベントである。初回失敗時はイベントを発行せず（統計情報の初期化が未完了の可能性があるため）、2回目以降の連続失敗時にイベントが記録される。

**業務上の目的・背景**：未使用のコンテナイメージが蓄積するとノードのディスクスペースが枯渇する。イメージGCの失敗を通知することで、運用者がディスクスペースの問題やイメージレジストリとの接続問題に早期に対処できる。初回失敗を無視する設計は、kubelet起動直後のcAdvisor統計初期化完了前のfalse positiveを抑制するためである。

**通知の送信タイミング**：kubeletが定期的（ImageGCPeriod間隔）に実行するイメージGC処理が2回連続で失敗した時点以降、失敗が続く限り毎回発行される。

**通知の受信者**：Kubernetes APIサーバを通じてイベントが記録され、ノードオブジェクトに紐づけられる。クラスタ管理者、モニタリングシステムが受信者となる。

**通知内容の概要**：イベントメッセージにはGC処理で発生したエラーの詳細（err.Error()）が含まれる。

**期待されるアクション**：クラスタ管理者はディスク使用量の確認、イメージレジストリの接続確認、ImageGC設定（ImageGCHighThresholdPercent等）の見直しを行う。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（定期GCゴルーチン内で発行） |
| 優先度 | 高（Warning EventType） |
| リトライ | なし（次回GCサイクルで再試行される） |

### 送信先決定ロジック

イベントはkubeletが管理するノードオブジェクト（nodeRef）に対して記録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | Kubernetes Event Object |

### 本文テンプレート

```
{err.Error() の内容がそのままメッセージとして記録される}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | GC処理のエラーオブジェクト | imageManager.GarbageCollect()の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期実行 | ImageGCPeriod間隔のGC処理 | imageManager.GarbageCollect()が2回連続以上失敗した場合 | prevImageGCFailedフラグで制御 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 初回失敗 | 最初の失敗時はイベントを発行しない（prevImageGCFailed=false） |
| GC無効 | ImageGCHighThresholdPercent=100 かつ ImageMaximumGCAge=0 の場合、GC自体が無効化される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ImageGCPeriod経過] --> B[imageManager.GarbageCollect実行]
    B --> C{エラー発生?}
    C -->|Yes| D{prevImageGCFailed?}
    D -->|true| E[複数回連続失敗ログ出力]
    E --> F[Warning Event記録]
    D -->|false| G[初回失敗ログ出力のみ]
    G --> H[prevImageGCFailed = true]
    F --> H
    C -->|No| I{prevImageGCFailed?}
    I -->|true| J[成功ログをV=1で出力]
    J --> K[prevImageGCFailed = false]
    I -->|false| L[成功ログをV=4で出力]
    H --> M[次回GCサイクルまで待機]
    K --> M
    L --> M
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| コンテナランタイム | イメージ一覧の取得 | CRI経由 |
| cAdvisor | ディスク使用統計 | ファイルシステム情報 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events | INSERT | ImageGCFailedイベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "ImageGCFailed" | Kubernetes Eventオブジェクト |
| INSERT | Event.Type | "Warning" | EventTypeWarning |
| INSERT | Event.Message | エラーメッセージ | err.Error()の内容 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イメージGC失敗 | イメージ削除エラー、統計取得エラー等 | 初回はログのみ、2回目以降はEvent記録、次回GCサイクルで再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（定期GCサイクルにより自動再試行） |
| リトライ間隔 | ImageGCPeriod |
| リトライ対象エラー | imageManager.GarbageCollect()の全エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GCサイクルの頻度に依存 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯の制限なし。

## セキュリティ考慮事項

- エラーメッセージにイメージ名やレジストリURLが含まれる可能性がある
- イベントはKubernetes RBACにより閲覧権限が制御される

## 備考

- ContainerGCFailedと異なり、初回失敗時はイベントが発行されない（false positive抑制のため）
- ImageGCHighThresholdPercent=100かつImageMaximumGCAge=0の場合、イメージGC自体が無効化され、このイベントは発生しない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 77行目: `ImageGCFailed = "ImageGCFailed"` 定数定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 1648-1677行目: StartGarbageCollectionのイメージGC部分 |

**主要処理フロー**:
1. **1650行目**: ImageGC無効化チェック（ImageGCHighThresholdPercent==100 && ImageMaximumGCAge==0）
2. **1655行目**: `prevImageGCFailed := false` - 連続失敗追跡フラグ初期化
3. **1659行目**: `kl.imageManager.GarbageCollect(ctx, beganGC)` - GC処理実行
4. **1660行目**: `if prevImageGCFailed` - 連続失敗判定
5. **1663行目**: `kl.recorder.Event(kl.nodeRef, v1.EventTypeWarning, events.ImageGCFailed, err.Error())` - 2回目以降の失敗でイベント記録

### プログラム呼び出し階層図

```
kubelet.StartGarbageCollection()
    |
    +-- [ImageGC無効チェック]
    |
    +-- go wait.Until(func() { ... }, ImageGCPeriod, ...)
           |
           +-- imageManager.GarbageCollect(ctx, beganGC)
           |
           +-- [prevImageGCFailed == true の場合]
                  |
                  +-- recorder.Event(nodeRef, Warning, "ImageGCFailed", err)
```

### データフロー図

```
[入力]                   [処理]                             [出力]

ImageGCPeriod            kubelet.StartGarbageCollection     Kubernetes Event
タイマー         ----->   (kubelet.go:1648-1677)       ----> (Reason: "ImageGCFailed",
                          prevImageGCFailedフラグ制御         Type: Warning)
                          imageManager.GarbageCollect         ※2回連続失敗時のみ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント定数定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | StartGarbageCollection関数 |
