# 通知設計書 36-FailedNodeAllocatableEnforcement

## 概要

本ドキュメントは、KubernetesクラスタにおいてノードのAllocatable制限の適用に失敗した際に発行されるFailedNodeAllocatableEnforcementイベント通知の設計を記述する。kubeletのContainer ManagerがcgroupへのNode Allocatable制限設定に失敗した際にこの通知が発行される。

### 本通知の処理概要

FailedNodeAllocatableEnforcement通知は、kubeletのContainer Manager（containerManagerImpl）がNode Allocatable制限をcgroupに適用しようとして失敗した際に発行されるWarningイベントである。cgroupルートへの適用失敗時は1分間隔でリトライが行われ、失敗のたびにイベントが記録される。System Reserved/Kube Reserved cgroup への適用失敗時はエラーが返される。

**業務上の目的・背景**：Node Allocatable制限の適用失敗は、ノード上のPodがリソース制限なしで実行される可能性を意味する。これはリソース競合やOOM（Out Of Memory）の原因となるため、運用者に迅速に通知する必要がある。特にメモリ使用量が既に高い場合にcgroup制限の適用が失敗するケースが多い。

**通知の送信タイミング**：cgroupManager.Update()またはenforceExistingCgroup()が失敗した時点で発行される。cgroupルートへの適用は1分間隔でリトライされるため、成功するまで繰り返し発行される可能性がある。

**通知の受信者**：Kubernetes APIサーバを通じてイベントが記録され、ノードオブジェクトに紐づけられる。

**通知内容の概要**：失敗した対象とエラー詳細が含まれる。例：「Failed to update Node Allocatable Limits "{cgroupRoot}": {error}」「Failed to enforce System Reserved Cgroup Limits on "{name}": {error}」。

**期待されるアクション**：クラスタ管理者はノードのメモリ使用量を確認し、必要に応じてPodのEvictionを実施するか、ノードのリソース予約設定を見直す。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（cgroupルート: ゴルーチン内）/ 同期（その他） |
| 優先度 | 高（Warning EventType） |
| リトライ | cgroupルート: 1分間隔で無制限リトライ |

### 送信先決定ロジック

イベントはContainer Managerが管理するノードオブジェクト参照（nodeRef）に対して記録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | Kubernetes Event Object |

### 本文テンプレート

```
# cgroupルート制限適用失敗時
Failed to update Node Allocatable Limits %q: %v

# System Reserved cgroup制限適用失敗時
Failed to enforce System Reserved Cgroup Limits on %q: %v

# Kube Reserved cgroup制限適用失敗時
Failed to enforce Kube Reserved Cgroup Limits on %q: %v

# System Reserved Compressible cgroup制限適用失敗時
Failed to enforce System Reserved Compressible Cgroup Limits on %q: %v

# Kube Reserved Compressible cgroup制限適用失敗時
Failed to enforce Kube Reserved Compressible Cgroup Limits on %q: %v
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| cgroupRoot / cgroupName | 対象cgroup名 | cm.cgroupRoot / nc.SystemReservedCgroupName / nc.KubeReservedCgroupName | Yes |
| err | エラーオブジェクト | cgroupManager.Update() / enforceExistingCgroup()の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| cgroup更新失敗 | cgroupルート制限更新失敗 | cgroupManager.Update()がエラーを返した場合 | リトライループ内で発行 |
| cgroup更新失敗 | System Reserved cgroup制限適用失敗 | enforceExistingCgroup()がエラーを返した場合 | エラーreturnと同時に発行 |
| cgroup更新失敗 | Kube Reserved cgroup制限適用失敗 | enforceExistingCgroup()がエラーを返した場合 | エラーreturnと同時に発行 |
| cgroup更新失敗 | System Reserved Compressible cgroup制限適用失敗 | enforceExistingCgroup()がエラーを返した場合 | エラーreturnと同時に発行 |
| cgroup更新失敗 | Kube Reserved Compressible cgroup制限適用失敗 | enforceExistingCgroup()がエラーを返した場合 | エラーreturnと同時に発行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 制限適用成功 | cgroup更新が成功した場合はWarningイベントは発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Enforce Node Allocatable開始] --> B{cgroupRoot非空?}
    B -->|Yes| C[go func: cgroupルート制限更新ループ]
    C --> D[cgroupManager.Update実行]
    D --> E{成功?}
    E -->|No| F[Warning Event: Failed to update Node Allocatable Limits]
    F --> G[1分スリープ]
    G --> D
    E -->|Yes| H[Normal Event: NodeAllocatableEnforced]
    B -->|No| I[次の制限チェック]
    H --> I
    I --> J{SystemReserved有効?}
    J -->|Yes| K[enforceExistingCgroup実行]
    K --> L{成功?}
    L -->|No| M[Warning Event + return error]
    L -->|Yes| N[Normal Event]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| NodeConfig | Allocatable制限の設定値取得 | kubelet設定 |
| cgroupManager | 現在のcgroup状態 | Linux cgroup |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events | INSERT | FailedNodeAllocatableEnforcementイベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "FailedNodeAllocatableEnforcement" | Kubernetes Eventオブジェクト |
| INSERT | Event.Type | "Warning" | EventTypeWarning |
| INSERT | Event.Message | 対象とエラー詳細を含むメッセージ | 上記テンプレート参照 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| cgroupルート更新失敗 | メモリ使用量超過等 | 1分間隔でリトライ、Pod Evictionによる解消を期待 |
| Reserved cgroup制限失敗 | 対象cgroupが存在しない等 | エラーreturn、kubelet起動失敗 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | cgroupルート: 無制限、その他: なし |
| リトライ間隔 | 1分（time.Sleep(time.Minute)） |
| リトライ対象エラー | cgroupManager.Update()のエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | cgroupルート: 最大1件/分、その他: 最大1件 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

時間帯の制限なし。

## セキュリティ考慮事項

- cgroup名とエラー詳細が含まれるが機密情報ではない
- イベントはKubernetes RBACにより閲覧権限が制御される

## 備考

- Linux環境専用の機能
- cgroupルートへの適用失敗はリトライされるが、Reserved cgroupへの適用失敗はkubelet起動を停止させる可能性がある
- No.35 NodeAllocatableEnforcedと対になる通知

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 78行目: `FailedNodeAllocatableEnforcement = "FailedNodeAllocatableEnforcement"` 定数定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | node_container_manager_linux.go | `pkg/kubelet/cm/node_container_manager_linux.go` | 70-148行目: Enforce Node Allocatable処理 |

**主要処理フロー**:
1. **97行目**: cgroupManager.Update() - cgroup制限更新試行
2. **102-103行目**: 失敗時のメッセージ生成とWarningイベント記録
3. **104行目**: `time.Sleep(time.Minute)` - 1分間スリープ後リトライ
4. **111-114行目**: System Reserved制限適用失敗時のイベント記録とエラーreturn
5. **120-123行目**: Kube Reserved制限適用失敗時のイベント記録とエラーreturn

### プログラム呼び出し階層図

```
containerManagerImpl.Enforce Node Allocatable
    |
    +-- [cgroupRoot非空の場合]
    |      +-- go func() リトライループ
    |             +-- cgroupManager.Update()
    |             +-- [失敗] recorder.Event(Warning, "FailedNodeAllocatableEnforcement")
    |             +-- time.Sleep(time.Minute)
    |
    +-- [SystemReserved有効の場合]
    |      +-- enforceExistingCgroup()
    |      +-- [失敗] recorder.Event(Warning, "FailedNodeAllocatableEnforcement")
    |      +-- return error
    |
    +-- [KubeReserved/Compressible有効の場合も同様]
```

### データフロー図

```
[入力]                       [処理]                                    [出力]

NodeConfig                   containerManagerImpl                      Kubernetes Event
(Allocatable設定)  ----->    Enforce Node Allocatable             ----> (Reason: "FailedNodeAllocatable
                              (node_container_manager_                   Enforcement",
cgroup状態         ----->     linux.go:70-148)                          Type: Warning)
                              cgroupManager.Update() [失敗]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント定数定義 |
| node_container_manager_linux.go | `pkg/kubelet/cm/node_container_manager_linux.go` | ソース | Enforce Node Allocatable処理 |
| container_manager.go | `pkg/kubelet/cm/container_manager.go` | ソース | ContainerManager インターフェース定義 |
