# 通知設計書 37-CgroupV1

## 概要

本ドキュメントは、Kubernetesクラスタにおいて非推奨のcgroup v1が使用されている際に発行されるCgroupV1イベント通知の設計を記述する。kubeletが起動時にcgroupバージョンをチェックし、cgroup v1が検出された場合にこの通知が発行される。

### 本通知の処理概要

CgroupV1通知は、kubeletのcgroupVersionCheck関数がcgroup v1を検出した際に発行されるWarningイベントである。cgroup v1はKubernetesにおいて非推奨であり、将来のリリースでサポートが削除される予定であることをユーザに通知する。

**業務上の目的・背景**：cgroup v1はKubernetesプロジェクトにおいて非推奨化が進んでおり、将来のリリースでサポートが削除される予定である（KEP-5573）。この通知は、ユーザにcgroup v2への移行を促すために発行される。cgroup v2への移行はリソース管理の改善やセキュリティ強化をもたらす。

**通知の送信タイミング**：kubeletの起動時にcgroupバージョンチェック（cgroupVersionCheck関数）が実行され、cgroup v1が検出された時点で発行される。

**通知の受信者**：Kubernetes APIサーバを通じてイベントが記録され、ノードオブジェクトに紐づけられる。クラスタ管理者が主な対象となる。

**通知内容の概要**：「cgroup v1 detected. cgroup v1 support is deprecated and will be removed in a future release. Please migrate to cgroup v2. More information at https://git.k8s.io/enhancements/keps/sig-node/5573-remove-cgroup-v1」というメッセージが記録される。

**期待されるアクション**：クラスタ管理者はcgroup v2への移行を計画し、ノードのOSを更新してcgroup v2を有効化する。移行手順はKEP-5573のリンク先で確認する。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（kubelet起動処理内で発行） |
| 優先度 | 高（Warning EventType） |
| リトライ | なし（起動時に1回のみ） |

### 送信先決定ロジック

イベントはkubeletが管理するノードオブジェクト（nodeRef）に対して記録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet |
| 件名 | N/A |
| 形式 | Kubernetes Event Object |

### 本文テンプレート

```
cgroup v1 detected. cgroup v1 support is deprecated and will be removed in a future release. Please migrate to cgroup v2. More information at https://git.k8s.io/enhancements/keps/sig-node/5573-remove-cgroup-v1
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | N/A | N/A |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| kubelet起動 | cgroupVersionCheck実行 | containerManager.GetNodeConfig().CgroupVersion == 1 | kubelet起動時のcgroupバージョンチェック |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| cgroup v2使用時 | cgroupバージョンが2の場合はこのイベントは発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[kubelet起動] --> B[cgroupVersionCheck実行]
    B --> C[containerManager.GetNodeConfig.CgroupVersion取得]
    C --> D{CgroupVersion == 1?}
    D -->|Yes| E[CgroupVersionメトリクス設定]
    E --> F[Warning Event: CgroupV1DeprecatedWarning]
    F --> G[errors.New返却]
    D -->|No| H{CgroupVersion == 2?}
    H -->|Yes| I[cpu.stat存在チェック]
    I --> J[CgroupVersionメトリクス設定]
    H -->|No| K[unsupported cgroup versionエラー]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| NodeConfig | cgroupバージョン情報 | containerManager.GetNodeConfig() |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events | INSERT | CgroupV1イベントの記録 |
| metrics | UPDATE | CgroupVersionメトリクスの設定 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "CgroupV1" | Kubernetes Eventオブジェクト |
| INSERT | Event.Type | "Warning" | EventTypeWarning |
| INSERT | Event.Message | CgroupV1DeprecatedWarning | 固定メッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| cgroup v1検出 | CgroupVersion == 1 | Warningイベント発行 + エラー返却（kubeletは動作継続） |
| 未サポートバージョン | CgroupVersionが1でも2でもない | エラー返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 1件（起動時に1回のみ） |
| 1日あたり上限 | kubelet再起動回数に依存 |

### 配信時間帯

時間帯の制限なし。kubelet起動時に発行される。

## セキュリティ考慮事項

- メッセージにはシステムの基本的な構成情報（cgroupバージョン）のみが含まれる
- イベントはKubernetes RBACにより閲覧権限が制御される

## 備考

- Linux環境専用（kubelet_linux.goに実装）
- cgroup v1であってもkubeletの動作は継続される（エラーは返却されるがWarningレベル）
- CgroupVersionメトリクスも同時に設定される
- KEP-5573で非推奨化の詳細が管理されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 86行目: `CgroupV1 = "CgroupV1"` 定数定義 |
| 1-2 | container_manager.go | `pkg/kubelet/cm/container_manager.go` | 52行目: CgroupV1DeprecatedWarning メッセージ定数 |

**読解のコツ**: イベント定数とメッセージ定数が別ファイルに定義されていることに注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet_linux.go | `pkg/kubelet/kubelet_linux.go` | 34-51行目: cgroupVersionCheck関数全体 |

**主要処理フロー**:
1. **35行目**: `cgroupVersion := kl.containerManager.GetNodeConfig().CgroupVersion` - バージョン取得
2. **36行目**: `metrics.CgroupVersion.Set(float64(cgroupVersion))` - メトリクス設定
3. **38-40行目**: case 1: Warningイベント発行 + エラー返却
4. **39行目**: `kl.recorder.Eventf(kl.nodeRef, v1.EventTypeWarning, events.CgroupV1, cm.CgroupV1DeprecatedWarning)`

### プログラム呼び出し階層図

```
kubelet起動処理
    |
    +-- kl.cgroupVersionCheck()
           |
           +-- containerManager.GetNodeConfig().CgroupVersion
           |
           +-- metrics.CgroupVersion.Set()
           |
           +-- [case 1] recorder.Eventf(nodeRef, Warning, "CgroupV1", message)
           |
           +-- [case 1] return errors.New(CgroupV1DeprecatedWarning)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

containerManager          kubelet.cgroupVersionCheck          Kubernetes Event
.GetNodeConfig()  ----->  (kubelet_linux.go:34-51)      ----> (Reason: "CgroupV1",
.CgroupVersion                                                Type: Warning)
                                                          |
                                                          +--> CgroupVersion メトリクス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント定数定義（CgroupV1） |
| kubelet_linux.go | `pkg/kubelet/kubelet_linux.go` | ソース | cgroupVersionCheck関数 |
| container_manager.go | `pkg/kubelet/cm/container_manager.go` | ソース | CgroupV1DeprecatedWarningメッセージ定数 |
| metrics.go | `pkg/kubelet/metrics/metrics.go` | ソース | CgroupVersionメトリクス定義 |
