# 通知設計書 38-PossibleMemoryBackedVolumesOnDisk

## 概要

本ドキュメントは、Kubernetesクラスタにおいてメモリバックボリューム（secrets、emptyDir等）がディスク上にスワップされる可能性がある際に発行されるPossibleMemoryBackedVolumesOnDiskイベント通知の設計を記述する。

### 本通知の処理概要

PossibleMemoryBackedVolumesOnDisk通知は、kubeletのContainer Manager初期化時にスワップが有効であり、かつtmpfsのnoswapオプションがサポートされていない環境で発行されるWarningイベントである。メモリバックボリューム（secrets、emptyDirのmedium: Memory等）がディスクにスワップされるとセキュリティリスクとなるため、この通知でユーザに警告する。

**業務上の目的・背景**：KubernetesのSecret等の機密データはメモリバックのtmpfsに格納されることでディスクに書き込まれない保証を得ているが、スワップが有効な環境ではこのデータがスワップ領域を通じてディスクに書き込まれる可能性がある。tmpfsのnoswapオプションが利用できない場合、この保証が失われるためセキュリティ上の警告が必要となる。

**通知の送信タイミング**：kubeletのContainer Manager（containerManagerImpl）の初期化処理で、スワップが有効であることが検知され、かつtmpfsのnoswapオプションがサポートされていないことが確認された時点で発行される。

**通知の受信者**：Kubernetes APIサーバを通じてイベントが記録され、ノードオブジェクトに紐づけられる。クラスタ管理者が主な対象となる。

**通知内容の概要**：「The tmpfs noswap option is not supported. Memory-backed volumes (e.g. secrets, emptyDirs, etc.) might be swapped to disk and should no longer be considered secure.」というメッセージが記録される。

**期待されるアクション**：クラスタ管理者はスワップの無効化、またはtmpfsのnoswapオプションをサポートするカーネルバージョンへのアップグレードを検討する。機密データを扱うワークロードについては特に注意が必要。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Container Manager初期化処理内で発行） |
| 優先度 | 高（Warning EventType、セキュリティ関連） |
| リトライ | なし（初期化時に1回のみ） |

### 送信先決定ロジック

イベントはContainer Managerが生成するノードオブジェクト参照（nodeRefFromNode）に対して記録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetes Event） |
| 送信元名称 | kubelet container manager |
| 件名 | N/A |
| 形式 | Kubernetes Event Object |

### 本文テンプレート

```
The tmpfs noswap option is not supported. Memory-backed volumes (e.g. secrets, emptyDirs, etc.) might be swapped to disk and should no longer be considered secure.
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| N/A | 固定メッセージのため変数なし | N/A | N/A |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Container Manager初期化 | スワップ有効 + tmpfs noswap未サポート | isSwapOn==true && !IsTmpfsNoswapOptionSupported | failSwapOn=falseの場合のみ到達 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| スワップ無効 | スワップが無効の場合はチェック自体がスキップされる |
| failSwapOn有効 | failSwapOnが有効の場合、スワップ検出時にkubelet起動が失敗するため到達しない |
| tmpfs noswapサポート | tmpfsのnoswapオプションがサポートされている場合はイベント発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Container Manager初期化] --> B{スワップ有効?}
    B -->|No| C[通常起動]
    B -->|Yes| D{failSwapOn?}
    D -->|Yes| E[エラー: swap on is not supported]
    D -->|No| F{tmpfs noswapサポート?}
    F -->|Yes| G[通常起動]
    F -->|No| H[Warning Event: PossibleMemoryBackedVolumesOnDisk]
    H --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| システム情報 | スワップ状態の確認 | /proc/swaps等 |
| マウント情報 | tmpfs noswapサポート確認 | swap.IsTmpfsNoswapOptionSupported |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events | INSERT | PossibleMemoryBackedVolumesOnDiskイベントの記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "PossibleMemoryBackedVolumesOnDisk" | Kubernetes Eventオブジェクト |
| INSERT | Event.Type | "Warning" | EventTypeWarning |
| INSERT | Event.Message | 固定メッセージ | tmpfs noswap未サポート警告 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| スワップ検出エラー | スワップ状態の確認失敗 | エラーreturn（Container Manager初期化失敗） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 1件（初期化時に1回のみ） |
| 1日あたり上限 | kubelet再起動回数に依存 |

### 配信時間帯

時間帯の制限なし。kubelet起動時のContainer Manager初期化処理で発行される。

## セキュリティ考慮事項

- この通知自体がセキュリティ警告である
- メモリバックボリューム（secrets等）がディスクにスワップされるリスクを示す
- 機密データを扱うワークロードでは特に重要な通知

## 備考

- Linux環境専用の機能（container_manager_linux.goに実装）
- failSwapOnフラグがfalse（--fail-swap-on=false）の場合にのみ到達するパス
- tmpfsのnoswapオプションはLinuxカーネル6.3以降でサポートされる
- Kubernetes 1.28以降でスワップサポートが段階的に導入されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 85行目: `PossibleMemoryBackedVolumesOnDisk = "PossibleMemoryBackedVolumesOnDisk"` 定数定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | container_manager_linux.go | `pkg/kubelet/cm/container_manager_linux.go` | 220-231行目: スワップチェックとtmpfs noswapサポート確認 |

**主要処理フロー**:
1. **220行目**: `if isSwapOn` - スワップ有効チェック
2. **221行目**: `if failSwapOn` - failSwapOnフラグチェック
3. **225行目**: `if !swap.IsTmpfsNoswapOptionSupported(...)` - tmpfs noswapサポートチェック
4. **227行目**: `recorder.Event(nodeRef, v1.EventTypeWarning, events.PossibleMemoryBackedVolumesOnDisk, ...)` - Warningイベント発行

### プログラム呼び出し階層図

```
containerManagerImpl 初期化
    |
    +-- スワップ状態チェック
    |      |
    |      +-- [スワップ有効 && !failSwapOn]
    |             |
    |             +-- swap.IsTmpfsNoswapOptionSupported()
    |                    |
    |                    +-- [未サポート] recorder.Event(Warning, "PossibleMemoryBackedVolumesOnDisk")
```

### データフロー図

```
[入力]                        [処理]                               [出力]

/proc/swaps                   containerManagerImpl初期化           Kubernetes Event
(スワップ状態)       ----->    (container_manager_linux.go     ----> (Reason: "PossibleMemory
                               :220-231)                            BackedVolumesOnDisk",
tmpfs noswap                   IsTmpfsNoswapOptionSupported         Type: Warning)
サポート状態         ----->    チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント定数定義 |
| container_manager_linux.go | `pkg/kubelet/cm/container_manager_linux.go` | ソース | Container Manager初期化とスワップチェック |
