# 通知設計書 41-VolumeResizeFailed

## 概要

本ドキュメントは、Kubernetesにおけるボリュームリサイズ失敗時に発行されるイベント通知「VolumeResizeFailed」の設計を記述する。PersistentVolumeClaim（PVC）のリサイズ操作が何らかの理由で失敗した際に、Warningイベントとして記録される。

### 本通知の処理概要

本通知は、PVCの容量拡張（Expand）操作が失敗した際に発行されるKubernetesイベントである。ボリュームの拡張はコントローラ側（expand_volume操作）とノード側（volume_fs_resize操作）の2段階で行われ、いずれかの段階で失敗した場合にこのイベントが記録される。

**業務上の目的・背景**：ストレージの容量拡張はアプリケーションの継続運用に不可欠な操作である。リサイズ失敗は、アプリケーションがディスク容量不足に陥るリスクを意味するため、運用者に速やかに通知し対処を促す必要がある。

**通知の送信タイミング**：PVCのSpec.Resources.Requestsで要求されたサイズへの拡張処理（ExpandVolumeDevice、NodeExpand等）が失敗した時点、またはPVC/PVのステータス更新に失敗した時点で発行される。具体的には、GenerateExpandVolumeFunc、GenerateExpandAndRecoverVolumeFunc、GenerateExpandInUseVolumeFuncのeventRecorderFuncコールバック内で発行される。

**通知の受信者**：PVCオブジェクトに対するイベントとして記録されるため、PVCを監視しているクラスタ管理者、ストレージ管理者、及びNamespace管理者がkubectl describe pvcやイベント監視ツールを通じて確認できる。ノード側の拡張失敗時はPodオブジェクトにも記録される。

**通知内容の概要**：エラーの詳細メッセージが含まれ、どのPVCのリサイズが失敗し、何が原因であったかを示す。プラグイン名、PVC名、具体的なエラーメッセージが含まれる。

**期待されるアクション**：管理者はエラーメッセージを確認し、ストレージバックエンドの状態確認、PVCの設定見直し、ストレージクラスの確認、必要に応じてストレージプロバイダーへの問い合わせを行うべきである。

## 通知種別

Kubernetesイベント（Event API リソース）- EventType: Warning

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（イベント記録はEventRecorder経由で非同期バッファリング） |
| 優先度 | 高（Warning） |
| リトライ | EventRecorderの内部リトライ機構に依存 |

### 送信先決定ロジック

PVCオブジェクトに対してイベントが記録される。GenerateExpandInUseVolumeFuncでは、ノード側拡張失敗時にPodオブジェクトに対してもイベントが記録される。受信者はKubernetes APIを通じてイベントを取得するユーザーまたは監視システムである。

## 通知テンプレート

### メール通知の場合

該当なし（Kubernetesネイティブイベント）

### 本文テンプレート

```
# コントローラ側拡張失敗時:
"error expanding volume %q of plugin %q: %v"

# PVステータス更新失敗時:
"error updating PV spec capacity for volume %q with : %v"

# PVCステータス更新失敗時:
"error marking pvc %s as resized : %v"
"error updating pvc %s condition for fs resize : %v"

# ノード側拡張失敗時:
eventRecorderFuncにより (*err).Error() がそのまま出力
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| PVC名（修飾名） | 対象PVCのNamespace/名前 | util.GetPersistentVolumeClaimQualifiedName(pvc) | Yes |
| プラグイン名 | ボリュームプラグインの名前 | volumePlugin.GetPluginName() | Yes |
| エラー詳細 | 失敗原因の詳細メッセージ | 各操作のerr | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API操作 | PVC Spec.Resources.Requests変更 | ExpandVolumeDevice失敗 | コントローラ側ボリューム拡張失敗 |
| API操作 | PVC Spec.Resources.Requests変更 | PV/PVCステータス更新失敗 | 拡張後のメタデータ更新失敗 |
| 内部処理 | ノード上のボリュームマウント時 | NodeExpand失敗 | ノード側ファイルシステム拡張失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 拡張が不要な場合 | pvSize >= newSizeの場合、拡張処理自体がスキップされる |
| FSリサイズ不要 | volumePlugin.RequiresFSResize()がfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PVC Spec変更検知] --> B[ExpandablePluginBySpec検索]
    B --> C[ExpandVolumeDevice呼び出し]
    C -->|成功| D[PV容量更新]
    C -->|失敗| E[VolumeResizeFailed イベント発行]
    D -->|成功| F[FSリサイズ必要?]
    D -->|失敗| E
    F -->|Yes| G[MarkForFSResize]
    F -->|No| H[MarkResizeFinished]
    H -->|成功| I[VolumeResizeSuccessful イベント発行]
    H -->|失敗| E
    G --> J[ノード側拡張待ち]
    E --> K[終了]
    I --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PersistentVolumeClaim | リサイズ要求サイズ取得 | Spec.Resources.Requests[storage] |
| PersistentVolume | 現在の容量取得 | Spec.Capacity[storage] |

### テーブル別参照項目詳細

#### PersistentVolumeClaim

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.Resources.Requests[storage] | 要求サイズ | 対象PVC |
| Status.Capacity[storage] | 現在のステータスサイズ | 対象PVC |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | VolumeResizeFailedイベント作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "VolumeResizeFailed" | Warningイベント |
| INSERT | Event.Message | エラー詳細 | 失敗原因 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| プラグイン未検出 | FindExpandablePluginBySpecが失敗 | ストレージドライバーの設定確認 |
| ExpandVolumeDevice失敗 | バックエンドストレージ拡張エラー | ストレージバックエンドの状態確認 |
| PV更新失敗 | API Server接続エラー等 | リトライにより自動復旧 |
| PVCステータス更新失敗 | API Server接続エラー等 | リトライにより自動復旧 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 操作キュー（operationExecutor）による指数バックオフリトライ |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 全てのエラー（リトライ不可能なエラーを除く） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのデフォルト設定に従う（バースト25） |
| 1日あたり上限 | 制限なし（同一イベントは集約される） |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

イベントメッセージにはPVC名、PV名、プラグイン名が含まれるが、機密情報は含まれない。イベントはNamespaceスコープのRBAC制御下にある。

## 備考

- VolumeResizeFailedは3つの異なるGeneratedOperations生成関数（GenerateExpandVolumeFunc、GenerateExpandAndRecoverVolumeFunc、GenerateExpandInUseVolumeFunc）のeventRecorderFuncで発行される
- RecoverVolumeExpansionFailureフィーチャーゲートが有効な場合、GenerateExpandAndRecoverVolumeFunc経由の拡張とリカバリーが行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベント定数の定義とボリューム操作の基本データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 65行目: VolumeResizeFailed定数の定義。66行目: VolumeResizeSuccess定数の定義 |
| 1-2 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 59-73行目: operationGenerator構造体。recorderフィールドがイベント記録に使用される |

**読解のコツ**: keventsはpkg/kubelet/events パッケージのエイリアスである。og.recorder.Eventf()がイベント発行の実体である。

#### Step 2: エントリーポイントを理解する

expand_volume操作とvolume_fs_resize操作の生成関数がエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 134行目: GenerateExpandVolumeFunc インターフェース定義 |

**主要処理フロー**:
1. **1530行目**: expandVolumeFunc開始、PVCのSpec/Status/PVサイズを比較
2. **1537行目**: ExpandVolumeDevice呼び出し（バックエンド拡張）
3. **1552行目**: UpdatePVSize呼び出し（PV容量更新）
4. **1593-1596行目**: eventRecorderFunc - エラー時にVolumeResizeFailedイベント発行

#### Step 3: コントローラ側拡張とリカバリー

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 1607-1649行目: GenerateExpandAndRecoverVolumeFunc - リカバリー機能付き拡張 |

**主要処理フロー**:
- **1631行目**: expandAndRecoverFunction呼び出し
- **1638-1641行目**: eventRecorderFunc - エラー時にVolumeResizeFailedイベント発行

#### Step 4: ノード側拡張（インユース拡張）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 1800-1923行目: GenerateExpandInUseVolumeFunc - ノード側でのボリュームリサイズ |

**主要処理フロー**:
- **1901行目**: doOnlineExpansion呼び出し
- **1912-1915行目**: eventRecorderFunc - エラー時にPodに対しVolumeResizeFailedイベント発行

### プログラム呼び出し階層図

```
operationGenerator.GenerateExpandVolumeFunc()
    |
    +-- expandVolumeFunc()
    |       +-- volumePlugin.ExpandVolumeDevice()
    |       +-- util.UpdatePVSize()
    |       +-- util.MarkResizeFinished() / util.MarkForFSResize()
    |
    +-- eventRecorderFunc()
            +-- og.recorder.Eventf(pvc, Warning, VolumeResizeFailed, ...)

operationGenerator.GenerateExpandAndRecoverVolumeFunc()
    |
    +-- expandVolumeFunc()
    |       +-- og.expandAndRecoverFunction()
    |
    +-- eventRecorderFunc()
            +-- og.recorder.Eventf(pvc, Warning, VolumeResizeFailed, ...)

operationGenerator.GenerateExpandInUseVolumeFunc()
    |
    +-- fsResizeFunc()
    |       +-- og.doOnlineExpansion()
    |               +-- og.nodeExpandVolume()
    |
    +-- eventRecorderFunc()
            +-- og.recorder.Eventf(pod, Warning, VolumeResizeFailed, ...)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

PVC Spec変更              operationGenerator                 Kubernetes Event API
(Requests[storage])  --> .GenerateExpandVolumeFunc()    --> Event(Warning,
                         .ExpandVolumeDevice()               VolumeResizeFailed)
                         .UpdatePVSize()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義（65行目） |
| operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | ソース | ボリューム操作生成とイベント発行の実装 |
| types.go | `pkg/volume/util/types/types.go` | ソース | ボリューム操作の型定義 |
| util.go | `pkg/volume/util/util.go` | ソース | PVC/PVのステータス更新ユーティリティ |
