# 通知設計書 42-VolumeResizeSuccessful

## 概要

本ドキュメントは、Kubernetesにおけるボリュームリサイズ成功時に発行されるイベント通知「VolumeResizeSuccessful」の設計を記述する。PersistentVolumeClaim（PVC）のリサイズ操作が正常に完了した際に、Normalイベントとして記録される。

### 本通知の処理概要

本通知は、PVCの容量拡張操作がコントローラ側で成功した際に発行されるKubernetesイベントである。ボリュームプラグインのExpandVolumeDeviceが成功し、PVの容量更新及びPVCステータスのマーキングが完了した時点でこのイベントが記録される。

**業務上の目的・背景**：ストレージの容量拡張が正常に完了したことをユーザーに通知し、拡張されたストレージが利用可能になったことを確認できるようにする。特にFSリサイズが不要な場合（ブロックボリューム等）は、この通知が拡張完了の最終確認となる。

**通知の送信タイミング**：ExpandVolumeDeviceが成功し、PVの容量更新後、PVCのステータスがResizeFinishedまたはFSResizePendingとしてマークされた後に発行される。具体的には、FSリサイズが不要な場合はMarkResizeFinished成功後（1573行目）、expandAndRecoverFunction内でも同様に発行される（1782行目）。

**通知の受信者**：PVCオブジェクトに対するイベントとして記録されるため、PVCを監視しているクラスタ管理者、ストレージ管理者がkubectl describe pvcやイベント監視ツールを通じて確認できる。

**通知内容の概要**：「ExpandVolume succeeded for volume {PVC修飾名}」という成功メッセージが含まれる。

**期待されるアクション**：特別なアクションは不要。拡張が完了したことの確認として利用する。FSリサイズが必要な場合は、後続のFileSystemResizeSuccessfulイベントを待つ必要がある。

## 通知種別

Kubernetesイベント（Event API リソース）- EventType: Normal

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（EventRecorder経由） |
| 優先度 | 中（Normal） |
| リトライ | EventRecorderの内部リトライ機構に依存 |

### 送信先決定ロジック

PVCオブジェクトに対してイベントが記録される。og.recorder.Eventf(pvc, v1.EventTypeNormal, kevents.VolumeResizeSuccess, successMsg)により、対象PVCのイベントストリームに追加される。

## 通知テンプレート

### メール通知の場合

該当なし（Kubernetesネイティブイベント）

### 本文テンプレート

```
"ExpandVolume succeeded for volume %s"
```

%sにはutil.GetPersistentVolumeClaimQualifiedName(pvc)の結果（namespace/name形式）が入る。

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| PVC修飾名 | 対象PVCのNamespace/名前 | util.GetPersistentVolumeClaimQualifiedName(pvc) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API操作 | PVC Spec.Resources.Requests変更 | ExpandVolumeDevice成功かつFSリサイズ不要 | コントローラ側で拡張完了 |
| API操作 | PVC Spec.Resources.Requests変更 | expandAndRecoverFunction成功かつFSリサイズ不要 | リカバリー付き拡張完了 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| FSリサイズが必要な場合 | RequiresFSResize()がtrueかつfsVolumeの場合、VolumeResizeSuccessfulは発行されず、MarkForFSResizeが呼ばれる |
| pvSize >= newSize | PVサイズが既に要求サイズ以上の場合、ExpandVolumeDeviceは呼ばれない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PVC Spec変更検知] --> B[ExpandVolumeDevice呼び出し]
    B -->|成功| C[UpdatePVSize]
    B -->|失敗| D[VolumeResizeFailed]
    C -->|成功| E{FSリサイズ必要?}
    E -->|No| F[MarkResizeFinished]
    E -->|Yes| G[MarkForFSResize]
    F -->|成功| H[VolumeResizeSuccessful イベント発行]
    G --> I[ノード側拡張へ]
    H --> J[終了]
    D --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PersistentVolumeClaim | リサイズ要求サイズ取得 | Spec.Resources.Requests[storage] |
| PersistentVolume | 現在の容量取得 | Spec.Capacity[storage] |

### テーブル別参照項目詳細

#### PersistentVolumeClaim

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.Resources.Requests[storage] | 要求サイズ | 対象PVC |
| Status.Capacity[storage] | 現在のステータスサイズ | 対象PVC |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| PersistentVolume | UPDATE | Spec.Capacity更新 |
| PersistentVolumeClaim | UPDATE | Status.Capacity更新（MarkResizeFinished） |
| Event | INSERT | VolumeResizeSuccessfulイベント作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "VolumeResizeSuccessful" | Normalイベント |
| INSERT | Event.Message | "ExpandVolume succeeded for volume ..." | 成功メッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | 本イベントは成功時のみ発行 | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（成功イベント） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのデフォルト設定に従う |
| 1日あたり上限 | 制限なし（同一イベントは集約される） |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

イベントメッセージにはPVC名（namespace/name）のみが含まれ、機密情報は含まれない。

## 備考

- VolumeResizeSuccessfulはコントローラ側拡張の成功を示す。FSリサイズが必要な場合は別途FileSystemResizeSuccessfulイベントが発行される
- expandAndRecoverFunction内（1782行目）でも同様のイベントが発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 66行目: VolumeResizeSuccess = "VolumeResizeSuccessful" 定数定義 |

**読解のコツ**: 定数名VolumeResizeSuccessとイベント文字列"VolumeResizeSuccessful"が異なる点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 1530-1604行目: GenerateExpandVolumeFunc - expandVolumeFuncの実装 |

**主要処理フロー**:
1. **1536行目**: pvSize < newSizeの比較でExpandが必要か判定
2. **1537行目**: ExpandVolumeDevice呼び出し
3. **1565行目**: RequiresFSResize()チェック
4. **1567行目**: MarkResizeFinished呼び出し
5. **1573行目**: VolumeResizeSuccessイベント発行

#### Step 3: リカバリー付き拡張フロー

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 1750-1790行目: expandAndRecoverFunction内での成功イベント発行 |

**主要処理フロー**:
- **1782行目**: og.recorder.Eventf(pvc, v1.EventTypeNormal, kevents.VolumeResizeSuccess, successMsg)

### プログラム呼び出し階層図

```
operationGenerator.GenerateExpandVolumeFunc()
    |
    +-- expandVolumeFunc()
    |       +-- volumePlugin.ExpandVolumeDevice()
    |       +-- util.UpdatePVSize()
    |       +-- util.MarkResizeFinished()
    |       +-- og.recorder.Eventf(pvc, Normal, VolumeResizeSuccess, ...)
    |
    +-- eventRecorderFunc() [エラー時のみVolumeResizeFailed]

operationGenerator.GenerateExpandAndRecoverVolumeFunc()
    |
    +-- expandVolumeFunc()
            +-- og.expandAndRecoverFunction()
                    +-- og.recorder.Eventf(pvc, Normal, VolumeResizeSuccess, ...)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

PVC Spec変更              operationGenerator                 Kubernetes Event API
(Requests[storage])  --> .ExpandVolumeDevice()          --> Event(Normal,
                         .UpdatePVSize()                     VolumeResizeSuccessful)
                         .MarkResizeFinished()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | VolumeResizeSuccess定数定義（66行目） |
| operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | ソース | 拡張操作生成と成功イベント発行 |
| util.go | `pkg/volume/util/util.go` | ソース | MarkResizeFinished、UpdatePVSize等のユーティリティ |
