# 通知設計書 43-FileSystemResizeFailed

## 概要

本ドキュメントは、Kubernetesにおけるファイルシステムリサイズ失敗時に発行されるイベント通知「FileSystemResizeFailed」の設計を記述する。ボリュームのファイルシステムレベルでの拡張操作が失敗した際に、Warningイベントとして記録される。

### 本通知の処理概要

本通知は、ノード上でボリュームのファイルシステムを拡張する処理（NodeExpandVolume）が失敗した際に発行されるKubernetesイベントである。ボリュームの拡張は2段階で行われ、コントローラ側でのバックエンドストレージ拡張後、ノード側でファイルシステムの拡張が必要な場合にNodeExpandVolumeが呼ばれる。このノード側拡張が失敗した際に本イベントが発行される。

**業務上の目的・背景**：ストレージバックエンドの拡張が完了していても、ファイルシステムレベルでの拡張が完了しなければアプリケーションは増加した容量を利用できない。ファイルシステムリサイズの失敗はアプリケーションに直接影響するため、速やかに運用者に通知する必要がある。

**通知の送信タイミング**：NodeExpandVolume処理中に、ボリュームが読み取り専用（ReadOnly）でファイルシステム拡張が不可能な場合に発行される。具体的には、expandVolumeDuringMount関数（マウント時拡張）およびlegacyCallNodeExpandOnPlugin関数内で、ReadOnlyチェック後に発行される。

**通知の受信者**：PodオブジェクトおよびPVCオブジェクトの両方に対してイベントが記録される。Pod所有者、Namespace管理者、ストレージ管理者がkubectl describe pod/pvcやイベント監視ツールを通じて確認できる。

**通知内容の概要**：「MountVolume.NodeExpandVolume failed: requested read-only file system」というメッセージが含まれ、ReadOnlyボリュームでの拡張試行が原因であることを示す。

**期待されるアクション**：管理者はボリュームのReadOnly設定を確認し、必要に応じてReadOnlyフラグを解除するか、別途拡張操作を計画すべきである。

## 通知種別

Kubernetesイベント（Event API リソース）- EventType: Warning

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（EventRecorder経由） |
| 優先度 | 高（Warning） |
| リトライ | EventRecorderの内部リトライ機構に依存 |

### 送信先決定ロジック

PodオブジェクトとPVCオブジェクトの両方に対してイベントが記録される。og.recorder.Eventf()が2回呼ばれ、1回目はvolumeToMount.Podに対して、2回目はpvcに対して同じメッセージでイベントを発行する。

## 通知テンプレート

### メール通知の場合

該当なし（Kubernetesネイティブイベント）

### 本文テンプレート

```
"MountVolume.NodeExpandVolume failed for volume %q (UniqueName: %q) pod %q (UID: %q) : requested read-only file system"
```

GenerateMsg関数によりsimpleMsgが生成される。

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ボリューム名 | VolumeSpecの名前 | volumeToMount.VolumeSpec | Yes |
| ユニーク名 | ボリュームの一意識別子 | volumeToMount.VolumeName | Yes |
| Pod名 | 対象Podの名前 | volumeToMount.Pod | Yes |
| Pod UID | 対象PodのUID | volumeToMount.Pod.UID | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | マウント時ボリューム拡張 | ReadOnlyボリュームでFS拡張を試行 | expandVolumeDuringMount内（1965-1966行目） |
| 内部処理 | オンラインボリューム拡張 | ReadOnlyボリュームでFS拡張を試行 | legacyCallNodeExpandOnPlugin内（2035-2036行目） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ReadOnlyでない場合 | 通常のNodeExpand処理が実行され、FileSystemResizeFailed は発行されない |
| PVCステータスサイズ >= PVSpecサイズ | 拡張不要のため処理がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[マウント/拡張トリガー] --> B{PVCステータス < PVスペック容量?}
    B -->|No| C[拡張不要 - スキップ]
    B -->|Yes| D{ReadOnlyボリューム?}
    D -->|Yes| E[FileSystemResizeFailed イベント発行（Pod）]
    E --> F[FileSystemResizeFailed イベント発行（PVC）]
    D -->|No| G[NodeExpandVolume実行]
    G -->|成功| H[FileSystemResizeSuccessful]
    G -->|失敗| I[エラー処理]
    F --> J[終了（true返却）]
    C --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PersistentVolumeClaim | ステータス容量取得 | Status.Capacity[storage] |
| PersistentVolume | スペック容量取得 | Spec.Capacity[storage] |

### テーブル別参照項目詳細

#### PersistentVolumeClaim

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Status.Capacity[storage] | 現在のステータスサイズ | 対象PVC |

#### PersistentVolume

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.Capacity[storage] | PVのスペックサイズ | 対象PV |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | FileSystemResizeFailedイベント作成（Pod用とPVC用の2件） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "FileSystemResizeFailed" | Warningイベント |
| INSERT | Event.Message | simpleMsg | ReadOnly失敗メッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ReadOnlyファイルシステム | VolumeSpec.ReadOnlyがtrue | ReadOnly設定の見直し |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | リトライなし（ReadOnlyは設定変更なしでは解消しない） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのデフォルト設定に従う |
| 1日あたり上限 | 制限なし（同一イベントは集約される） |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

イベントメッセージにはPod名、PVC名、ボリューム名が含まれるが、機密情報は含まれない。イベントはNamespaceスコープのRBAC制御下にある。

## 備考

- FileSystemResizeFailedは現在のソースコードではReadOnlyボリュームに対する拡張試行時にのみ発行される
- PodとPVCの両方にイベントが発行されるため、どちらからでも問題を検出可能
- 処理自体はtrue（成功）を返すため、マウント処理はブロックされない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 67行目: FileSystemResizeFailed定数定義 |

**読解のコツ**: FileSystemResizeFailedとVolumeResizeFailedは異なるイベント。前者はノード側FS拡張失敗、後者はコントローラ側ボリューム拡張失敗を示す。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 1949行目: expandVolumeDuringMount関数 |

**主要処理フロー**:
1. **1960-1961行目**: pvcStatusCapとpvSpecCapの比較
2. **1962行目**: ReadOnlyチェック
3. **1965行目**: Podに対しFileSystemResizeFailedイベント発行
4. **1966行目**: PVCに対しFileSystemResizeFailedイベント発行

#### Step 3: レガシー拡張フロー

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 2093-2149行目: legacyCallNodeExpandOnPlugin関数 |

**主要処理フロー**:
- **2032行目**: ReadOnlyチェック
- **2035行目**: Podに対しFileSystemResizeFailedイベント発行
- **2036行目**: PVCに対しFileSystemResizeFailedイベント発行

### プログラム呼び出し階層図

```
operationGenerator.GenerateMountVolumeFunc()
    |
    +-- mountVolumeFunc()
            +-- og.expandVolumeDuringMount()
                    +-- [ReadOnly判定]
                    +-- og.recorder.Eventf(pod, Warning, FileSystemResizeFailed, ...)
                    +-- og.recorder.Eventf(pvc, Warning, FileSystemResizeFailed, ...)

operationGenerator.GenerateExpandInUseVolumeFunc()
    |
    +-- fsResizeFunc()
            +-- og.doOnlineExpansion()
                    +-- og.nodeExpandVolume()
                            +-- og.legacyCallNodeExpandOnPlugin()
                                    +-- [ReadOnly判定]
                                    +-- og.recorder.Eventf(pod, Warning, FileSystemResizeFailed, ...)
                                    +-- og.recorder.Eventf(pvc, Warning, FileSystemResizeFailed, ...)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

PVC Status.Capacity      expandVolumeDuringMount()          Kubernetes Event API
PV Spec.Capacity    -->  ReadOnlyチェック               --> Event(Warning,
VolumeSpec.ReadOnly                                         FileSystemResizeFailed)
                                                            x2（Pod + PVC）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | FileSystemResizeFailed定数定義（67行目） |
| operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | ソース | expandVolumeDuringMount、legacyCallNodeExpandOnPluginでのイベント発行 |
