# 通知設計書 44-FileSystemResizeSuccessful

## 概要

本ドキュメントは、Kubernetesにおけるファイルシステムリサイズ成功時に発行されるイベント通知「FileSystemResizeSuccessful」の設計を記述する。ボリュームのファイルシステムレベルでの拡張操作が正常に完了した際に、Normalイベントとして記録される。

### 本通知の処理概要

本通知は、ノード上でボリュームのファイルシステム拡張（NodeExpandVolume）が成功した際に発行されるKubernetesイベントである。コントローラ側のバックエンドストレージ拡張後、ノード側でファイルシステムの拡張が必要な場合にNodeExpandVolumeが呼ばれ、成功時に本イベントが発行される。

**業務上の目的・背景**：ファイルシステムの拡張が完了したことを通知し、アプリケーションが増加した容量を利用可能になったことを確認できるようにする。VolumeResizeSuccessfulがコントローラ側の拡張完了を示すのに対し、本イベントはノード側のFS拡張完了を示す最終確認イベントである。

**通知の送信タイミング**：NodeExpandVolume（NodeExpand）がエラーなく完了した時点で発行される。expandVolumeDuringMount関数内のnodeExpandVolume呼び出し後、またはlegacyCallNodeExpandOnPlugin関数内のNodeExpand呼び出し後に発行される。

**通知の受信者**：PodオブジェクトおよびPVCオブジェクトの両方に対してイベントが記録される。Pod所有者、Namespace管理者、ストレージ管理者が確認できる。

**通知内容の概要**：「MountVolume.NodeExpandVolume succeeded for volume ... on node ...」というメッセージが含まれ、どのボリュームのFS拡張が完了したかを示す。

**期待されるアクション**：特別なアクションは不要。FS拡張完了の確認として利用する。PVCのStatus.Capacityが更新されていることを確認できる。

## 通知種別

Kubernetesイベント（Event API リソース）- EventType: Normal

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（EventRecorder経由） |
| 優先度 | 中（Normal） |
| リトライ | EventRecorderの内部リトライ機構に依存 |

### 送信先決定ロジック

PodオブジェクトとPVCオブジェクトの両方に対してイベントが記録される。og.recorder.Eventf()が2回呼ばれる。

## 通知テンプレート

### メール通知の場合

該当なし（Kubernetesネイティブイベント）

### 本文テンプレート

```
"MountVolume.NodeExpandVolume succeeded for volume %q (UniqueName: %q) pod %q (UID: %q) : %s"
```

最後の%sにはノード名が入る。GenerateMsg関数により生成される。

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ボリューム名 | VolumeSpecの名前 | volumeToMount.VolumeSpec | Yes |
| ユニーク名 | ボリュームの一意識別子 | volumeToMount.VolumeName | Yes |
| Pod名 | 対象Podの名前 | volumeToMount.Pod | Yes |
| Pod UID | 対象PodのUID | volumeToMount.Pod.UID | Yes |
| ノード名 | 処理を実行したノード | volumeToMount.Pod.Spec.NodeName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | マウント時ボリューム拡張 | NodeExpand成功 | legacyCallNodeExpandOnPlugin内（2133-2134行目） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 拡張が不要な場合 | PVCステータスサイズ >= PVスペックサイズ |
| ReadOnlyボリューム | FileSystemResizeFailedが発行される |
| NodeExpand未サポート | OperationNotSupportedErrorの場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[マウント/拡張トリガー] --> B{PVCステータス < PVスペック?}
    B -->|No| C[拡張不要]
    B -->|Yes| D{ReadOnly?}
    D -->|Yes| E[FileSystemResizeFailed]
    D -->|No| F[NodeExpand実行]
    F -->|成功| G[FileSystemResizeSuccessful イベント発行（Pod）]
    G --> H[FileSystemResizeSuccessful イベント発行（PVC）]
    H --> I[MarkFSResizeFinished]
    F -->|失敗| J[エラー処理]
    I --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PersistentVolumeClaim | ステータス容量比較 | Status.Capacity[storage] |
| PersistentVolume | スペック容量比較 | Spec.Capacity[storage] |

### テーブル別参照項目詳細

#### PersistentVolumeClaim

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Status.Capacity[storage] | 現在のステータスサイズ | 対象PVC |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| PersistentVolumeClaim | UPDATE | Status.Capacity更新（MarkFSResizeFinished） |
| Event | INSERT | FileSystemResizeSuccessfulイベント作成（Pod用とPVC用の2件） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "FileSystemResizeSuccessful" | Normalイベント |
| INSERT | Event.Message | simpleMsg | 成功メッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | 本イベントは成功時のみ発行 | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（成功イベント） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのデフォルト設定に従う |
| 1日あたり上限 | 制限なし（同一イベントは集約される） |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

イベントメッセージにはPod名、PVC名、ボリューム名、ノード名が含まれるが、機密情報は含まれない。

## 備考

- FileSystemResizeSuccessfulはノード側FS拡張の完了を示す。コントローラ側はVolumeResizeSuccessfulで通知される
- 成功後、PVCのStatus.CapacityがNewSize（PVスペック容量）に更新される（MarkFSResizeFinished）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 69行目: FileSystemResizeSuccess = "FileSystemResizeSuccessful" 定数定義 |

**読解のコツ**: 定数名FileSystemResizeSuccessとイベント文字列"FileSystemResizeSuccessful"が異なる点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 2093-2149行目: legacyCallNodeExpandOnPlugin関数 |

**主要処理フロー**:
1. **2111行目**: expandableVolumePlugin.NodeExpand(rsOpts)呼び出し
2. **2132行目**: GenerateMsgで成功メッセージ生成
3. **2133行目**: Podに対しFileSystemResizeSuccessイベント発行
4. **2134行目**: PVCに対しFileSystemResizeSuccessイベント発行
5. **2143行目**: MarkFSResizeFinishedでPVCステータス更新

### プログラム呼び出し階層図

```
operationGenerator.GenerateMountVolumeFunc()
    |
    +-- mountVolumeFunc()
            +-- og.expandVolumeDuringMount()
                    +-- og.nodeExpandVolume()
                            +-- og.legacyCallNodeExpandOnPlugin()
                                    +-- expandableVolumePlugin.NodeExpand()
                                    +-- og.recorder.Eventf(pod, Normal, FileSystemResizeSuccess, ...)
                                    +-- og.recorder.Eventf(pvc, Normal, FileSystemResizeSuccess, ...)
                                    +-- util.MarkFSResizeFinished()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

PVC Status.Capacity      legacyCallNodeExpandOnPlugin()     Kubernetes Event API
PV Spec.Capacity    -->  NodeExpand()                   --> Event(Normal,
NodeResizeOptions        MarkFSResizeFinished()              FileSystemResizeSuccessful)
                                                            x2（Pod + PVC）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | FileSystemResizeSuccess定数定義（69行目） |
| operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | ソース | NodeExpand成功時のイベント発行 |
| util.go | `pkg/volume/util/util.go` | ソース | MarkFSResizeFinished等のユーティリティ |
