# 通知設計書 49-SuccessfulMountVolume

## 概要

本ドキュメントは、Kubernetesにおけるボリュームのマウント成功時に発行されるイベント通知「SuccessfulMountVolume」の設計を記述する。ボリュームがPod内のコンテナに正常にマウントされた際に、Normalイベントとして記録される。

### 本通知の処理概要

本通知は、ボリュームのマウント/マップ操作が成功した際に発行されるKubernetesイベントである。ブロックボリュームのデバイスマッピング成功時に発行される（ファイルシステムボリュームのマウント成功時にはイベントは発行されない点に注意）。GenerateMapVolumeFuncのmapVolumeFunc内でMapPodDevice成功後に記録される。

**業務上の目的・背景**：ボリュームのマウント/マップ成功はPod起動の重要なマイルストーンであり、ユーザーのデバッグや運用監視を支援する。特にボリューム関連の問題調査時に、マウントが成功しているかどうかの確認に有用である。

**通知の送信タイミング**：GenerateMapVolumeFuncのmapVolumeFunc内で、ブロックボリュームのMapPodDeviceが成功した時点で発行される。グローバルマップパスとPodデバイスマップパスの2つのマッピング成功に対してそれぞれ発行される。

**通知の受信者**：Podオブジェクトに対するイベントとして記録されるため、Pod所有者、Namespace管理者がkubectl describe podやイベント監視ツールを通じて確認できる。

**通知内容の概要**：「MapVolume.MapPodDevice succeeded for volume ... globalMapPath/volumeMapPath ...」という成功メッセージが含まれる。

**期待されるアクション**：特別なアクションは不要。マウント/マップ成功の確認として利用する。

## 通知種別

Kubernetesイベント（Event API リソース）- EventType: Normal

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（EventRecorder経由） |
| 優先度 | 低（Normal） |
| リトライ | EventRecorderの内部リトライ機構に依存 |

### 送信先決定ロジック

Podオブジェクトに対してイベントが記録される。volumeToMount.Podが対象。

## 通知テンプレート

### メール通知の場合

該当なし（Kubernetesネイティブイベント）

### 本文テンプレート

```
# グローバルマップパス成功:
"MapVolume.MapPodDevice succeeded for volume %q (UniqueName: %q) pod %q (UID: %q) : globalMapPath %q"

# Podデバイスマップパス成功:
"MapVolume.MapPodDevice succeeded for volume %q (UniqueName: %q) pod %q (UID: %q) : volumeMapPath %q"
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| ボリューム名 | VolumeSpecの名前 | volumeToMount.VolumeSpec | Yes |
| ユニーク名 | ボリュームの一意識別子 | volumeToMount.VolumeName | Yes |
| Pod名 | 対象Podの名前 | volumeToMount.Pod | Yes |
| Pod UID | 対象PodのUID | volumeToMount.Pod.UID | Yes |
| globalMapPath | グローバルマップパス | blockVolumeMapper.GetGlobalMapPath() | Yes |
| volumeMapPath | Podデバイスマップパス | blockVolumeMapper.GetPodDeviceMapPath() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | MapPodDevice成功 | グローバルマップ成功 | operation_generator.go 1105行目 |
| 内部処理 | MapPodDevice成功 | Podデバイスマップ成功 | operation_generator.go 1111行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| マッピング失敗 | FailedMapVolumeが発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[mapVolumeFunc実行] --> B[GetGlobalMapPath]
    B --> C[WaitForAttach]
    C --> D[SetUpDevice]
    D --> E[MapPodDevice]
    E -->|成功| F[SuccessfulMountVolume イベント発行（globalMapPath）]
    F --> G[SuccessfulMountVolume イベント発行（volumeMapPath）]
    G --> H[ノードリサイズ処理]
    E -->|失敗| I[エラー処理]
    H --> J[MarkVolumeAsMounted]
    J --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| VolumeToMount | マウント対象情報 | VolumeSpec, Pod |

### テーブル別参照項目詳細

#### VolumeToMount

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| VolumeSpec | ボリューム仕様 | 対象ボリューム |
| Pod | イベント発行対象 | 対象ボリューム |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | SuccessfulMountVolumeイベント作成（2件：globalMapPath + volumeMapPath） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "SuccessfulMountVolume" | Normalイベント |
| INSERT | Event.Message | simpleMsg | 成功メッセージ（パス情報含む） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 該当なし | 本イベントは成功時のみ発行 | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（成功イベント） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのデフォルト設定に従う |
| 1日あたり上限 | 制限なし（同一イベントは集約される） |

### 配信時間帯

制限なし（24時間365日）

## セキュリティ考慮事項

イベントメッセージにはPod名、ボリューム名、マップパスが含まれるが、機密情報は含まれない。

## 備考

- SuccessfulMountVolumeは現在のソースコードではブロックボリュームのMapPodDevice成功時のみ発行される
- 1回のマッピング操作で2件のイベントが発行される（globalMapPathとvolumeMapPathの各成功）
- ファイルシステムボリュームのマウント成功時には明示的なSuccessfulMountVolumeイベントは発行されない
- グローバルマップパスの成功メッセージはverbosity=4（低優先度ログ）、Podマップパスの成功メッセージはverbosity=1

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 73行目: SuccessfulMountVolume定数定義 |

**読解のコツ**: SuccessfulMountVolumeはマウントだけでなく、ブロックボリュームのマッピング成功にも使用される汎用的な成功イベント名。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | 1100-1112行目: mapVolumeFunc内での成功イベント発行 |

**主要処理フロー**:
1. **1103行目**: globalMapPathの成功メッセージ生成
2. **1105行目**: SuccessfulMountVolumeイベント発行（globalMapPath）
3. **1109行目**: volumeMapPathの成功メッセージ生成
4. **1111行目**: SuccessfulMountVolumeイベント発行（volumeMapPath）

### プログラム呼び出し階層図

```
operationGenerator.GenerateMapVolumeFunc()
    |
    +-- mapVolumeFunc()
            +-- GetGlobalMapPath()
            +-- WaitForAttach()
            +-- SetUpDevice()
            +-- MapPodDevice()
            +-- og.recorder.Eventf(pod, Normal, SuccessfulMountVolume, ...) [globalMapPath]
            +-- og.recorder.Eventf(pod, Normal, SuccessfulMountVolume, ...) [volumeMapPath]
            +-- nodeExpandVolume() [必要な場合]
            +-- MarkVolumeAsMounted()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

VolumeToMount             operationGenerator                 Kubernetes Event API
(VolumeSpec,         --> .mapVolumeFunc()               --> Event(Normal,
 Pod)                    MapPodDevice()                      SuccessfulMountVolume)
                                                             x2（globalMapPath + volumeMapPath）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | SuccessfulMountVolume定数定義（73行目） |
| operation_generator.go | `pkg/volume/util/operationexecutor/operation_generator.go` | ソース | mapVolumeFuncでの成功イベント発行（1100-1112行目） |
