# 通知設計書 51-FailedPrepareDynamicResources

## 概要

本ドキュメントは、Kubernetes kubeletのランタイムマネージャが動的リソース割り当て（Dynamic Resource Allocation: DRA）の準備に失敗した際に発行されるイベント通知「FailedPrepareDynamicResources」の設計について記述する。

### 本通知の処理概要

**業務上の目的・背景**：Dynamic Resource Allocation（DRA）はKubernetesのフィーチャーゲート `DynamicResourceAllocation` で制御される機能であり、GPU・FPGA・特殊ハードウェアなどの動的リソースをPodに割り当てるために使用される。この通知は、DRAリソースの準備段階で障害が発生した場合にクラスタ管理者やアプリケーション運用者に問題を通知し、迅速な対応を促すために存在する。リソース準備の失敗はPodの起動を完全にブロックするため、早期検知が重要である。

**通知の送信タイミング**：kubeletのランタイムマネージャ（`kuberuntime_manager.go`）がPodのサンドボックス作成前に `PrepareDynamicResources` を呼び出し、その呼び出しが失敗した際に送信される。具体的には、`SyncPod` メソッド内でPodサンドボックスの再作成が必要と判断された後、サンドボックス作成の直前に実行される。

**通知の受信者**：Podオブジェクトに対するKubernetes Eventとして発行されるため、`kubectl describe pod` や `kubectl get events` でPodの状態を監視しているクラスタ管理者、アプリケーション運用者が受信者となる。

**通知内容の概要**：「Failed to prepare dynamic resources: {エラー詳細}」というメッセージで、動的リソース準備の具体的な失敗理由が含まれる。

**期待されるアクション**：受信者はエラーメッセージを確認し、DRAドライバーの状態確認、ResourceClaimの定義確認、ノード上のリソース可用性確認などを行い、問題を解決した上でPodを再デプロイする。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（SyncPod処理フロー内で同期的に発行） |
| 優先度 | 高（Pod起動がブロックされるため） |
| リトライ | kubelet側のPod同期ループにより自動的に再試行される |

### 送信先決定ロジック

Podオブジェクトへの参照（`ref.GetReference`）を取得し、そのPodに対してEventを発行する。送信先はKubernetes APIサーバのEventリソースであり、特定のNamespace/Pod名に関連付けられる。

## 通知テンプレート

### Kubernetes Event

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | kubelet |
| EventType | Warning |
| Reason | FailedPrepareDynamicResources |
| 関連オブジェクト | Pod |

### 本文テンプレート

```
Failed to prepare dynamic resources: %v
```

`%v` にはPrepareDynamicResourcesから返されたエラー内容が展開される。

### 添付ファイル

該当なし（Kubernetes Eventには添付ファイルの概念はない）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | 動的リソース準備時のエラー内容 | PrepareDynamicResources()の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| kubelet内部処理 | SyncPod実行時のDRAリソース準備 | フィーチャーゲート `DynamicResourceAllocation` が有効かつ `PrepareDynamicResources` がエラーを返した場合 | Podサンドボックス作成前に動的リソースの準備が試行される |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| フィーチャーゲート無効 | `DynamicResourceAllocation` フィーチャーゲートが無効の場合、PrepareDynamicResources自体が呼ばれないため通知は発行されない |
| Pod参照取得失敗 | `ref.GetReference` がエラーを返した場合、Event発行はスキップされる（ログのみ出力） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SyncPod開始] --> B{Podサンドボックスの再作成が必要か?}
    B -->|No| Z[通常処理継続]
    B -->|Yes| C{DynamicResourceAllocation<br/>フィーチャーゲート有効?}
    C -->|No| D[サンドボックス作成へ]
    C -->|Yes| E[PrepareDynamicResources呼び出し]
    E --> F{準備成功?}
    F -->|Yes| D
    F -->|No| G[Pod参照を取得]
    G --> H{参照取得成功?}
    H -->|No| I[エラーログ出力のみ]
    H -->|Yes| J[Warning Event発行:<br/>FailedPrepareDynamicResources]
    J --> K[SyncPod処理を中断しreturn]
    I --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pods | 対象Podの情報取得 | kubeletのローカルキャッシュから参照 |
| ResourceClaims | DRAリソースクレームの状態確認 | PrepareDynamicResources内部で参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events | INSERT | FailedPrepareDynamicResourcesイベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| DRAドライバー未応答 | DRAドライバーがノード上で動作していない場合 | DRAドライバーのデプロイ状態を確認 |
| ResourceClaim未割当 | ResourceClaimがまだスケジューラにより割り当てられていない場合 | スケジューラログを確認し、リソース可用性を検証 |
| ノードリソース不足 | ノード上に要求されたリソースが存在しない場合 | ノードのリソース状態を確認し、適切なノードにスケジュール |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | kubeletのSyncPodループにより無制限に再試行 |
| リトライ間隔 | kubeletの同期間隔（デフォルト10秒）に依存 |
| リトライ対象エラー | PrepareDynamicResourcesの全エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に準拠 |
| 1日あたり上限 | 同一理由のイベントは集約される（Event deduplication） |

### 配信時間帯

制限なし（kubeletの稼働中は常時発行可能）

## セキュリティ考慮事項

- イベントメッセージにはエラー詳細が含まれるが、機密情報（シークレット等）は含まれない設計
- Kubernetes RBACによりEventの読み取り権限が制御される
- DRAリソース情報はResourceClaimオブジェクト経由で参照されるため、直接的な機密情報の漏洩リスクは低い

## 備考

- Dynamic Resource Allocation（DRA）はKubernetes v1.26でAlpha機能として導入された機能
- フィーチャーゲート `DynamicResourceAllocation` が有効な場合のみ関連する通知
- この通知が発行された場合、Podは起動に失敗し、Pending状態のままとなる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベント定数の定義を確認し、通知の名称と関連する定数を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 84行目: `FailedPrepareDynamicResources` 定数が定義されている。kubeletが使用する全イベント理由の一覧を把握できる |

**読解のコツ**: このファイルはkubeletが発行する全イベントの定数定義であり、カテゴリ別にグループ化されている。`FailedPrepareDynamicResources` はkubelet eventセクション（56行目以降）に定義されている。

#### Step 2: エントリーポイントを理解する

処理の起点となるSyncPodメソッド内での動的リソース準備処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | 1530-1541行目: フィーチャーゲートチェック後にPrepareDynamicResourcesを呼び出し、失敗時にイベントを発行する処理 |

**主要処理フロー**:
1. **1530行目**: `DynamicResourceAllocation` フィーチャーゲートの有効性チェック
2. **1531行目**: `m.runtimeHelper.PrepareDynamicResources(ctx, pod)` の呼び出し
3. **1532行目**: エラー時にPod参照を取得
4. **1537行目**: `m.recorder.Eventf(ref, v1.EventTypeWarning, events.FailedPrepareDynamicResources, ...)` でイベント発行

#### Step 3: フィーチャーゲート制御を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | features（定数定義） | `pkg/features/` | `DynamicResourceAllocation` フィーチャーゲートの定義を確認 |

### プログラム呼び出し階層図

```
kubelet.SyncPod()
    |
    +-- kuberuntime.SyncPod()
            |
            +-- utilfeature.DefaultFeatureGate.Enabled(features.DynamicResourceAllocation)
            |       |
            |       +-- (true) runtimeHelper.PrepareDynamicResources(ctx, pod)
            |               |
            |               +-- (error) ref.GetReference(legacyscheme.Scheme, pod)
            |               |           |
            |               |           +-- recorder.Eventf(ref, Warning, FailedPrepareDynamicResources, ...)
            |               |
            |               +-- (success) -> continue to createPodSandbox
            |
            +-- createPodSandbox()
```

### データフロー図

```
[入力]                    [処理]                              [出力]

Pod Spec          ---->  SyncPod()                    ---->  Kubernetes Event
(ResourceClaims)         |                                    (FailedPrepareDynamicResources)
                         +-> PrepareDynamicResources()
                         |   (DRA driver interaction)
                         +-> Error handling
                         +-> Event recording
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント定数定義（84行目） |
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | SyncPod内でのDRAリソース準備とイベント発行（1530-1541行目） |
| dra.go | `test/e2e/dra/dra.go` | テスト | DRA関連のE2Eテスト |
