# 通知設計書 55-VolumeRecycled

## 概要

本ドキュメントは、PersistentVolume（PV）のリサイクル処理が正常に完了した際に発行されるイベント通知「VolumeRecycled」の設計について記述する。

### 本通知の処理概要

**業務上の目的・背景**：PVのReclaimPolicyが `Recycle` に設定されている場合、PVCが解放された後にPVのデータをクリーンアップして再利用可能にするリサイクル処理が実行される。この通知はリサイクルが正常に完了したことをクラスタ管理者に通知し、PVが再び利用可能な状態に戻ったことを確認できるようにする。リサイクル完了後、PVはAvailable状態に戻り、新しいPVCにバインド可能となる。

**通知の送信タイミング**：PV ControllerのrecycleVolumeOperation内で、プラグインのRecycle処理が成功した直後に発行される。イベント発行後、PVのアンバインド処理（unbindVolume）が実行される。

**通知の受信者**：PVオブジェクトに対するKubernetes Eventとして発行される。`kubectl describe pv` や `kubectl get events` で監視しているクラスタ管理者、ストレージ管理者が受信者となる。

**通知内容の概要**：「Volume recycled」という固定メッセージで、リサイクルが正常に完了したことを示す。

**期待されるアクション**：通常は対応不要。PVが再びAvailable状態になるため、新しいPVCが自動的にバインドされることを確認する。

## 通知種別

Kubernetes Event（EventType: Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（recycleVolumeOperationはgoroutineで実行） |
| 優先度 | 低（正常完了通知） |
| リトライ | 不要（成功通知のため） |

### 送信先決定ロジック

PVオブジェクトに対してEventを発行する。

## 通知テンプレート

### Kubernetes Event

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | pv controller |
| EventType | Normal |
| Reason | VolumeRecycled |
| 関連オブジェクト | PersistentVolume |

### 本文テンプレート

```
Volume recycled
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| （なし） | 固定メッセージのためテンプレート変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| PV Controller同期 | recycleVolumeOperation | plugin.Recycle()が成功 | pv_controller.go 1307-1309行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リサイクル失敗 | plugin.Recycle()がエラーを返した場合はVolumeFailedRecycleが発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[recycleVolumeOperation] --> B[リサイクルプラグイン検索]
    B --> C{プラグイン検出?}
    C -->|No| D[VolumeFailedRecycle]
    C -->|Yes| E[plugin.Recycle実行]
    E --> F{リサイクル成功?}
    F -->|No| G[VolumeFailedRecycle]
    F -->|Yes| H[Event: VolumeRecycled<br/>Volume recycled]
    H --> I[unbindVolume: PVをAvailable状態に]
    I --> J{unbind成功?}
    J -->|No| K[ログ出力、次回再試行]
    J -->|Yes| L[処理完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| PersistentVolumes | PV状態の最新情報取得 | API Server経由で直接取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events | INSERT | VolumeRecycledイベントの記録 |
| PersistentVolumes | UPDATE | unbindVolumeによるAvailable状態への更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| unbindVolume失敗 | PVのAvailable状態への更新がAPIエラー | 次回同期で再度リサイクルが試行される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | unbindVolume失敗時は次回の同期で再リサイクル |
| リトライ間隔 | PV Controller同期ループの間隔に依存 |
| リトライ対象エラー | unbindVolumeのAPI更新エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に準拠 |
| 1日あたり上限 | 同一理由のイベントは集約される |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 正常完了の通知であり、機密情報は含まれない
- Kubernetes RBACによりEventの読み取り権限が制御される

## 備考

- Recycle ReclaimPolicyは非推奨
- イベント発行後にunbindVolumeが失敗した場合、PVは再度リサイクルされる可能性がある
- VolumeRecycledイベントは成功を示すが、その直後のunbindVolume失敗は別の問題として扱われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/controller/volume/events/event.go` | 24行目: `VolumeRecycled` 定数定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pv_controller.go | `pkg/controller/volume/persistentvolume/pv_controller.go` | 1307-1318行目: リサイクル成功後のイベント発行とunbindVolume |

**主要処理フロー**:
1. **1307行目**: リサイクル成功のログ出力
2. **1309行目**: `eventRecorder.Event(volume, Normal, VolumeRecycled, "Volume recycled")`
3. **1311行目**: `unbindVolume(ctx, volume)` でPVをAvailable状態に戻す
4. **1316行目**: unbind失敗時のエラーログ（次回再試行される旨のコメント）

### プログラム呼び出し階層図

```
PersistentVolumeController.recycleVolumeOperation()
    |
    +-- plugin.Recycle(volume.Name, spec, recorder)
    |       |
    |       +-- (success)
    |
    +-- eventRecorder.Event(volume, Normal, VolumeRecycled, "Volume recycled")
    |
    +-- unbindVolume(ctx, volume)
            |
            +-- (PVをAvailable状態に更新)
```

### データフロー図

```
[入力]                    [処理]                          [出力]

PV (Released状態)  ---->  recycleVolumeOperation()  ---->  Kubernetes Event
                          |                                (VolumeRecycled)
                          +-> plugin.Recycle()              |
                          +-> unbindVolume()                PV状態更新
                                                           (Available)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/controller/volume/events/event.go` | ソース | VolumeRecycled定数定義（24行目） |
| pv_controller.go | `pkg/controller/volume/persistentvolume/pv_controller.go` | ソース | VolumeRecycled発行ロジック（1309行目） |
| recycle_test.go | `pkg/controller/volume/persistentvolume/recycle_test.go` | テスト | リサイクルロジックのユニットテスト |
