# 通知設計書 65-FailedCreatePodSandBox

## 概要

本ドキュメントは、KubernetesにおいてPodサンドボックスの作成に失敗した際に発行される「FailedCreatePodSandBox」イベントの設計を記述する。

### 本通知の処理概要

kubeletのランタイムマネージャがSyncPod処理中にPodサンドボックス（コンテナの実行環境）を作成しようとした際、CRI（Container Runtime Interface）やCNI（Container Network Interface）、CSI等でエラーが発生した場合にこの通知を発行する。

**業務上の目的・背景**：Podサンドボックスはコンテナ実行の基盤であり、その作成失敗はPodが起動できないことを意味する。CNIプラグインの設定不備、コンテナランタイムの障害、リソース不足等、様々な原因で発生し得る。この通知によりユーザーとクラスタ管理者はPod起動失敗の根本原因を特定できる。

**通知の送信タイミング**：kubeletのSyncPodメソッド内で、createPodSandboxの呼び出しがエラーを返した場合に発行される。ただし、Pod削除が要求されている場合は発行されない。

**通知の受信者**：Podオブジェクトに対するKubernetes Eventとして記録され、kubectl describe pod等で確認可能。アプリケーション開発者およびクラスタ管理者が対象。

**通知内容の概要**：「Failed to create pod sandbox: {エラー詳細}」というメッセージがPodオブジェクトに対するWarningイベントとして記録される。エラー詳細にはCRI/CNI/CSIからのエラーメッセージが含まれる。

**期待されるアクション**：エラーメッセージに基づき、ネットワーク設定（CNI）、コンテナランタイム（CRI）、ストレージ（CSI）の状態を確認する。ノードのリソース状況、ネットワーク設定、コンテナランタイムのログを調査する。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（kubelet SyncPod内で発行） |
| 優先度 | 高（Pod起動失敗） |
| リトライ | なし（kubeletの同期ループで再試行） |

### 送信先決定ロジック

Podオブジェクトへの参照（ref.GetReference）を取得し、そのPodに対してEventfを発行する。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventとして発行されるため、メール送信は行わない。

### 本文テンプレート

```
Failed to create pod sandbox: {err}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | サンドボックス作成エラーの詳細 | createPodSandboxの戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| kubelet同期 | SyncPod内のcreatePodSandbox失敗 | createPodSandboxがエラーを返し、かつPod削除が要求されていない | CRI/CNI/CSIエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Pod削除要求中 | IsPodTerminationRequestedがtrueの場合はイベント発行されない |
| サンドボックス作成成功 | エラーが発生しない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[kubelet SyncPod] --> B[createPodSandbox呼び出し]
    B --> C{サンドボックス作成成功?}
    C -->|Yes| D[後続処理へ]
    C -->|No| E{Pod削除要求中?}
    E -->|Yes| F[ログ出力のみ、return]
    E -->|No| G[StartedPodsErrorsTotal.Inc]
    G --> H[createSandboxResult.Fail]
    H --> I[ref.GetReference]
    I --> J[FailedCreatePodSandBox Warning イベント発行]
    J --> K[return]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | Pod仕様の確認 | SyncPodの引数 |

### テーブル別参照項目詳細

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| metadata.uid | Pod削除要求の確認 | IsPodTerminationRequested |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | Kubernetes Eventオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | FailedCreatePodSandBox | イベント理由 |
| INSERT | message | Failed to create pod sandbox: {err} | エラー詳細含む |
| INSERT | type | Warning | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| CRIエラー | コンテナランタイムがサンドボックス作成に失敗 | コンテナランタイムのログ確認 |
| CNIエラー | ネットワークプラグインがエラーを返す | CNI設定・ログの確認 |
| CSIエラー | ストレージプラグインがエラーを返す | CSIドライバの状態確認 |
| Pod参照取得失敗 | ref.GetReferenceがエラーを返す | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | kubeletのPod同期ループにより自動再試行 |
| リトライ間隔 | バックオフ付きの再試行間隔 |
| リトライ対象エラー | 全てのサンドボックス作成エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Eventのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

エラーメッセージにはCRI/CNI/CSIからの詳細情報が含まれる可能性があり、ネットワーク設定やストレージ設定の情報が間接的に露出する場合がある。ただし、Kubernetesの標準的な動作範囲内であり、RBACにより閲覧が制限される。

## 備考

- StartedPodsErrorsTotalメトリクスがインクリメントされるため、Prometheusで監視可能
- Pod削除中の場合はイベント発行されない（エラーではなく正常な削除プロセスの一部）
- createSandboxResult.Failにより、PodSyncResultにもエラーが記録される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | FailedCreatePodSandBox定数の定義（行81） |

**読解のコツ**: 定数名は`FailedCreatePodSandBox`であり、イベントReasonの文字列値も同一。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | SyncPodメソッド（行1394付近） |

**主要処理フロー**:
1. **行1545-1554**: createPodSandbox失敗後のPod削除要求チェック
2. **行1556-1557**: メトリクスインクリメントとSyncResult失敗記録
3. **行1558-1563**: エラーログ出力とFailedCreatePodSandBoxイベント発行

#### Step 3: createPodSandboxの実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | createPodSandboxメソッド |

**主要処理フロー**:
- CRIのRunPodSandbox呼び出し
- ネットワーク名前空間の設定
- エラー発生時のロールバック処理

### プログラム呼び出し階層図

```
kubeGenericRuntimeManager.SyncPod
    |
    +-- createPodSandbox
    |      |
    |      +-- runtimeService.RunPodSandbox (CRI呼び出し)
    |      +-- ネットワーク設定 (CNI)
    |
    +-- [エラー時] podStateProvider.IsPodTerminationRequested
    |
    +-- [エラー時] metrics.StartedPodsErrorsTotal.Inc
    |
    +-- [エラー時] ref.GetReference
    |
    +-- [エラー時] recorder.Eventf (FailedCreatePodSandBox)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Pod (仕様)         ───> createPodSandbox               ───> Kubernetes Event
PodSandboxConfig   ───> CRI RunPodSandbox              (FailedCreatePodSandBox)
                   ───> エラー発生                      + メトリクス
                                                       + PodSyncResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | SyncPodメソッド、サンドボックス作成処理 |
