# 通知設計書 66-FailedPodSandBoxStatus

## 概要

本ドキュメントは、Kubernetesにおいて、新しく作成したPodサンドボックスのステータス取得に失敗した際に発行される「FailedPodSandBoxStatus」イベントの設計を記述する。

### 本通知の処理概要

kubeletのランタイムマネージャがSyncPod処理中に新しいサンドボックスを作成した直後、そのサンドボックスのステータスをCRI経由で取得しようとした際にエラーが発生した場合にこの通知を発行する。

**業務上の目的・背景**：サンドボックス作成後、kubeletはサンドボックスのステータス（IPアドレス等）を取得してPodの設定に反映する必要がある。ステータス取得失敗はコンテナランタイムの異常やタイミング問題を示す可能性があり、Pod起動処理が中断される。この通知により管理者はコンテナランタイムの問題を特定できる。

**通知の送信タイミング**：kubeletのSyncPodメソッド内で、createPodSandbox成功後にruntimeService.PodSandboxStatusを呼び出した際にエラーが返された場合に発行される。

**通知の受信者**：Podオブジェクトに対するKubernetes Eventとして記録され、kubectl describe pod等で確認可能。クラスタ管理者が対象。

**通知内容の概要**：「Unable to get pod sandbox status: {エラー詳細}」というメッセージがPodオブジェクトに対するWarningイベントとして記録される。

**期待されるアクション**：コンテナランタイム（containerd, CRI-O等）のログを確認し、ステータス取得失敗の原因を特定する。ランタイムの再起動やノードの状態確認が必要な場合がある。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（kubelet SyncPod内で発行） |
| 優先度 | 高（Pod起動失敗） |
| リトライ | なし（kubeletの同期ループで再試行） |

### 送信先決定ロジック

Podオブジェクトへの参照（ref.GetReference）を取得し、そのPodに対してEventfを発行する。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventとして発行されるため、メール送信は行わない。

### 本文テンプレート

```
Unable to get pod sandbox status: {err}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | ステータス取得エラーの詳細 | runtimeService.PodSandboxStatusの戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| kubelet同期 | SyncPod内のPodSandboxStatus呼び出し失敗 | createPodSandbox成功後のステータス取得でエラー発生 | CRIエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータス取得成功 | PodSandboxStatusがエラーを返さない場合 |
| サンドボックス作成失敗 | createPodSandbox自体が失敗した場合は別イベント（FailedCreatePodSandBox） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[kubelet SyncPod] --> B[createPodSandbox成功]
    B --> C[runtimeService.PodSandboxStatus呼び出し]
    C --> D{ステータス取得成功?}
    D -->|Yes| E[後続処理へ - IPアドレス取得等]
    D -->|No| F[ref.GetReference]
    F --> G[FailedPodSandBoxStatus Warning イベント発行]
    G --> H[result.Fail]
    H --> I[return]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | Pod仕様の確認 | SyncPodの引数 |

### テーブル別参照項目詳細

#### Pod

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| - | ref.GetReferenceでPod参照取得 | Event発行先の特定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | Kubernetes Eventオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | FailedPodSandBoxStatus | イベント理由 |
| INSERT | message | Unable to get pod sandbox status: {err} | エラー詳細含む |
| INSERT | type | Warning | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| CRIエラー | PodSandboxStatusがエラーを返す | コンテナランタイムのログ確認 |
| Pod参照取得失敗 | ref.GetReferenceがエラーを返す | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | kubeletのPod同期ループにより自動再試行 |
| リトライ間隔 | kubeletの同期間隔に依存 |
| リトライ対象エラー | 全てのステータス取得エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Eventのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

エラーメッセージにコンテナランタイムからのエラー詳細が含まれる場合があるが、機密情報は通常含まれない。

## 備考

- イベント定数名はFailedStatusPodSandBoxだが、イベントReason文字列値は「FailedPodSandBoxStatus」である（events/event.go行82参照）
- ステータス取得失敗後、result.Fail(err)によりSyncPodは即座にreturnする
- ステータスがnilの場合もSyncPodは失敗するが、その場合はイベントではなくresult.Failのみ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | FailedStatusPodSandBox定数の定義（行82）- 値は「FailedPodSandBoxStatus」 |

**読解のコツ**: Go定数名（FailedStatusPodSandBox）とイベントReason文字列（FailedPodSandBoxStatus）が異なることに注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | SyncPodメソッド内のサンドボックスステータス取得部分（行1568-1578） |

**主要処理フロー**:
1. **行1566**: createPodSandbox成功後のログ出力
2. **行1568**: runtimeService.PodSandboxStatus呼び出し
3. **行1569-1577**: エラー発生時のイベント発行とreturn
4. **行1574**: FailedStatusPodSandBox（FailedPodSandBoxStatus）イベント発行

### プログラム呼び出し階層図

```
kubeGenericRuntimeManager.SyncPod
    |
    +-- createPodSandbox (成功)
    |
    +-- runtimeService.PodSandboxStatus (CRI呼び出し)
    |      |
    |      +-- [エラー時] ref.GetReference
    |      |
    |      +-- [エラー時] recorder.Eventf (FailedPodSandBoxStatus)
    |      |
    |      +-- [エラー時] result.Fail
    |
    +-- [成功時] determinePodSandboxIPs
```

### データフロー図

```
[入力]                          [処理]                              [出力]

podSandboxID       ───> runtimeService.PodSandboxStatus ───> Kubernetes Event
(作成済みID)              (CRI呼び出し)                    (FailedPodSandBoxStatus)
                                                          + PodSyncResult
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | SyncPodメソッド、ステータス取得処理 |
