# 通知設計書 68-ProbeWarning

## 概要

本ドキュメントは、Kubernetesにおいて、コンテナのProbe実行時に警告（Warning）結果が返された際に発行される「ProbeWarning」イベントの設計を記述する。

### 本通知の処理概要

kubeletのプローバがコンテナに対してProbeを実行し、結果がWarning（プローブ自体は成功だが警告情報がある）の場合にこの通知を発行する。プローブ結果としてはSuccessを返すが、出力内容に注意すべき情報が含まれる場合に発行される。

**業務上の目的・背景**：プローブが成功したものの、何らかの警告情報を返す場合がある。例えば、ヘルスチェックエンドポイントが部分的な問題を報告する場合等。この通知はプローブ自体は成功しているが、アプリケーションが警告状態にあることをユーザーに伝える。プローブ結果はSuccessとして扱われるため、コンテナの再起動やServiceエンドポイントからの除外は行われない。

**通知の送信タイミング**：プローバが定期的にProbeを実行し、probe結果がWarningの場合に発行される。

**通知の受信者**：Podオブジェクト（対象コンテナ）に対するKubernetes Eventとして記録され、kubectl describe pod等で確認可能。アプリケーション開発者が対象。

**通知内容の概要**：「{probeType} probe warning: {output}」というメッセージがPodオブジェクトに対するWarningイベントとして記録される。

**期待されるアクション**：警告内容を確認し、アプリケーションの潜在的な問題を把握する。即座の対応は不要だが、問題が悪化する前に調査することが推奨される。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（prober.probe内で発行） |
| 優先度 | 低（プローブは成功している） |
| リトライ | なし（プローブの定期実行により繰り返される） |

### 送信先決定ロジック

recordContainerEventメソッドにより、Pod内の対象コンテナに対するEventとして記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventとして発行されるため、メール送信は行わない。

### 本文テンプレート

```
{probeType} probe warning: {output}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| probeType | プローブ種別（liveness/readiness/startup） | probeメソッドの引数 | Yes |
| output | プローブの出力結果 | runProbeWithRetriesの戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期プローブ | Probe実行結果がWarning | probe.Warningが返された場合 | 全probeType共通 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プローブ結果がSuccess | 純粋な成功時はイベント発行されない |
| プローブ結果がFailure | Failure時はUnhealthy（No.67）が発行される |
| プローブ結果がUnknown | Unknown時はイベント発行されない |
| プローブでエラー発生 | エラー時はUnhealthy（No.67）が発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[prober.probe実行] --> B[runProbeWithRetries]
    B --> C{エラー発生?}
    C -->|Yes| D[Unhealthy イベント]
    C -->|No| E{結果判定}
    E -->|Success| F[成功 - イベントなし]
    E -->|Warning| G[ProbeWarning イベント発行]
    E -->|Failure| H[Unhealthy イベント]
    G --> I[results.Success返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | Pod仕様の確認 | プローブ定義の参照 |
| Container | コンテナのプローブ仕様 | LivenessProbe/ReadinessProbe/StartupProbe |

### テーブル別参照項目詳細

#### Container (v1.Container)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| livenessProbe | Liveness Probe仕様 | probeType == liveness |
| readinessProbe | Readiness Probe仕様 | probeType == readiness |
| startupProbe | Startup Probe仕様 | probeType == startup |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | Kubernetes Eventオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | ProbeWarning | イベント理由 |
| INSERT | message | {probeType} probe warning: {output} | プローブ出力含む |
| INSERT | type | Warning | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | ProbeWarningはプローブ成功時の通知 | 対処不要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（プローブは成功として扱われる） |
| リトライ間隔 | periodSeconds（プローブ定義に基づく定期実行） |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Eventのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

プローブの出力（output）にはアプリケーションからのレスポンスが含まれる。ヘルスチェックエンドポイントの実装によっては内部情報が含まれる可能性があるため、ヘルスチェックレスポンスには機密情報を含めないことが推奨される。

## 備考

- ProbeWarningはプローブ結果としてはSuccessを返すため、Liveness Probeの場合もコンテナ再起動は発生しない
- Readiness Probeの場合もReady Conditionには影響しない（Successとして扱われる）
- Unhealthy（No.67）とは同一メソッド（probe）内で結果に応じて使い分けられる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | ContainerProbeWarning定数の定義（行98）- 値は「ProbeWarning」 |

**読解のコツ**: ContainerUnhealthy（行97）とセットで理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | prober.go | `pkg/kubelet/prober/prober.go` | probeメソッド内のWarning分岐（行116-119） |

**主要処理フロー**:
1. **行102**: runProbeWithRetriesでプローブ実行
2. **行111**: switch文で結果分岐
3. **行116-118**: probe.Warning時にProbeWarningイベント発行
4. **行119**: results.Success返却（プローブは成功扱い）

### プログラム呼び出し階層図

```
prober.probe
    |
    +-- probeSpec取得（container.LivenessProbe等）
    |
    +-- runProbeWithRetries
    |      |
    |      +-- runProbe (実際のプローブ実行)
    |
    +-- [Warning時] recordContainerEvent (ProbeWarning)
    |
    +-- results.Success 返却
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Pod (仕様)         ───> prober.probe                    ───> Kubernetes Event
Container          ───> runProbeWithRetries              (ProbeWarning)
ProbeSpec          ───> probe結果判定                     + results.Success
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| prober.go | `pkg/kubelet/prober/prober.go` | ソース | プローバ本体、プローブ実行とイベント発行 |
| prober_test.go | `pkg/kubelet/prober/prober_test.go` | テスト | プローバのテスト |
