# 通知設計書 69-FailedPostStartHook

## 概要

本ドキュメントは、Kubernetesにおいて、コンテナのPostStartライフサイクルフックの実行に失敗した際に発行される「FailedPostStartHook」イベントの設計を記述する。

### 本通知の処理概要

kubeletのランタイムマネージャがコンテナ起動処理（startContainer）の中でPostStartフックを実行し、フックがエラーを返した場合にこの通知を発行する。PostStartフック失敗時はコンテナが強制終了される。

**業務上の目的・背景**：PostStartフックはコンテナ作成直後に実行されるライフサイクルフックであり、初期化処理や外部サービスへの通知等に使用される。フックの失敗はコンテナの正常な起動を妨げ、コンテナは強制終了される。この通知によりユーザーはPostStartフック失敗を認識し、フックの実装やコンテナの設定を修正できる。

**通知の送信タイミング**：kubeletのstartContainerメソッドのStep 4（PostStartフック実行）で、runner.Runがエラーを返した場合に発行される。

**通知の受信者**：Podオブジェクト（対象コンテナ）に対するKubernetes Eventとして記録され、kubectl describe pod等で確認可能。アプリケーション開発者が対象。

**通知内容の概要**：「PostStartHook failed」という固定メッセージがPodオブジェクトに対するWarningイベントとして記録される。セキュリティ上の理由から、フックの実際のエラーメッセージはイベントには含まれない。

**期待されるアクション**：PostStartフックの実装（HTTPハンドラ、Exec、Sleep等）を確認し、エラーの原因を特定する。kubeletのログで詳細なエラー情報を確認できる。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（startContainer内で発行） |
| 優先度 | 高（コンテナ強制終了を伴う） |
| リトライ | なし（kubeletの同期ループでコンテナが再作成される） |

### 送信先決定ロジック

recordContainerEventメソッドにより、Pod内の対象コンテナに対するEventとして記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventとして発行されるため、メール送信は行わない。

### 本文テンプレート

```
PostStartHook failed
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | セキュリティ上の理由で固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コンテナ起動 | startContainer内のPostStartフック実行失敗 | runner.Runがエラーを返した場合 | フック実行エラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| PostStartフック未定義 | container.Lifecycle.PostStartがnilの場合 |
| フック実行成功 | runner.Runがエラーを返さない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[startContainer] --> B{PostStartフック定義あり?}
    B -->|No| C[正常終了]
    B -->|Yes| D[runner.Run実行]
    D --> E{実行成功?}
    E -->|Yes| C
    E -->|No| F[FailedPostStartHook Warning イベント発行]
    F --> G[killContainer - コンテナ強制終了]
    G --> H[ErrPostStartHook返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | Pod仕様の確認 | コンテナのLifecycle定義 |
| Container | PostStartフック仕様 | Lifecycle.PostStart |

### テーブル別参照項目詳細

#### Container (v1.Container)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| lifecycle.postStart | PostStartフック定義 | nilでないこと |
| lifecycle.postStart.exec | Execハンドラ | フック種別がExecの場合 |
| lifecycle.postStart.httpGet | HTTPハンドラ | フック種別がHTTPの場合 |
| lifecycle.postStart.sleep | Sleepハンドラ | フック種別がSleepの場合 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | Kubernetes Eventオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | FailedPostStartHook | イベント理由 |
| INSERT | message | PostStartHook failed | 固定メッセージ |
| INSERT | type | Warning | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| フック実行失敗 | runner.Runがエラーを返す | イベント発行後、コンテナを強制終了 |
| コンテナ強制終了失敗 | killContainerがエラーを返す | エラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（コンテナ強制終了後、kubeletの同期ループで再起動） |
| リトライ間隔 | restartPolicy/バックオフに依存 |
| リトライ対象エラー | ErrPostStartHook |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Eventのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

ソースコードのコメントに「do not record the message in the event so that secrets won't leak from the server.」と明記されている通り、フックの実行結果メッセージはイベントに含めない。これはフック内でシークレット情報を扱う可能性があるため。実際のエラーメッセージはkubeletログにのみ記録される。

## 備考

- PostStartフック失敗時、runner.Runが返すメッセージ（msg）はstartContainerの戻り値として返されるが、イベントには含まれない
- フック失敗後、killContainerが「FailedPostStartHook」理由でコンテナを強制終了する
- ErrPostStartHookエラーにより、SyncPodの結果にも失敗が記録される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | FailedPostStartHook定数の定義（行113） |

**読解のコツ**: Lifecycle hooks定数はファイル末尾のconst blockに定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | startContainerメソッドのStep 4（行318-336） |

**主要処理フロー**:
1. **行319**: container.Lifecycle.PostStartのnil判定
2. **行320-323**: kubeContainerIDの構築
3. **行324**: runner.Run実行（PostStartフック）
4. **行325-329**: エラー発生時のログ出力とイベント発行
5. **行330**: killContainerによるコンテナ強制終了
6. **行334**: ErrPostStartHook返却

### プログラム呼び出し階層図

```
kubeGenericRuntimeManager.startContainer
    |
    +-- Step 1-3: コンテナ作成・起動
    |
    +-- Step 4: PostStartフック実行
           |
           +-- runner.Run (PostStart handler)
           |
           +-- [エラー時] recordContainerEvent (FailedPostStartHook)
           |
           +-- [エラー時] killContainer ("FailedPostStartHook")
           |
           +-- [エラー時] return msg, ErrPostStartHook
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Pod (仕様)         ───> startContainer                  ───> Kubernetes Event
Container          ───> runner.Run (PostStart)           (FailedPostStartHook)
Lifecycle.PostStart ───> エラー判定                       + コンテナ強制終了
                                                        + ErrPostStartHook
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | ソース | startContainerメソッド、PostStartフック実行 |
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | SyncPodメソッド（呼び出し元） |
