# 通知設計書 70-FailedPreStopHook

## 概要

本ドキュメントは、Kubernetesにおいて、コンテナのPreStopライフサイクルフックの実行に失敗した際に発行される「FailedPreStopHook」イベントの設計を記述する。

### 本通知の処理概要

kubeletのランタイムマネージャがコンテナ終了処理の一部としてPreStopフックを実行し、フックがエラーを返した場合にこの通知を発行する。PreStopフックは非同期（goroutine内）で実行され、gracePeriod内に完了しない場合はタイムアウトする。

**業務上の目的・背景**：PreStopフックはコンテナ終了前に実行されるライフサイクルフックであり、グレースフルシャットダウン処理（DB接続のクローズ、キューからのデレジスタ等）に使用される。フックの失敗はグレースフルシャットダウンが正常に行われなかったことを示す。この通知によりユーザーはPreStopフックの問題を認識し、シャットダウン処理の改善が可能になる。

**通知の送信タイミング**：kubeletのexecutePreStopHookメソッド内のgoroutineで、runner.Runがエラーを返した場合に発行される。

**通知の受信者**：Podオブジェクト（対象コンテナ）に対するKubernetes Eventとして記録され、kubectl describe pod等で確認可能。アプリケーション開発者が対象。

**通知内容の概要**：「PreStopHook failed」という固定メッセージがPodオブジェクトに対するWarningイベントとして記録される。セキュリティ上の理由から、フックの実際のエラーメッセージはイベントには含まれない。

**期待されるアクション**：PreStopフックの実装を確認し、エラーの原因を特定する。kubeletのログで詳細なエラー情報を確認できる。gracePeriodが短すぎないかも確認する。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（goroutine内で発行） |
| 優先度 | 中（コンテナ終了処理に関連） |
| リトライ | なし（コンテナ終了は一度のみ） |

### 送信先決定ロジック

recordContainerEventメソッドにより、Pod内の対象コンテナに対するEventとして記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Eventとして発行されるため、メール送信は行わない。

### 本文テンプレート

```
PreStopHook failed
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | セキュリティ上の理由で固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コンテナ終了 | executePreStopHook内のPreStopフック実行失敗 | runner.Runがエラーを返した場合 | goroutine内で実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| PreStopフック未定義 | container.Lifecycle.PreStopがnilの場合（executePreStopHook自体が呼ばれない） |
| フック実行成功 | runner.Runがエラーを返さない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[executePreStopHook] --> B[goroutine起動]
    B --> C[runner.Run実行 - PreStop]
    C --> D{実行成功?}
    D -->|Yes| E[done channel close]
    D -->|No| F[FailedPreStopHook Warning イベント発行]
    F --> G[done channel close]
    A --> H{select}
    H -->|タイムアウト| I[gracePeriod超過ログ]
    H -->|done| J[完了ログ]
    I --> K[経過時間返却]
    J --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod | Pod仕様の確認 | コンテナのLifecycle定義 |
| Container | PreStopフック仕様 | Lifecycle.PreStop |

### テーブル別参照項目詳細

#### Container (v1.Container)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| lifecycle.preStop | PreStopフック定義 | nilでないこと |
| lifecycle.preStop.exec | Execハンドラ | フック種別がExecの場合 |
| lifecycle.preStop.httpGet | HTTPハンドラ | フック種別がHTTPの場合 |
| lifecycle.preStop.sleep | Sleepハンドラ | フック種別がSleepの場合 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | Kubernetes Eventオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | reason | FailedPreStopHook | イベント理由 |
| INSERT | message | PreStopHook failed | 固定メッセージ |
| INSERT | type | Warning | イベントタイプ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| フック実行失敗 | runner.Runがエラーを返す | イベント発行（コンテナ終了は継続） |
| タイムアウト | gracePeriod内にフックが完了しない | ログ出力（フック完了を待たずに終了処理を継続） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（コンテナ終了処理は一度のみ） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Eventのデフォルトレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

ソースコードのコメントに「do not record the message in the event so that secrets won't leak from the server.」と明記されている通り、フックの実行結果メッセージはイベントに含めない。これはフック内でシークレット情報を扱う可能性があるため。実際のエラーメッセージはkubeletログにのみ記録される。

## 備考

- PostStartHook（No.69）とは異なり、PreStopフック失敗時にコンテナが強制終了されることはない（コンテナは既に終了処理中）
- PreStopフックはgoroutine内で実行され、gracePeriod（秒）でタイムアウトする
- タイムアウト時はフック完了を待たずにコンテナの終了処理が継続される
- executePreStopHookはフック実行にかかった時間（秒）を返却する
- utilruntime.HandleCrashWithContextによりgoroutine内のpanicが適切に処理される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | FailedPreStopHook定数の定義（行114） |

**読解のコツ**: FailedPostStartHook（行113）とセットで理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | executePreStopHookメソッド（行760-788） |

**主要処理フロー**:
1. **行762-763**: ログ出力と開始時刻記録
2. **行765-766**: doneチャネル作成とgoroutine起動
3. **行767-768**: defer close(done)とcrash handler
4. **行770**: runner.Run実行（PreStopフック）
5. **行770-774**: エラー発生時のログ出力とイベント発行
6. **行778-785**: select文でタイムアウトまたは完了待ち
7. **行787**: 経過時間返却

### プログラム呼び出し階層図

```
kubeGenericRuntimeManager.killContainer
    |
    +-- executePreStopHook
           |
           +-- goroutine
           |      |
           |      +-- runner.Run (PreStop handler)
           |      |
           |      +-- [エラー時] recordContainerEvent (FailedPreStopHook)
           |      |
           |      +-- close(done)
           |
           +-- select
                  |
                  +-- time.After(gracePeriod) -> タイムアウト
                  |
                  +-- <-done -> 正常完了
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Pod (仕様)         ───> executePreStopHook              ───> Kubernetes Event
containerSpec      ───> goroutine: runner.Run            (FailedPreStopHook)
containerID        ───> select: タイムアウト/完了待ち      + 経過時間(int64)
gracePeriod        ───>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kuberuntime_container.go | `pkg/kubelet/kuberuntime/kuberuntime_container.go` | ソース | executePreStopHookメソッド、PreStopフック実行 |
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | killContainerメソッド（呼び出し元） |
