# 通知設計書 71-InvalidDiskCapacity

## 概要

本ドキュメントは、Kubernetesクラスタにおけるイメージファイルシステムのディスク容量が不正（0バイト）と検出された際に発行されるInvalidDiskCapacity通知の設計を定義する。

### 本通知の処理概要

InvalidDiskCapacity通知は、kubeletのImage GC Manager（イメージガベージコレクションマネージャ）がイメージファイルシステムの容量を取得した結果、容量が0バイトであった場合にWarningイベントとして発行される。この通知はノードレベルのイベントとして記録され、ノードのイメージストレージに重大な問題が発生していることを示す。

**業務上の目的・背景**：イメージガベージコレクション処理では、ディスク使用率を計算するためにファイルシステムの総容量が必要である。容量が0の場合、使用率の計算が不可能となりゼロ除算が発生するため、GC処理を安全に中断し、管理者に異常を通知する必要がある。この状態はファイルシステムの未マウント、ドライバの不具合、またはStatsProvider の設定ミスに起因する可能性がある。

**通知の送信タイミング**：kubeletのImage GC ManagerがGarbageCollect()メソッドを実行する際、StatsProviderからImageFsStats()を取得し、CapacityBytesが0であると判定されたタイミングで発行される。GarbageCollectは定期的（デフォルト5分間隔）に実行される。

**通知の受信者**：Kubernetes Event APIを通じてNodeオブジェクトに紐付くイベントとして記録される。kubectl describe nodeやイベント監視ツール（Event Exporter等）を通じてクラスタ管理者が受信する。

**通知内容の概要**：「invalid capacity 0 on image filesystem」というメッセージが送信され、イメージファイルシステムの容量が0であることを示す。

**期待されるアクション**：クラスタ管理者はノードのファイルシステムの状態を確認し、イメージストレージが正しくマウントされているか、ディスクドライバが正常に動作しているかを検証する必要がある。必要に応じてノードの再起動やファイルシステムの修復を行う。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（GarbageCollect処理内で即座に発行） |
| 優先度 | 高（ノードのイメージGCが完全に停止する） |
| リトライ | なし（次回のGCサイクルで再度チェックされる） |

### 送信先決定ロジック

kubeletが保持するnodeRef（ノードのObjectReference）を送信先として使用する。イベントはNodeオブジェクトに紐付けられ、Kubernetes Event APIを通じて記録される。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | kubelet |
| EventType | Warning |
| Reason | InvalidDiskCapacity |
| 対象オブジェクト | Node |

### 本文テンプレート

```
invalid capacity 0 on image filesystem
```

### 添付ファイル

該当なし（Kubernetes Eventには添付ファイルの概念はない）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 定期処理 | Image GC Manager の GarbageCollect() 実行 | ImageFsStats の CapacityBytes が 0 | 5分間隔のGCサイクルでチェック |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| CapacityBytes が 0 以外 | 正常な容量が取得できた場合は通知されない |
| ImageFsStats 取得失敗 | StatsProvider からの取得自体が失敗した場合は別のエラーパスとなる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[GarbageCollect呼び出し] --> B[imagesInEvictionOrder取得]
    B --> C[freeOldImages実行]
    C --> D[ImageFsStats取得]
    D --> E{CapacityBytes == 0?}
    E -->|Yes| F[InvalidDiskCapacity Event発行]
    F --> G[エラーを返却]
    E -->|No| H[使用率計算・GC実行]
    H --> I[終了]
    G --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | Kubernetes Eventとして記録 | etcdに格納される |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events (etcd) | INSERT | Kubernetes Eventオブジェクトが作成される |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| InvalidDiskCapacity | CapacityBytes が 0 | Event発行後、GarbageCollectはエラーを返却。次回GCサイクルで再試行 |
| ImageFsStats取得エラー | StatsProviderが統計を返せない | Event発行なし、GarbageCollectがエラーを返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回GCサイクルで再実行） |
| リトライ間隔 | 約5分（GCサイクル間隔） |
| リトライ対象エラー | 全てのGCエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に従う |
| 1日あたり上限 | 制限なし（ただしEventは1時間のTTLで自動削除） |

### 配信時間帯

制限なし（GCサイクルに基づいて発行される）

## セキュリティ考慮事項

- 本通知には機密情報は含まれない
- ノードのディスク容量情報は運用情報であり、セキュリティ上のリスクは低い

## 備考

- この通知はImage GC Managerの GarbageCollect() メソッド内で発行される
- 容量0は通常ファイルシステムの異常を示すため、即座に調査が必要
- イベントの定数 `InvalidDiskCapacity` は `pkg/kubelet/events/event.go` で定義

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Image GC Managerが扱うデータ構造とポリシーを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 行91-93: InvalidDiskCapacity, FreeDiskSpaceFailed 定数の定義を確認 |
| 1-2 | image_gc_manager.go | `pkg/kubelet/images/image_gc_manager.go` | 行88-106: ImageGCPolicy構造体で閾値とMinAge/MaxAgeを確認 |
| 1-3 | image_gc_manager.go | `pkg/kubelet/images/image_gc_manager.go` | 行108-140: realImageGCManager構造体のフィールド構成を確認 |

**読解のコツ**: ImageGCPolicyの HighThresholdPercent と LowThresholdPercent がGCの発動条件を制御する。capacity == 0 はこの使用率計算の前提条件チェックである。

#### Step 2: エントリーポイントを理解する

GarbageCollectメソッドが通知のエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | image_gc_manager.go | `pkg/kubelet/images/image_gc_manager.go` | 行348-417: GarbageCollect() メソッドの全体フロー |

**主要処理フロー**:
1. **行354**: imagesInEvictionOrder でエビクション順序のイメージリスト取得
2. **行359**: freeOldImages で古いイメージを解放
3. **行365**: statsProvider.ImageFsStats() でディスク統計取得
4. **行384-388**: capacity == 0 チェック、InvalidDiskCapacity イベント発行
5. **行391-413**: 使用率ベースのGC処理（容量0の場合はここに到達しない）

#### Step 3: StatsProvider層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | image_gc_manager.go | `pkg/kubelet/images/image_gc_manager.go` | 行66-70: StatsProviderインタフェースの定義 |

**主要処理フロー**:
- **行69**: ImageFsStats() がイメージファイルシステムの統計を返す

### プログラム呼び出し階層図

```
kubelet (定期実行, 5分間隔)
    |
    +-- realImageGCManager.GarbageCollect()  [行348]
           |
           +-- imagesInEvictionOrder()  [行354]
           |       +-- detectImages()  [行243]
           |
           +-- freeOldImages()  [行359]
           |
           +-- statsProvider.ImageFsStats()  [行365]
           |
           +-- capacity == 0 チェック  [行384]
           |       +-- recorder.Eventf(InvalidDiskCapacity)  [行386]
           |
           +-- freeSpace() (容量正常時のみ)  [行395]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

StatsProvider              GarbageCollect()                 Kubernetes Event
(ImageFsStats) ---------> capacity チェック ---------> InvalidDiskCapacity Event
                           |                                 (Warning)
                           v
Container Runtime          capacity > 0 の場合
(ListImages) -----------> 使用率計算 → GC実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベントReason定数定義 |
| image_gc_manager.go | `pkg/kubelet/images/image_gc_manager.go` | ソース | Image GC Managerの実装（通知発行元） |
| image_gc_manager_test.go | `pkg/kubelet/images/image_gc_manager_test.go` | テスト | GCマネージャのテスト |
