# 通知設計書 73-FailedSync

## 概要

本ドキュメントは、KubernetesクラスタにおいてPodのステータス決定時にエラーが発生した際に発行されるFailedSync通知の設計を定義する。

### 本通知の処理概要

FailedSync通知は、kubeletのPod Worker（podWorkers）がPodの同期処理を実行する際、PodキャッシュからPodの最新ステータスを取得できなかった場合にWarningイベントとして発行される。この通知はPodレベルのイベントとして記録され、kubeletがPodの状態を正しく判定できない問題が発生していることを示す。

**業務上の目的・背景**：kubeletは各Podに対してsync/terminating/terminated等の処理を行う前に、PLEGキャッシュからPodの最新ステータスを取得する必要がある。このステータス取得に失敗した場合、kubeletはPodに対する適切なアクション（コンテナの起動・停止・再起動等）を決定できない。FailedSync通知により、Pod Workerレベルでの同期問題を管理者が認識し対応できるようにする。

**通知の送信タイミング**：Pod WorkerがPodの更新処理（managePodLoop内）を実行する際、podCache.GetNewerThan()によるステータス取得がエラーを返した場合に発行される。これはPLEG（Pod Lifecycle Event Generator）キャッシュの更新を最大2秒間待機した後に発生する。

**通知の受信者**：Kubernetes Event APIを通じてPodオブジェクトに紐付くイベントとして記録される。kubectl describe podやイベント監視ツールを通じてPod所有者やクラスタ管理者が受信する。

**通知内容の概要**：「error determining status: {エラー詳細}」というメッセージでPodステータス取得エラーの詳細が通知される。

**期待されるアクション**：クラスタ管理者はPLEGの状態やコンテナランタイムの健全性を確認する。必要に応じてkubeletの再起動やコンテナランタイムのトラブルシューティングを行う。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Pod Worker処理内で即座に発行） |
| 優先度 | 中（Pod処理の一時的な失敗） |
| リトライ | なし（Pod Workerの次回ループで再試行） |

### 送信先決定ロジック

Pod Workerが処理中のPodオブジェクト（update.Options.Pod）を送信先として使用する。イベントはPodオブジェクトに紐付けられ、Kubernetes Event APIを通じて記録される。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | kubelet |
| EventType | Warning |
| Reason | FailedSync |
| 対象オブジェクト | Pod |

### 本文テンプレート

```
error determining status: {err}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | ステータス取得時のエラー内容 | podCache.GetNewerThan() の返却エラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Pod更新処理 | Pod WorkerのmanagePodLoop実行 | podCache.GetNewerThan()がエラーを返却 | PLEGキャッシュからのステータス取得失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータス取得成功 | podCache.GetNewerThan()が正常にステータスを返した場合 |
| Pod削除済み | Podが既に削除されている場合は別のコードパス |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Pod Worker: managePodLoop] --> B[podCache.GetNewerThan呼び出し]
    B --> C{エラー発生?}
    C -->|No| D[sync/terminating/terminated処理へ]
    C -->|Yes| E[FailedSync Event発行]
    E --> F[エラーを返却]
    F --> G[Pod Worker再試行待ち]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pod Cache (PLEG) | Podの最新ステータス取得 | インメモリキャッシュ |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events (etcd) | INSERT | Kubernetes Eventオブジェクトが作成される |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キャッシュタイムアウト | PLEGキャッシュが更新されない | Pod Worker再試行で回復を期待 |
| コンテナランタイムエラー | CRIからの応答不能 | コンテナランタイムの再起動が必要な場合あり |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Pod Workerのバックオフ付き再試行 |
| リトライ間隔 | Pod Workerのバックオフに従う |
| リトライ対象エラー | 全てのステータス取得エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにPodの内部状態情報が含まれる可能性があるが、機密情報は通常含まれない

## 備考

- このイベントはmanagePodLoop内のレガシーイベントとして位置づけられている（コメント: "This is the legacy event thrown by manage pod loop"）
- 他のイベントはsyncPodFnから発行される
- イベントの定数 `FailedSync` は `pkg/kubelet/events/event.go` の行103で定義

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 行102-104: FailedSync定数の定義（Pod worker event reason list） |
| 1-2 | pod_workers.go | `pkg/kubelet/pod_workers.go` | 行82-100: UpdatePodOptions構造体の理解 |

**読解のコツ**: FailedSyncは「Pod worker event reason list」のカテゴリに属し、Pod Workerの同期ループ内で使用される唯一のイベント定数である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pod_workers.go | `pkg/kubelet/pod_workers.go` | 行1270-1287: managePodLoop内のGetNewerThanとFailedSyncイベント発行 |

**主要処理フロー**:
1. **行1279**: podCache.GetNewerThan(uid, lastSyncTime) を呼び出し
2. **行1281**: エラーチェック
3. **行1284**: recorder.Eventf でFailedSyncイベント発行
4. **行1285**: エラーを返却して再試行待ちに移行

#### Step 3: Pod Worker の処理コンテキストを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pod_workers.go | `pkg/kubelet/pod_workers.go` | 行1289-1299: GetNewerThan成功後のsync/terminating/terminated分岐 |

### プログラム呼び出し階層図

```
kubelet
    |
    +-- podWorkers.managePodLoop()
           |
           +-- podCache.GetNewerThan(uid, lastSyncTime)  [行1279]
           |       |
           |       +-- エラー時: recorder.Eventf(FailedSync)  [行1284]
           |
           +-- 成功時:
                   +-- SyncTerminatedPod()  [行1292]
                   +-- SyncTerminatingPod()  [行1294]
                   +-- SyncPod()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

PLEG Cache                 managePodLoop()
(Pod Status) -----------> GetNewerThan()
                           |
                           +-- エラー時 --> FailedSync Event
                           |                (Warning, Pod)
                           +-- 成功時 --> sync/terminating/terminated処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | FailedSync定数定義 |
| pod_workers.go | `pkg/kubelet/pod_workers.go` | ソース | Pod Worker実装、通知発行元 |
