# 通知設計書 75-Scheduled

## 概要

本ドキュメントは、KubernetesクラスタにおいてPodがノードに正常にスケジュールされた際に発行されるScheduled通知の設計を定義する。

### 本通知の処理概要

Scheduled通知は、kube-schedulerがPodに対するスケジューリングサイクルとバインディングサイクルを正常に完了し、Podをターゲットノードにバインドできた際にNormalイベントとして発行される。この通知はPodのライフサイクルにおける重要なマイルストーンを記録する。

**業務上の目的・背景**：Podのスケジューリングは、Podライフサイクルの中で最も重要なステップの一つである。Scheduled通知により、Podがどのノードに配置されたかの履歴が記録され、スケジューリングの成功をトラッキングできる。これはトラブルシューティングやキャパシティプランニングにおいて有用な情報となる。

**通知の送信タイミング**：schedulerのbindingCycleが正常に完了し、Podがターゲットノードにバインドされた後、finishBinding()メソッド内で発行される。バインディングはスケジューリングサイクル完了後に非同期で実行される。

**通知の受信者**：Kubernetes Event APIを通じてPodオブジェクトに紐付くイベントとして記録される。kubectl describe podやイベント監視ツールを通じてPod所有者やクラスタ管理者が受信する。

**通知内容の概要**：「Successfully assigned {namespace}/{name} to {nodeName}」というメッセージでPodの割り当て先ノードが通知される。

**期待されるアクション**：通常、管理者のアクションは不要。正常なスケジューリングの確認として利用される。スケジューリング遅延の調査時には、このイベントのタイムスタンプが参考になる。

## 通知種別

Kubernetes Event（Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（bindingCycleは非同期goroutineで実行） |
| 優先度 | 低（正常動作の記録） |
| リトライ | なし |

### 送信先決定ロジック

スケジュールされたPodオブジェクト（assumed Pod）を送信先として使用する。イベントはPodオブジェクトに紐付けられる。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | scheduler |
| EventType | Normal |
| Reason | Scheduled |
| Action | Binding |
| 対象オブジェクト | Pod |

### 本文テンプレート

```
Successfully assigned {namespace}/{name} to {nodeName}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| namespace | Podのnamespace | assumed.Namespace | Yes |
| name | Podの名前 | assumed.Name | Yes |
| nodeName | バインド先ノード名 | targetNode (scheduleResult.SuggestedHost) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジューリング完了 | bindingCycleの正常完了 | status.IsSuccess() == true | finishBinding()内で発行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| バインド失敗 | status.IsSuccess()がfalseの場合はScheduledイベントは発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ScheduleOne開始] --> B[schedulingCycle実行]
    B --> C{スケジューリング成功?}
    C -->|No| D[FailureHandler呼び出し]
    C -->|Yes| E[非同期bindingCycle開始]
    E --> F[RunBindPlugins実行]
    F --> G{バインド成功?}
    G -->|No| H[handleBindingCycleError]
    G -->|Yes| I[finishBinding呼び出し]
    I --> J[Scheduled Event発行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Pods (API Server) | スケジュール対象Podの取得 | SchedulingQueueから取得 |
| Nodes (API Server) | ノード情報の参照 | フィルタリング・スコアリングで使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events (etcd) | INSERT | Kubernetes Eventオブジェクトが作成される |
| Pods (etcd) | UPDATE | Pod.Spec.NodeNameが設定される（Bind操作） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| バインド失敗 | RunBindPluginsがエラーを返却 | handleBindingCycleErrorが呼ばれ、Scheduledイベントは発行されない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | スケジューリングキューに再投入され再スケジュール |
| リトライ間隔 | バックオフに基づく |
| リトライ対象エラー | バインド失敗 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- Podのnamespace、name、割り当てノード名が通知に含まれるが、これらは公開情報である

## 備考

- Scheduledイベントはスケジューラが発行する最も基本的な成功通知
- EventRecorder.Eventfの第2引数（annotations）はnilが渡される
- Action（第5引数）は "Binding" が設定される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | schedule_one.go | `pkg/scheduler/schedule_one.go` | 行49-62: スケジューリングの定数定義 |

**読解のコツ**: kube-schedulerではイベント定数をpkg/kubelet/events/event.goのように集約せず、呼び出し箇所で直接文字列リテラルを使用している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | schedule_one.go | `pkg/scheduler/schedule_one.go` | 行65-136: ScheduleOne()メソッド全体フロー |

**主要処理フロー**:
1. **行67**: NextPod()でスケジューリング対象のPodを取得
2. **行116**: schedulingCycle()実行
3. **行123-135**: 非同期goroutineでbindingCycle()実行
4. **行130**: bindingCycle()呼び出し
5. **行131-133**: 成功時はfinishBinding()へ

#### Step 3: バインディング処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | schedule_one.go | `pkg/scheduler/schedule_one.go` | 行1015-1022: finishBinding()メソッド |

**主要処理フロー**:
- **行1016-1018**: status.IsSuccess()がfalseの場合はログのみでリターン
- **行1021**: fwk.EventRecorder().Eventf() でScheduledイベント発行

### プログラム呼び出し階層図

```
kube-scheduler
    |
    +-- Scheduler.ScheduleOne()  [行65]
           |
           +-- schedulingCycle()  [行116]
           |       +-- SchedulePod()  [行151]
           |       +-- assume()  [行200]
           |
           +-- goroutine: bindingCycle()  [行130]
                  |
                  +-- RunBindPlugins()  [行993]
                  |
                  +-- finishBinding()  [行1015]
                         +-- EventRecorder().Eventf("Scheduled")  [行1021]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

SchedulingQueue            ScheduleOne()
(Pod) ------------------> schedulingCycle()
                           |
Node情報                   +-- SchedulePod()
(Filter/Score) ----------> +-- assume()
                           |
                           v
                           bindingCycle() (async)
                           |
                           +-- RunBindPlugins()
                           |
                           +-- finishBinding()
                                +---------> Scheduled Event
                                            (Normal, Pod, "Binding")
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| schedule_one.go | `pkg/scheduler/schedule_one.go` | ソース | スケジューリング処理の主要実装（通知発行元） |
