# 通知設計書 77-SelectorRequired

## 概要

本ドキュメントは、HPA（Horizontal Pod Autoscaler）のスケールターゲットにセレクタが設定されていない際に発行されるSelectorRequired通知の設計を定義する。

### 本通知の処理概要

SelectorRequired通知は、HPAコントローラがオートスケーリングの調整処理（reconcileAutoscaler）を実行する際、スケールターゲットのScale SubresourceからPodセレクタを取得した結果、セレクタが空文字列であった場合にWarningイベントとして発行される。セレクタがないとHPAはどのPodを管理対象とすべきか判定できないため、スケーリングが停止する。

**業務上の目的・背景**：HPAは対象のDeployment/ReplicaSet等のPodセレクタに基づいてPodを識別し、メトリクスを収集してスケーリング判断を行う。セレクタが未設定の場合、HPAはPod群を特定できず、オートスケーリングが機能しない。この通知により設定ミスの早期発見を促す。

**通知の送信タイミング**：HPAコントローラのreconcileAutoscaler()内でvalidateAndParseSelector()が呼ばれ、selector引数が空文字列の場合に発行される。

**通知の受信者**：Kubernetes Event APIを通じてHPAオブジェクトに紐付くイベントとして記録される。kubectl describe hpaやイベント監視ツールを通じてHPA所有者やクラスタ管理者が受信する。

**通知内容の概要**：「selector is required」という固定メッセージが送信される。

**期待されるアクション**：HPA所有者はスケールターゲット（Deployment等）のspec.selectorが正しく設定されているか確認する。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（reconcileAutoscaler処理内で発行） |
| 優先度 | 高（HPAが完全に機能停止） |
| リトライ | なし（次回のreconcile周期で再チェック） |

### 送信先決定ロジック

対象のHPAオブジェクトを送信先として使用する。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | horizontal-pod-autoscaler |
| EventType | Warning |
| Reason | SelectorRequired |
| 対象オブジェクト | HorizontalPodAutoscaler |

### 本文テンプレート

```
selector is required
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージ | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| HPA reconcile | reconcileAutoscaler()実行 | scale.Status.Selector が空文字列 | validateAndParseSelector内で検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| セレクタが設定済み | selectorが空文字列でない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[reconcileAutoscaler開始] --> B[Scale Subresource取得]
    B --> C[validateAndParseSelector呼び出し]
    C --> D{selector == 空?}
    D -->|Yes| E[SelectorRequired Event発行]
    E --> F[ScalingActive=False条件設定]
    F --> G[エラー返却]
    D -->|No| H[セレクタ解析続行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Scale Subresource | スケールターゲットのPodセレクタ取得 | API Server経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events (etcd) | INSERT | Kubernetes Eventオブジェクトが作成される |
| HPA (etcd) | UPDATE | HPA StatusにScalingActive=False条件が設定される |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| セレクタ未設定 | Scale.Status.Selectorが空 | SelectorRequiredイベント発行、ScalingActive=False設定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | HPAの同期間隔で自動再チェック |
| リトライ間隔 | デフォルト15秒（--horizontal-pod-autoscaler-sync-period） |
| リトライ対象エラー | 全てのreconcileエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 本通知には機密情報は含まれない

## 備考

- SelectorRequiredと同時にHPAのScalingActive条件がFalse, Reason="InvalidSelector"に設定される
- validateAndParseSelector()はセレクタの空チェック、パース、曖昧性チェックの3段階を実行する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行87-99: HorizontalController構造体 |

**読解のコツ**: HorizontalControllerはeventRecorder, scaleNamespacer, mapper等を保持し、これらがイベント発行やスケール操作に使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行391-435: validateAndParseSelector()メソッド |

**主要処理フロー**:
1. **行398**: selector == "" チェック
2. **行400**: SelectorRequiredイベント発行
3. **行401**: ScalingActive=False条件設定（Reason="InvalidSelector"）
4. **行402**: エラー返却

### プログラム呼び出し階層図

```
HorizontalController
    |
    +-- reconcileAutoscaler()
           |
           +-- scaleForResourceMappings() (Scale取得)
           |
           +-- validateAndParseSelector(selector)  [行397]
                  |
                  +-- selector == "" チェック  [行398]
                  |       +-- eventRecorder.Event("SelectorRequired")  [行400]
                  |       +-- setCondition(ScalingActive=False)  [行401]
                  |
                  +-- labels.Parse(selector)  [行405]
                  +-- hpasControllingPodsUnderSelector()  [行426]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Scale Subresource          validateAndParseSelector()
(selector) -------------> selector == "" チェック
                           |
                           +-- 空 --> SelectorRequired Event
                           |          (Warning, HPA)
                           |          + ScalingActive=False
                           |
                           +-- 非空 --> セレクタ解析・曖昧性チェック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | ソース | HPAコントローラの実装（通知発行元） |
| horizontal_test.go | `pkg/controller/podautoscaler/horizontal_test.go` | テスト | HPAコントローラのテスト |
