# 通知設計書 78-InvalidSelector

## 概要

本ドキュメントは、HPA（Horizontal Pod Autoscaler）のセレクタが無効（パース不能）な場合に発行されるInvalidSelector通知の設計を定義する。

### 本通知の処理概要

InvalidSelector通知は、HPAコントローラがスケールターゲットから取得したPodセレクタ文字列をlabels.Parse()で解析しようとした際にエラーが発生した場合にWarningイベントとして発行される。セレクタの構文が不正な場合、HPAはPodの識別ができずスケーリングが停止する。

**業務上の目的・背景**：HPAのスケールターゲットに設定されたセレクタが不正な構文である場合、HPAは対象Podを特定できない。この通知により、セレクタの構文エラーを管理者が認識し、速やかに修正できるようにする。

**通知の送信タイミング**：HPAコントローラのreconcileAutoscaler()内でvalidateAndParseSelector()が呼ばれ、labels.Parse(selector)がエラーを返した場合に発行される。

**通知の受信者**：Kubernetes Event APIを通じてHPAオブジェクトに紐付くイベントとして記録される。kubectl describe hpaやイベント監視ツールを通じてHPA所有者やクラスタ管理者が受信する。

**通知内容の概要**：「couldn't convert selector into a corresponding internal selector object: {エラー詳細}」というメッセージが送信される。

**期待されるアクション**：HPA所有者はスケールターゲットのセレクタ設定を確認し、正しいラベルセレクタ構文に修正する。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（reconcileAutoscaler処理内で発行） |
| 優先度 | 高（HPAが完全に機能停止） |
| リトライ | なし（次回のreconcile周期で再チェック） |

### 送信先決定ロジック

対象のHPAオブジェクトを送信先として使用する。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | horizontal-pod-autoscaler |
| EventType | Warning |
| Reason | InvalidSelector |
| 対象オブジェクト | HorizontalPodAutoscaler |

### 本文テンプレート

```
couldn't convert selector into a corresponding internal selector object: {err}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | セレクタパースエラーの詳細 | labels.Parse()の返却エラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| HPA reconcile | reconcileAutoscaler()実行 | labels.Parse(selector)がエラー | validateAndParseSelector内で検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| セレクタパース成功 | labels.Parse()が正常にセレクタを返した場合 |
| セレクタが空 | 空の場合はSelectorRequiredが先に発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[validateAndParseSelector開始] --> B{selector == 空?}
    B -->|Yes| C[SelectorRequired発行]
    B -->|No| D[labels.Parse実行]
    D --> E{パース成功?}
    E -->|No| F[InvalidSelector Event発行]
    F --> G[ScalingActive=False条件設定]
    G --> H[エラー返却]
    E -->|Yes| I[曖昧性チェック続行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Scale Subresource | セレクタ文字列の取得 | API Server経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events (etcd) | INSERT | Kubernetes Eventオブジェクトが作成される |
| HPA (etcd) | UPDATE | HPA StatusにScalingActive=False条件が設定される |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| セレクタパースエラー | labels.Parse()が失敗 | InvalidSelectorイベント発行、ScalingActive=False設定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | HPAの同期間隔で自動再チェック |
| リトライ間隔 | デフォルト15秒 |
| リトライ対象エラー | 全てのreconcileエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- セレクタ文字列とパースエラーが通知に含まれるが、機密性は低い

## 備考

- InvalidSelectorイベントとともにHPAのScalingActive条件がFalse, Reason="InvalidSelector"に設定される
- validateAndParseSelector()の第2段階のチェックに該当する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行87-99: HorizontalController構造体 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行405-411: labels.Parse()とInvalidSelector発行 |

**主要処理フロー**:
1. **行405**: parsedSelector, err := labels.Parse(selector) 呼び出し
2. **行406**: エラーチェック
3. **行407-408**: errMsg構築、InvalidSelectorイベント発行
4. **行409**: setCondition(ScalingActive=False, Reason="InvalidSelector")
5. **行410**: エラー返却

### プログラム呼び出し階層図

```
HorizontalController
    |
    +-- reconcileAutoscaler()
           |
           +-- validateAndParseSelector(selector)  [行397]
                  |
                  +-- selector == "" チェック (SelectorRequired)
                  |
                  +-- labels.Parse(selector)  [行405]
                         |
                         +-- エラー時:
                                +-- eventRecorder.Event("InvalidSelector")  [行408]
                                +-- setCondition(ScalingActive=False)  [行409]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Scale Subresource          validateAndParseSelector()
(selector string) -------> labels.Parse()
                           |
                           +-- パースエラー --> InvalidSelector Event
                           |                   (Warning, HPA)
                           |                   + ScalingActive=False
                           |
                           +-- 成功 --> parsedSelector
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | ソース | HPAコントローラの実装（通知発行元） |
| horizontal_test.go | `pkg/controller/podautoscaler/horizontal_test.go` | テスト | HPAコントローラのテスト |
