# 通知設計書 8-ExceededGracePeriod

## 概要

本ドキュメントは、Kubernetesのkubeletがコンテナランタイムの猶予期間内にPodを終了できなかった際に発行する「ExceededGracePeriod」イベント通知の設計を記述する。

### 本通知の処理概要

kubeletのPod WorkerがPodの停止処理を実行する際、コンテナランタイムが指定された猶予期間（Grace Period）内にPodを終了できなかった場合に、タイムアウトとしてKubernetes Event APIに「ExceededGracePeriod」イベントを記録する通知である。

**業務上の目的・背景**：PodのGraceful Shutdownにおいて、猶予期間を超過してもコンテナが終了しないケースは、アプリケーションがSIGTERMシグナルを適切に処理できていないか、シャットダウン処理に時間がかかりすぎている可能性を示す。この通知により、運用者はGrace Period設定の妥当性やアプリケーションのシャットダウン処理の改善が必要かを判断できる。

**通知の送信タイミング**：`SyncTerminatingPod`関数から呼ばれるkillPodWithTimeout内で、タイムアウト期間が経過しても停止完了チャネルからの応答がない場合に発行される（`pod_workers.go` 1720行目）。

**通知の受信者**：Kubernetes Event APIを通じて記録されるため、kubectl eventsやモニタリングツールを利用するクラスタ管理者が受信者となる。Warning Eventであるため監視アラート対象となる。

**通知内容の概要**：イベントにはEventType（Warning）、Reason（ExceededGracePeriod）、およびメッセージ"Container runtime did not kill the pod within specified grace period."が含まれる。

**期待されるアクション**：運用者はアプリケーションのシャットダウン処理を見直す。具体的には、SIGTERMハンドラの実装確認、シャットダウン処理の最適化、またはterminationGracePeriodSecondsの値の調整を行う。

## 通知種別

Kubernetes Eventオブジェクト（API内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Event APIへの書き込み） |
| 優先度 | 高（Warning Event） |
| リトライ | Event API書き込み失敗時はkubelet内部でリトライ |

### 送信先決定ロジック

停止対象のPodオブジェクトに対してrecorder.Eventfを呼び出し、Kubernetes Event APIサーバへ送信する。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Event APIオブジェクトとして発行されるため、メール通知は該当しない。

### 本文テンプレート

```
Container runtime did not kill the pod within specified grace period.
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Pod名 | 対象Podの名前 | Pod.ObjectMeta.Name | Yes |
| Namespace | 対象PodのNamespace | Pod.ObjectMeta.Namespace | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| kubelet内部 | タイムアウト | time.Afterのタイムアウト発火 | 猶予期間内にkillPodが完了しなかった場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 猶予期間内に終了 | Podが猶予期間内に正常に停止した場合はイベント発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SyncTerminatingPod] --> B[killPodWithTimeout]
    B --> C[killPod実行開始]
    C --> D[select文で待機]
    D --> E{どちらが先?}
    E -->|killPod完了| F[nil返却 - 正常終了]
    E -->|タイムアウト| G[recorder.Eventf: ExceededGracePeriod]
    G --> H[タイムアウトエラー返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd（Podオブジェクト） | Podメタデータ参照 | kube-apiserver経由 |

### テーブル別参照項目詳細

#### Podオブジェクト

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.TerminationGracePeriodSeconds | タイムアウト期間の計算 | Pod停止処理時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd（Eventオブジェクト） | INSERT | ExceededGracePeriodイベントオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "ExceededGracePeriod" | イベント理由 |
| INSERT | Event.Type | "Warning" | 警告イベント |
| INSERT | Event.Message | "Container runtime did not kill the pod within specified grace period." | 固定メッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| タイムアウト | 猶予期間超過 | イベント記録後、タイムアウトエラーを返却。後続のsyncPodで再処理 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 次回のsyncPodで再度killPodが試行される |
| リトライ間隔 | Pod同期間隔に依存 |
| リトライ対象エラー | タイムアウトエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのバースト制限に依存 |
| 1日あたり上限 | 明示的な上限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- メッセージは固定文字列であり、機密情報は含まれない。

## 備考

- 本イベントはkubelet内の`pod_workers.go`の無名関数（1720行目）で発行される。select文のtime.Afterケースで発火する。
- イベント定数は`pkg/kubelet/events/event.go` 28行目で`ExceededGracePeriod = "ExceededGracePeriod"`として定義されている。
- タイムアウト後は`fmt.Errorf("timeout waiting to kill pod")`がエラーとして返却される（1721行目）。
- 正常終了の場合は、killPod完了チャネル（ch）からの受信でnilが返却される（1717-1718行目）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 28行目: `ExceededGracePeriod = "ExceededGracePeriod"` の定数定義 |

**読解のコツ**: ExceededGracePeriodはContainer event reason listに含まれるが、実際にはPod単位のタイムアウトイベントである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pod_workers.go | `pkg/kubelet/pod_workers.go` | 1715-1724行目: タイムアウト処理のselect文 |

**主要処理フロー**:
1. **1716行目**: select文でkillPod完了またはタイムアウトを待機
2. **1717-1718行目**: killPod完了チャネルからの受信 - 正常終了
3. **1719行目**: time.After(timeoutDuration)でタイムアウト検出
4. **1720行目**: recorder.EventfでExceededGracePeriodイベント発行
5. **1721行目**: タイムアウトエラーを返却

#### Step 3: 呼び出し元のSyncTerminatingPodを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pod_workers.go | `pkg/kubelet/pod_workers.go` | SyncTerminatingPod関数。killPodWithTimeoutの呼び出し元 |

### プログラム呼び出し階層図

```
podWorkers.managePodLoop()
    |
    +-- kubelet.SyncTerminatingPod()
           |
           +-- killPodWithTimeout()              [pod_workers.go内の無名関数]
                  |
                  +-- killPod()                   [goroutine内]
                  +-- select {
                  |      case <-ch:              [正常終了]
                  |      case <-time.After():    [タイムアウト]
                  |             |
                  |             +-- recorder.Eventf(ExceededGracePeriod)  [行1720]
                  |             +-- return timeout error
                  |   }
```

### データフロー図

```
[入力]                              [処理]                              [出力]

Pod停止要求        ------>  killPodWithTimeout()            ------>  Kubernetes Event
(GracePeriod付き)            |                                       (Type: Warning,
                             +-- killPod() [goroutine]               Reason: ExceededGracePeriod,
                             +-- select{                             Message: "Container runtime did not...")
                             |     time.After(timeout)                |
                             |   }                              ------>  timeout error
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| pod_workers.go | `pkg/kubelet/pod_workers.go` | ソース | Pod Worker処理およびタイムアウトイベント記録 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | SyncTerminatingPodの実装 |
