# 通知設計書 80-FailedGetScale

## 概要

本ドキュメントは、HPAがスケールターゲットのScale Subresource取得に失敗した際に発行されるFailedGetScale通知の設計を定義する。

### 本通知の処理概要

FailedGetScale通知は、HPAコントローラがオートスケーリングの調整処理（reconcileAutoscaler）を実行する際、スケールターゲットのAPIバージョン解析、RESTマッピング解決、またはScale Subresource取得のいずれかに失敗した場合にWarningイベントとして発行される。Scale情報が取得できないとHPAは現在のレプリカ数やセレクタを知ることができず、スケーリング判断が不可能となる。

**業務上の目的・背景**：HPAはスケールターゲット（Deployment, ReplicaSet等）のScale Subresourceから現在のレプリカ数とPodセレクタを取得する。この取得に失敗すると、HPAのオートスケーリング機能が完全に停止する。原因としてはAPIバージョンの不正、リソースの未登録、権限不足等が考えられる。

**通知の送信タイミング**：HPAコントローラのreconcileAutoscaler()内で、(1) schema.ParseGroupVersion()によるAPIバージョン解析失敗、(2) mapper.RESTMappings()によるリソースマッピング解決失敗、(3) scaleForResourceMappings()によるScale取得失敗、のいずれかが発生した場合に発行される。

**通知の受信者**：Kubernetes Event APIを通じてHPAオブジェクトに紐付くイベントとして記録される。kubectl describe hpaやイベント監視ツールを通じてHPA所有者やクラスタ管理者が受信する。

**通知内容の概要**：失敗したAPI操作のエラー詳細がメッセージとして通知される。

**期待されるアクション**：HPA所有者はscaleTargetRefの設定（APIバージョン、Kind、名前）を確認し、スケールターゲットが正しく存在し、Scale Subresourceをサポートしていることを検証する。必要に応じてRBAC権限も確認する。

## 通知種別

Kubernetes Event（Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（reconcileAutoscaler処理内で発行） |
| 優先度 | 高（HPAが完全に機能停止） |
| リトライ | なし（次回のreconcile周期で再チェック） |

### 送信先決定ロジック

対象のHPAオブジェクトを送信先として使用する。

## 通知テンプレート

### Kubernetes Eventの場合

| 項目 | 内容 |
|-----|------|
| 送信元コンポーネント | horizontal-pod-autoscaler |
| EventType | Warning |
| Reason | FailedGetScale |
| 対象オブジェクト | HorizontalPodAutoscaler |

### 本文テンプレート

```
{err.Error()}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | Scale取得失敗のエラー詳細 | ParseGroupVersion / RESTMappings / scaleForResourceMappings のエラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| HPA reconcile | reconcileAutoscaler()実行 | ParseGroupVersion()失敗 | APIバージョン文字列の解析エラー |
| HPA reconcile | reconcileAutoscaler()実行 | mapper.RESTMappings()失敗 | リソースマッピングの解決失敗 |
| HPA reconcile | reconcileAutoscaler()実行 | scaleForResourceMappings()失敗 | Scale Subresourceの取得失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Scale取得成功 | 全ての取得ステップが成功した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[reconcileAutoscaler開始] --> B[ParseGroupVersion]
    B --> C{成功?}
    C -->|No| D[FailedGetScale Event発行 - APIバージョン]
    C -->|Yes| E[RESTMappings取得]
    E --> F{成功?}
    F -->|No| G[FailedGetScale Event発行 - マッピング]
    F -->|Yes| H[scaleForResourceMappings実行]
    H --> I{成功?}
    I -->|No| J[FailedGetScale Event発行 - Scale取得]
    I -->|Yes| K[スケーリング処理続行]
    D --> L[AbleToScale=False, ステータス更新]
    G --> L
    J --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Scale Subresource | スケールターゲットの状態取得 | API Server経由 |
| REST Mappings | リソースのAPI情報解決 | mapper経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Events (etcd) | INSERT | Kubernetes Eventオブジェクトが作成される |
| HPA (etcd) | UPDATE | HPA StatusにAbleToScale=False条件が設定される |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| APIバージョン解析エラー | scaleTargetRef.APIVersionが不正 | FailedGetScaleイベント発行、AbleToScale=False設定 |
| RESTマッピング解決エラー | リソースタイプが未登録/不正 | FailedGetScaleイベント発行、AbleToScale=False設定 |
| Scale取得エラー | スケールリソースが存在しない/権限不足 | FailedGetScaleイベント発行、AbleToScale=False設定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | HPAの同期間隔で自動再チェック |
| リトライ間隔 | デフォルト15秒 |
| リトライ対象エラー | 全てのreconcileエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event APIのレート制限に従う |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにリソース名やAPIバージョン情報が含まれるが、機密性は低い

## 備考

- FailedGetScaleは3箇所で発行される可能性がある（APIバージョン解析、マッピング解決、Scale取得）
- 同時にHPAのAbleToScale条件がFalse, Reason="FailedGetScale"に設定される
- 条件メッセージは "the HPA controller was unable to get the target's current scale: {err}" 形式

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行87-99: HorizontalController構造体（scaleNamespacer, mapper） |

**読解のコツ**: scaleNamespacerはScale Subresource操作、mapperはリソースのREST APIマッピング解決に使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行782-815: reconcileAutoscaler内のScale取得処理 |

**主要処理フロー**:
1. **行782**: targetGV, err := schema.ParseGroupVersion(hpa.Spec.ScaleTargetRef.APIVersion)
2. **行783-789**: パース失敗時: FailedGetScaleイベント発行（第1発行箇所）
3. **行797**: mappings, err := a.mapper.RESTMappings(targetGK)
4. **行798-804**: マッピング失敗時: FailedGetScaleイベント発行（第2発行箇所）
5. **行807**: scale, targetGR, err := a.scaleForResourceMappings(...)
6. **行808-814**: Scale取得失敗時: FailedGetScaleイベント発行（第3発行箇所）
7. **行816**: 成功時: AbleToScale=True, Reason="SucceededGetScale"設定

#### Step 3: 各エラーパスの詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行784-785: 第1発行箇所（APIバージョン解析エラー） |
| 3-2 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行799-800: 第2発行箇所（RESTマッピング解決エラー） |
| 3-3 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | 行809-810: 第3発行箇所（Scale取得エラー） |

**共通パターン**:
- eventRecorder.Event(hpa, v1.EventTypeWarning, "FailedGetScale", err.Error())
- setCondition(hpa, AbleToScale, ConditionFalse, "FailedGetScale", "the HPA controller was unable to get the target's current scale: %v", err)
- updateStatusIfNeeded()呼び出し

### プログラム呼び出し階層図

```
HorizontalController
    |
    +-- reconcileAutoscaler()
           |
           +-- schema.ParseGroupVersion()  [行782]
           |       +-- 失敗: eventRecorder.Event("FailedGetScale")  [行784]
           |       +-- 失敗: setCondition(AbleToScale=False)  [行785]
           |
           +-- mapper.RESTMappings()  [行797]
           |       +-- 失敗: eventRecorder.Event("FailedGetScale")  [行799]
           |       +-- 失敗: setCondition(AbleToScale=False)  [行800]
           |
           +-- scaleForResourceMappings()  [行807]
                   +-- 失敗: eventRecorder.Event("FailedGetScale")  [行809]
                   +-- 失敗: setCondition(AbleToScale=False)  [行810]
                   |
                   +-- 成功: setCondition(AbleToScale=True, "SucceededGetScale")  [行816]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

HPA Spec                   reconcileAutoscaler()
(scaleTargetRef) --------> ParseGroupVersion()
                           |
API Server                 +-- RESTMappings()
(resource mappings) -----> |
                           +-- scaleForResourceMappings()
                           |
                           +-- いずれか失敗 --> FailedGetScale Event
                           |                   (Warning, HPA)
                           |                   + AbleToScale=False
                           |
                           +-- 全て成功 --> Scale情報取得完了
                                            + AbleToScale=True
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | ソース | HPAコントローラの実装（通知発行元） |
| horizontal_test.go | `pkg/controller/podautoscaler/horizontal_test.go` | テスト | HPAコントローラのテスト |
