# 通知設計書 83-SuccessfulRescale

## 概要

本ドキュメントは、Kubernetes HorizontalPodAutoscaler (HPA) コントローラによるスケール変更が正常に完了した際に発行される `SuccessfulRescale` イベント通知の設計を記載する。

### 本通知の処理概要

HPA コントローラがメトリクスに基づき算出した希望レプリカ数へのスケール変更を正常に完了した場合にこの通知が発行される。

**業務上の目的・背景**：オートスケーリングが正常に機能していることを監査ログとして記録する目的がある。運用者はこの通知により、スケールアップ・スケールダウンが意図通りに実行されたことを確認できる。また、スケーリング履歴の追跡やキャパシティプランニングに活用できる。

**通知の送信タイミング**：reconcileAutoscaler 内で Scale サブリソースの Update API が成功した直後に発行される。retry.RetryOnConflict によるリトライが成功した場合も含む。

**通知の受信者**：HPA オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe hpa や外部モニタリングシステムを通じて運用者・SRE が受信する。

**通知内容の概要**：新しいレプリカ数とスケール変更の理由が含まれる。フォーマット：「New size: %d; reason: %s」

**期待されるアクション**：通常、運用者に即座のアクションは求められない。ただし、頻繁なスケーリングが発生している場合はメトリクス閾値やスケーリングポリシーの調整を検討する。

## 通知種別

Kubernetes Event（EventType: Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（reconcile ループ内で即座に発行） |
| 優先度 | 中（Normal イベント） |
| リトライ | なし（成功時のみ発行） |

### 送信先決定ロジック

HPA オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

```
New size: %d; reason: %s
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| desiredReplicas | 新しい希望レプリカ数 | normalizeDesiredReplicas の計算結果 | Yes |
| rescaleReason | スケール変更の理由 | メトリクス名 + "above target" / "All metrics below target" | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | HPA reconcile ループ | Scale サブリソースの Update が成功 | スケール変更成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| rescale == false | 現在のレプリカ数と希望レプリカ数が同じ場合 |
| Scale Update 失敗 | FailedRescale が代わりに発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[reconcileAutoscaler] --> B[desiredReplicas != currentReplicas]
    B -->|Yes| C[retry.RetryOnConflict でスケール更新]
    C -->|成功| D[SuccessfulRescale イベント発行]
    C -->|失敗| E[FailedRescale イベント]
    D --> F[AbleToScale condition を True に設定]
    F --> G[storeScaleEvent でスケールイベント記録]
    G --> H[ステータス更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| HorizontalPodAutoscaler | HPA スペック・ステータス取得 | Informer キャッシュ経由 |
| Scale subresource | スケール対象のレプリカ数取得・更新 | API サーバ直接 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Scale subresource | UPDATE | レプリカ数の変更 |
| HorizontalPodAutoscaler.Status | UPDATE | lastScaleTime, conditions の更新 |
| Event | INSERT | Normal イベントの記録 |

## エラー処理

### エラーケース一覧

該当なし（本通知は成功時にのみ発行される）

### リトライ仕様

該当なし

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- イベントメッセージにリソース名が含まれるが、秘匿情報は含まない

## 備考

- この通知発行時には AbleToScale condition が True / SucceededRescale に設定される
- スケールアップの場合は monitor に ActionLabelScaleUp、スケールダウンの場合は ActionLabelScaleDown が記録される
- storeScaleEvent でスケーリングイベントが内部記録され、将来のスケーリング制限に使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/autoscaling/v2/types.go` | HorizontalPodAutoscaler, HorizontalPodAutoscalerCondition |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | reconcileAutoscaler のスケーリング成功パス |

**主要処理フロー**:
1. **行 895**: rescale == true の判定
2. **行 896-920**: retry.RetryOnConflict によるスケール更新
3. **行 934**: AbleToScale condition を True / SucceededRescale に設定
4. **行 935**: SuccessfulRescale Eventf の発行
5. **行 936**: storeScaleEvent でスケールイベントを内部記録
6. **行 943-947**: actionLabel の設定（ScaleUp / ScaleDown）

### プログラム呼び出し階層図

```
HorizontalController.reconcileAutoscaler (行 759)
    |
    +-- computeReplicasForMetrics ... レプリカ数計算
    |
    +-- retry.RetryOnConflict (行 896)
    |      +-- scaleNamespacer.Scales().Update (行 903) ... 成功
    |
    +-- setCondition (行 934) ... AbleToScale = True
    +-- eventRecorder.Eventf (行 935) ... SuccessfulRescale 発行
    +-- storeScaleEvent (行 936) ... スケールイベント記録
    +-- monitor.ObserveDesiredReplicas (行 963)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HPA Spec ----------------> reconcileAutoscaler ---------> Event: SuccessfulRescale
Scale Subresource -------> Scale.Update (成功)          HPA Status (lastScaleTime, conditions)
Metrics -----------------> desiredReplicas 算出          Monitor metrics
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | ソース | HPA コントローラのメインロジック |
| monitor.go | `pkg/controller/podautoscaler/monitor/monitor.go` | ソース | HPA モニタリング |
