# 通知設計書 84-FailedUpdateStatus

## 概要

本ドキュメントは、Kubernetes HorizontalPodAutoscaler (HPA) コントローラがステータス更新に失敗した際に発行される `FailedUpdateStatus` イベント通知の設計を記載する。

### 本通知の処理概要

HPA コントローラが reconcile 処理の最後に HPA オブジェクトのステータス（currentReplicas, desiredReplicas, conditions, lastScaleTime 等）を API サーバに更新しようとして失敗した場合にこの通知が発行される。

**業務上の目的・背景**：HPA のステータス更新はスケーリング処理の最終段階であり、これが失敗するとダッシュボードやモニタリングツールに表示される HPA の状態が実際と乖離する。運用者はこの通知を受けて API サーバの状態を確認する必要がある。

**通知の送信タイミング**：reconcileAutoscaler 内の updateStatus メソッドで HorizontalPodAutoscalers().UpdateStatus() API 呼び出しが失敗した場合に発行される。

**通知の受信者**：HPA オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe hpa や外部モニタリングシステムを通じて運用者が受信する。

**通知内容の概要**：API サーバから返されたエラーメッセージが含まれる。

**期待されるアクション**：運用者は API サーバの稼働状態を確認する。通常は一時的な問題であり、次の reconcile ループで自動的にリトライされる。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（updateStatus 内で即座に発行） |
| 優先度 | 中（Warning イベント） |
| リトライ | resyncPeriod ごとに自動再試行 |

### 送信先決定ロジック

HPA オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

```
%v
```

エラーメッセージがそのまま通知本文となる。

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | エラー詳細 | UpdateStatus API のエラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | HPA reconcile ループ | UpdateStatus API が失敗 | ステータス更新失敗時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ステータスに変更なし | oldStatus と newStatus が DeepEqual の場合は UpdateStatus 自体が呼ばれない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[reconcileAutoscaler 完了] --> B[updateStatusIfNeeded]
    B -->|ステータス変更あり| C[updateStatus]
    B -->|変更なし| D[スキップ]
    C --> E[HorizontalPodAutoscalers.UpdateStatus]
    E -->|成功| F[正常終了]
    E -->|失敗| G[FailedUpdateStatus イベント発行]
    G --> H[エラー返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| HorizontalPodAutoscaler | HPA ステータスの比較 | Informer キャッシュ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| HorizontalPodAutoscaler.Status | UPDATE（失敗） | ステータス更新試行 |
| Event | INSERT | Warning イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| API サーバエラー | ネットワーク障害、API サーバ過負荷 | 次の resyncPeriod で自動リトライ |
| Conflict エラー | 他のクライアントによる同時更新 | 次の resyncPeriod で自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（resyncPeriod ごと） |
| リトライ間隔 | resyncPeriod |
| リトライ対象エラー | 全てのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージに HPA 名が含まれるが、秘匿情報は含まない

## 備考

- updateStatus は reconcile ループの複数箇所から呼ばれる可能性がある
- updateStatusIfNeeded で DeepEqual チェックにより不要な更新は回避される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/autoscaling/v2/types.go` | HorizontalPodAutoscalerStatus の構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | updateStatus 関数 |

**主要処理フロー**:
1. **行 1436-1442**: updateStatusIfNeeded で DeepEqual チェック
2. **行 1445-1454**: updateStatus で UpdateStatus API 呼び出し
3. **行 1448**: FailedUpdateStatus イベント発行
4. **行 1449**: エラーメッセージ生成と返却

### プログラム呼び出し階層図

```
HorizontalController.reconcileAutoscaler (行 759)
    |
    +-- updateStatusIfNeeded (行 965)
           |
           +-- apiequality.Semantic.DeepEqual (行 1438) ... 変更有無チェック
           |
           +-- updateStatus (行 1441)
                  |
                  +-- hpaNamespacer.HorizontalPodAutoscalers().UpdateStatus (行 1446)
                  +-- eventRecorder.Event (行 1448) ... FailedUpdateStatus 発行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HPA Status (old) -------> DeepEqual 比較 ---------> Event: FailedUpdateStatus
HPA Status (new) -------> UpdateStatus API (失敗)    エラーログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| horizontal.go | `pkg/controller/podautoscaler/horizontal.go` | ソース | HPA コントローラのメインロジック |
