# 通知設計書 85-ScalingReplicaSet

## 概要

本ドキュメントは、Kubernetes Deployment コントローラが ReplicaSet のスケーリングを実行した際に発行される `ScalingReplicaSet` イベント通知の設計を記載する。

### 本通知の処理概要

Deployment コントローラが ReplicaSet のレプリカ数を変更する際にこの通知が発行される。新しい ReplicaSet の作成時のスケールアップ、および既存 ReplicaSet のスケールアップ・スケールダウンの両方で発行される。

**業務上の目的・背景**：Deployment のローリングアップデートやスケーリング操作の進行状況を追跡するために重要な通知である。運用者はこの通知により、デプロイメントの進行状況をリアルタイムで監視し、ロールアウトが正常に進んでいるかを確認できる。

**通知の送信タイミング**：(1) 新しい ReplicaSet が作成され初期レプリカ数が 0 より大きい場合（行 286）、(2) 既存の ReplicaSet のレプリカ数が変更された場合（行 433）の2箇所で発行される。

**通知の受信者**：Deployment オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe deployment、kubectl rollout status、外部モニタリングシステムを通じて運用者が受信する。

**通知内容の概要**：スケール方向（up/down）、対象 ReplicaSet 名、変更前後のレプリカ数が含まれる。

**期待されるアクション**：通常のデプロイメント操作の一環として発行されるため、即座のアクションは不要。ただし、スケーリングが意図しないタイミングで発生している場合は Deployment の設定を確認する。

## 通知種別

Kubernetes Event（EventType: Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コントローラ同期ループ内で即座に発行） |
| 優先度 | 中（Normal イベント） |
| リトライ | なし（成功時のみ発行） |

### 送信先決定ロジック

Deployment オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

新規 ReplicaSet 作成時:
```
Scaled up replica set %s from 0 to %d
```

既存 ReplicaSet スケール変更時:
```
Scaled %s replica set %s from %d to %d
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| scalingOperation | スケール方向 (up/down) | oldScale vs newScale の比較 | Yes |
| rs.Name | ReplicaSet 名 | ReplicaSet オブジェクト | Yes |
| oldScale | 変更前レプリカ数 | rs.Spec.Replicas | Yes |
| newScale | 変更後レプリカ数 | 計算結果 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | Deployment reconcile | 新規 RS 作成 + レプリカ数 > 0 | 新しい RS が作成された場合 |
| コントローラ同期 | Deployment reconcile | RS のレプリカ数が変更された | scaleReplicaSet でサイズ変更成功 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| sizeNeedsUpdate == false | レプリカ数に変更がない場合 |
| RS 更新失敗 | API 呼び出しが失敗した場合はイベントは発行されない |
| 新規 RS で replicas == 0 | 初期レプリカ数が 0 の場合は発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Deployment syncDeployment] --> B{戦略タイプ}
    B -->|RollingUpdate| C[rolloutRolling]
    B -->|Recreate| D[rolloutRecreate]
    B -->|Scaling| E[scale]
    C --> F[getNewReplicaSet / scaleReplicaSet]
    D --> F
    E --> F
    F --> G{レプリカ数変更成功?}
    G -->|Yes| H[ScalingReplicaSet イベント発行]
    G -->|No| I[エラー処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Deployment | Deployment スペック取得 | Informer キャッシュ経由 |
| ReplicaSet | RS 一覧・レプリカ数取得 | Informer キャッシュ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ReplicaSet | CREATE/UPDATE | RS の作成またはレプリカ数更新 |
| Deployment.Status | UPDATE | ステータス同期 |
| Event | INSERT | Normal イベントの記録 |

## エラー処理

### エラーケース一覧

該当なし（本通知は成功時にのみ発行される）

### リトライ仕様

該当なし

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- イベントメッセージに ReplicaSet 名とレプリカ数が含まれるが、秘匿情報は含まない

## 備考

- ローリングアップデート中は新旧 ReplicaSet の両方に対してこの通知が発行される
- proportional scaling の場合、複数の ReplicaSet に対して個別にイベントが発行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/apps/v1/types.go` | Deployment, ReplicaSet, DeploymentStrategy の構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deployment_controller.go | `pkg/controller/deployment/deployment_controller.go` | syncDeployment (行 589) がメインの同期関数 |

**主要処理フロー**:
1. **行 617**: Deployment の DeepCopy
2. **行 617-618**: SelectingAll チェック
3. **行 660-661**: ロールバック判定
4. **行 664-669**: スケーリングイベント判定
5. **行 672-677**: 戦略タイプに基づくディスパッチ

#### Step 3: スケーリングロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | sync.go | `pkg/controller/deployment/sync.go` | scaleReplicaSet (行 408-437) がイベント発行箇所 |
| 3-2 | sync.go | `pkg/controller/deployment/sync.go` | getNewReplicaSet (行 146-300) で新規 RS 作成時のイベント |
| 3-3 | sync.go | `pkg/controller/deployment/sync.go` | scale (行 307-401) で proportional scaling |

**主要処理フロー**:
- **行 420-437**: scaleReplicaSet でレプリカ数変更と EventType: Normal 発行
- **行 286**: 新規 RS 作成成功時の ScalingReplicaSet イベント
- **行 433**: 既存 RS スケール変更時の ScalingReplicaSet イベント

### プログラム呼び出し階層図

```
DeploymentController.syncDeployment (行 589)
    |
    +-- sync (行 57) / rolloutRolling / rolloutRecreate
    |      |
    |      +-- getNewReplicaSet (行 146)
    |      |      +-- ReplicaSets.Create (行 232)
    |      |      +-- eventRecorder.Eventf (行 286) ... ScalingReplicaSet
    |      |
    |      +-- scale (行 307)
    |             +-- scaleReplicaSet (行 408)
    |                    +-- ReplicaSets.Update (行 424)
    |                    +-- eventRecorder.Eventf (行 433) ... ScalingReplicaSet
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Deployment Spec ---------> syncDeployment ------------> Event: ScalingReplicaSet
ReplicaSet 一覧 ---------> scale / getNewReplicaSet --> ReplicaSet (レプリカ数変更)
                                                        Deployment Status
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deployment_controller.go | `pkg/controller/deployment/deployment_controller.go` | ソース | Deployment コントローラのメインロジック |
| sync.go | `pkg/controller/deployment/sync.go` | ソース | 同期・スケーリングロジック |
| rolling.go | `pkg/controller/deployment/rolling.go` | ソース | ローリングアップデートロジック |
| recreate.go | `pkg/controller/deployment/recreate.go` | ソース | Recreate 戦略ロジック |
| deployment_util.go | `pkg/controller/deployment/util/deployment_util.go` | ソース | ユーティリティ関数 |
