# 通知設計書 86-FailedRSCreateReason

## 概要

本ドキュメントは、Kubernetes Deployment コントローラが新しい ReplicaSet の作成に失敗した際に発行される `FailedRSCreateReason`（ReplicaSetCreateError）イベント通知の設計を記載する。

### 本通知の処理概要

Deployment コントローラが新しいバージョンの ReplicaSet を作成しようとしたが、API サーバへの Create 呼び出しが失敗した場合にこの通知が発行される。

**業務上の目的・背景**：新しい ReplicaSet の作成はデプロイメントのロールアウトプロセスの重要なステップであり、この失敗はデプロイメントの進行が停止することを意味する。運用者はこの通知を受けてデプロイメントの問題を速やかに検知し、原因を調査する必要がある。

**通知の送信タイミング**：getNewReplicaSet 関数内で ReplicaSets.Create API 呼び出しが失敗した際に発行される。ただし、AlreadyExists エラーと NamespaceTerminating エラーは除外される。

**通知の受信者**：Deployment オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe deployment や外部モニタリングシステムを通じて運用者が受信する。

**通知内容の概要**：作成に失敗した ReplicaSet の名前とエラー詳細が含まれる。フォーマット：「Failed to create new replica set %q: %v」

**期待されるアクション**：運用者はエラーメッセージを確認し、リソースクォータの超過、RBAC 権限の不足、API サーバの問題等を調査する。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（コントローラ同期ループ内で即座に発行） |
| 優先度 | 高（Warning イベント） |
| リトライ | Deployment コントローラの requeue により自動再試行 |

### 送信先決定ロジック

Deployment オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

```
Failed to create new replica set %q: %v
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| newRS.Name | 作成に失敗した ReplicaSet 名 | 生成された RS 名 | Yes |
| err | エラー詳細 | Create API のエラー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | Deployment reconcile | ReplicaSets.Create 失敗（AlreadyExists/NamespaceTerminating 以外） | RS 作成失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| errors.IsAlreadyExists(err) | RS が既に存在する場合（ハッシュ衝突処理） |
| errors.HasStatusCause(err, NamespaceTerminatingCause) | Namespace が終了中の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[getNewReplicaSet] --> B[ReplicaSets.Create]
    B -->|AlreadyExists| C[ハッシュ衝突処理]
    B -->|NamespaceTerminating| D[何もしない]
    B -->|その他のエラー| E[FailedRSCreateReason イベント発行]
    E --> F[DeploymentProgressing condition = False]
    F --> G[Deployment ステータス更新]
    B -->|成功| H[ScalingReplicaSet イベント]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Deployment | Deployment スペック取得 | Informer キャッシュ経由 |
| ReplicaSet | 既存 RS 一覧 | Informer キャッシュ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ReplicaSet | CREATE（失敗） | RS 作成試行 |
| Deployment.Status | UPDATE | DeploymentProgressing condition 更新 |
| Event | INSERT | Warning イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リソースクォータ超過 | RS 数やレプリカ数がクォータを超過 | クォータを調整 |
| RBAC 権限不足 | コントローラに RS 作成権限がない | ClusterRole を確認 |
| API サーバ不通 | ネットワーク障害 | コントローラの requeue で自動リトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大 15 回（maxRetries） |
| リトライ間隔 | 指数バックオフ（5ms * 2^(retry-1)） |
| リトライ対象エラー | 全てのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージに RS 名が含まれるが、秘匿情報は含まない

## 備考

- FailedRSCreateReason の定数値は "ReplicaSetCreateError"（deployment_util.go 行 75）
- HasProgressDeadline が設定されている場合のみ DeploymentProgressing condition が更新される
- ハッシュ衝突の場合は CollisionCount がインクリメントされ、次の sync で再試行される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deployment_util.go | `pkg/controller/deployment/util/deployment_util.go` | FailedRSCreateReason 定数（行 75） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | sync.go | `pkg/controller/deployment/sync.go` | getNewReplicaSet (行 146-300) |

**主要処理フロー**:
1. **行 232**: ReplicaSets.Create API 呼び出し
2. **行 235-268**: AlreadyExists 時のハッシュ衝突処理
3. **行 269-271**: NamespaceTerminating 処理
4. **行 272-283**: その他のエラー時の FailedRSCreateReason イベント発行
5. **行 275**: DeploymentProgressing condition を False に設定
6. **行 282**: eventRecorder.Eventf で Warning イベント発行

### プログラム呼び出し階層図

```
DeploymentController.syncDeployment (行 589)
    |
    +-- getAllReplicaSetsAndSyncRevision (行 124)
           |
           +-- getNewReplicaSet (行 146)
                  |
                  +-- ReplicaSets.Create (行 232)
                  |      |
                  |      +-- [失敗] deploymentutil.NewDeploymentCondition (行 275)
                  |      +-- [失敗] eventRecorder.Eventf (行 282) ... FailedRSCreateReason
                  |
                  +-- [成功] eventRecorder.Eventf (行 286) ... ScalingReplicaSet
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Deployment Spec ---------> getNewReplicaSet -----------> Event: FailedRSCreateReason (Warning)
PodTemplate Hash --------> ReplicaSets.Create (失敗)     Deployment Status (Progressing=False)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| sync.go | `pkg/controller/deployment/sync.go` | ソース | RS 作成・スケーリングロジック |
| deployment_controller.go | `pkg/controller/deployment/deployment_controller.go` | ソース | コントローラのメインループ |
| deployment_util.go | `pkg/controller/deployment/util/deployment_util.go` | ソース | 定数定義・ユーティリティ |
