# 通知設計書 87-SelectingAll

## 概要

本ドキュメントは、Kubernetes Deployment が全ての Pod を選択するセレクタを使用している場合に発行される `SelectingAll` イベント通知の設計を記載する。

### 本通知の処理概要

Deployment のセレクタ（spec.selector）が空の LabelSelector と一致する場合、全ての Pod を選択してしまう危険な設定であるため、この警告通知が発行される。

**業務上の目的・背景**：空のセレクタは Namespace 内の全 Pod を対象としてしまい、他のコントローラが管理する Pod にまで影響を及ぼす可能性がある。この通知は設定ミスを運用者に警告し、意図しない Pod の管理を防止する。

**通知の送信タイミング**：syncDeployment の初期段階で Deployment の spec.selector が空の LabelSelector（metav1.LabelSelector{}）と一致するか DeepEqual で比較し、一致した場合に即座に発行される。

**通知の受信者**：Deployment オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe deployment や外部モニタリングシステムを通じて運用者が受信する。

**通知内容の概要**：「This deployment is selecting all pods. A non-empty selector is required.」という固定メッセージ。

**期待されるアクション**：運用者は Deployment の spec.selector に適切なラベルセレクタを設定する必要がある。通常、API サーバのバリデーションで空セレクタは拒否されるため、この状態は稀にしか発生しない。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncDeployment 内で即座に発行） |
| 優先度 | 高（Warning イベント、設定エラー） |
| リトライ | Deployment が更新されるまで毎回の sync で発行 |

### 送信先決定ロジック

Deployment オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

```
This deployment is selecting all pods. A non-empty selector is required.
```

### 添付ファイル

該当なし

## テンプレート変数

該当なし（固定メッセージ）

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | Deployment reconcile | d.Spec.Selector が空の LabelSelector と DeepEqual | 全 Pod 選択セレクタ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非空セレクタ | 適切なセレクタが設定されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncDeployment] --> B{d.Spec.Selector == empty?}
    B -->|Yes| C[SelectingAll イベント発行]
    C --> D[ObservedGeneration 更新]
    D --> E[処理終了（return nil）]
    B -->|No| F[通常のデプロイメント処理続行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Deployment | Deployment スペック取得 | Informer キャッシュ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Deployment.Status | UPDATE | ObservedGeneration の更新 |
| Event | INSERT | Warning イベントの記録 |

## エラー処理

### エラーケース一覧

該当なし（本通知は設定エラーの検出であり、処理エラーではない）

### リトライ仕様

該当なし

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- 固定メッセージのため秘匿情報の漏洩リスクはない

## 備考

- この通知が発行された場合、syncDeployment は即座に return nil で終了し、それ以上のデプロイメント処理は行われない
- ObservedGeneration が現在の Generation より小さい場合のみステータス更新が行われる
- API サーバのバリデーションにより、通常この状態は発生しない（レガシーリソースの可能性）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deployment_controller.go | `pkg/controller/deployment/deployment_controller.go` | syncDeployment (行 589) |

**主要処理フロー**:
1. **行 616-617**: LabelSelector の空チェック（DeepEqual）
2. **行 618**: SelectingAll Eventf の発行
3. **行 619-621**: ObservedGeneration の更新とステータス更新
4. **行 623**: return nil で処理終了

### プログラム呼び出し階層図

```
DeploymentController.syncDeployment (行 589)
    |
    +-- reflect.DeepEqual(d.Spec.Selector, &everything) (行 617)
    |
    +-- eventRecorder.Eventf (行 618) ... SelectingAll
    |
    +-- Deployments.UpdateStatus (行 621) ... ObservedGeneration 更新
    |
    +-- return nil (行 623)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Deployment Spec ---------> DeepEqual チェック ----------> Event: SelectingAll (Warning)
d.Spec.Selector             (空セレクタ検出)             Deployment Status (ObservedGeneration)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| deployment_controller.go | `pkg/controller/deployment/deployment_controller.go` | ソース | syncDeployment でのセレクタチェック |
