# 通知設計書 88-RollbackDone

## 概要

本ドキュメントは、Kubernetes Deployment のロールバックが完了した際に発行される `RollbackDone`（DeploymentRollback）イベント通知の設計を記載する。

### 本通知の処理概要

Deployment コントローラが指定されたリビジョンへのロールバック処理を正常に完了した場合にこの通知が発行される。ロールバックは deprecated の rollbackTo アノテーションを使用するレガシー機能である。

**業務上の目的・背景**：Deployment のロールバックはサービス障害時の緊急対応として使用される。この通知により運用者はロールバックが正常に完了したことを確認し、サービスの復旧状況を把握できる。

**通知の送信タイミング**：rollbackToTemplate 関数でテンプレートの変更が成功し、performedRollback が true かつエラーがない場合に発行される。

**通知の受信者**：Deployment オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe deployment や外部モニタリングシステムを通じて運用者が受信する。

**通知内容の概要**：ロールバック先のリビジョン番号を含むメッセージ。フォーマット：「Rolled back deployment %q to revision %d」

**期待されるアクション**：運用者はロールバック後のサービス状態を確認し、ロールバック元の問題を調査・修正する。

## 通知種別

Kubernetes Event（EventType: Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（rollback 処理内で即座に発行） |
| 優先度 | 中（Normal イベント） |
| リトライ | なし（成功時のみ発行） |

### 送信先決定ロジック

Deployment オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

```
Rolled back deployment %q to revision %d
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| d.Name | Deployment 名 | Deployment オブジェクト | Yes |
| rollbackTo.Revision | ロールバック先リビジョン番号 | Deployment のアノテーション | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | Deployment reconcile（ロールバック処理） | performedRollback == true かつ err == nil | ロールバック成功 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| テンプレート変更なし | ロールバック先の RS テンプレートが現在と同じ場合（RollbackTemplateUnchanged） |
| リビジョン不存在 | 指定リビジョンの RS が見つからない場合（RollbackRevisionNotFound） |
| ロールバック中のエラー | rollbackToTemplate でエラーが発生した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncDeployment] --> B{getRollbackTo != nil?}
    B -->|Yes| C[rollback]
    B -->|No| D[通常処理]
    C --> E[getAllReplicaSetsAndSyncRevision]
    E --> F{指定リビジョンの RS 検索}
    F -->|Found| G[rollbackToTemplate]
    F -->|Not Found| H[RollbackRevisionNotFound Warning]
    G --> I{テンプレート変更あり?}
    I -->|Yes| J[performedRollback = true]
    I -->|No| K[RollbackTemplateUnchanged Warning]
    J --> L{err == nil?}
    L -->|Yes| M[RollbackDone イベント発行]
    L -->|No| N[エラー処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Deployment | Deployment スペック・アノテーション取得 | Informer キャッシュ経由 |
| ReplicaSet | 全 RS 一覧（リビジョン検索） | Informer キャッシュ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Deployment | UPDATE | Pod テンプレート変更 + rollbackTo アノテーション削除 |
| Event | INSERT | Normal イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リビジョン不存在 | 指定リビジョンの RS がない | RollbackRevisionNotFound イベント発行 |
| テンプレート同一 | 現在と同じテンプレート | RollbackTemplateUnchanged イベント発行 |
| API 更新失敗 | Deployment の更新に失敗 | コントローラの requeue で再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大 15 回 |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | API 更新エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- メッセージに Deployment 名とリビジョン番号が含まれるが、秘匿情報は含まない

## 備考

- RollbackDone の定数値は "DeploymentRollback"（deployment_util.go 行 65）
- ロールバック機能は deprecated であり、apps/DeprecatedRollbackTo アノテーションを使用する
- 現在は kubectl rollout undo コマンドが推奨されるが、内部的には同じメカニズムを使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | deployment_util.go | `pkg/controller/deployment/util/deployment_util.go` | RollbackDone, RollbackRevisionNotFound, RollbackTemplateUnchanged 定数 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | deployment_controller.go | `pkg/controller/deployment/deployment_controller.go` | syncDeployment 行 660-661 でロールバック判定 |
| 2-2 | rollback.go | `pkg/controller/deployment/rollback.go` | rollback 関数（行 33-72） |

**主要処理フロー**:
1. **行 41-42**: rollbackTo リビジョンの取得（0 の場合は最後のリビジョン）
2. **行 51-68**: 全 RS をループしてリビジョン一致を検索
3. **行 62**: rollbackToTemplate の呼び出し
4. **行 63-65**: performedRollback == true かつ err == nil で emitRollbackNormalEvent

#### Step 3: ロールバック実行ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rollback.go | `pkg/controller/deployment/rollback.go` | rollbackToTemplate (行 77-103) |
| 3-2 | rollback.go | `pkg/controller/deployment/rollback.go` | emitRollbackNormalEvent (行 109-111) |

**主要処理フロー**:
- **行 80**: EqualIgnoreHash でテンプレート比較
- **行 82-94**: テンプレート変更がある場合のロールバック処理
- **行 102**: updateDeploymentAndClearRollbackTo で Deployment 更新
- **行 111**: Eventf で RollbackDone イベント発行

### プログラム呼び出し階層図

```
DeploymentController.syncDeployment (行 589)
    |
    +-- getRollbackTo (行 660)
    |
    +-- rollback (行 33)
           |
           +-- getAllReplicaSetsAndSyncRevision
           +-- getRollbackTo ... リビジョン番号取得
           +-- [リビジョン一致 RS] rollbackToTemplate (行 62)
           |      |
           |      +-- EqualIgnoreHash (行 80) ... テンプレート比較
           |      +-- SetFromReplicaSetTemplate (行 82) ... テンプレート復元
           |      +-- updateDeploymentAndClearRollbackTo (行 102)
           |
           +-- emitRollbackNormalEvent (行 64)
                  +-- eventRecorder.Eventf (行 111) ... RollbackDone 発行
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Deployment (rollbackTo) -> rollback --------------------> Event: RollbackDone (Normal)
ReplicaSet (revision) ---> rollbackToTemplate          Deployment (テンプレート復元, rollbackTo 削除)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rollback.go | `pkg/controller/deployment/rollback.go` | ソース | ロールバックロジック |
| deployment_controller.go | `pkg/controller/deployment/deployment_controller.go` | ソース | syncDeployment でのロールバック判定 |
| deployment_util.go | `pkg/controller/deployment/util/deployment_util.go` | ソース | 定数定義・テンプレート比較 |
