# 通知設計書 89-ConflictingController

## 概要

本ドキュメントは、Kubernetes StatefulSet コントローラが PersistentVolumeClaim (PVC) に競合する OwnerReference を検出した際に発行される `ConflictingController` イベント通知の設計を記載する。

### 本通知の処理概要

StatefulSet コントローラが Pod の PVC に対する保持ポリシー（Retention Policy）を更新する際に、PVC に StatefulSet 以外のコントローラとして動作する OwnerReference が存在する場合にこの通知が発行される。

**業務上の目的・背景**：StatefulSet の PVC 保持ポリシー機能では、Pod やStatefulSet の削除時に PVC の自動削除を制御するために OwnerReference を使用する。しかし、別のコントローラが既に OwnerReference を設定している場合、保持ポリシーが正しく機能しない可能性がある。この通知は運用者にこの競合状態を警告する。

**通知の送信タイミング**：UpdatePodClaimForRetentionPolicy 関数内で、PVC に hasUnexpectedController が true を返す場合（PVC に StatefulSet やその Pod 以外のコントローラ参照が存在する場合）に発行される。

**通知の受信者**：StatefulSet オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe statefulset や外部モニタリングシステムを通じて運用者が受信する。

**通知内容の概要**：競合する OwnerReference を持つ PVC の名前と、保持ポリシーが無視される旨のメッセージ。

**期待されるアクション**：運用者は該当 PVC の OwnerReference を確認し、不要なコントローラ参照を削除するか、保持ポリシーの設定を見直す。

## 通知種別

Kubernetes Event（EventType: Warning）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（Pod 更新処理内で即座に発行） |
| 優先度 | 中（Warning イベント） |
| リトライ | StatefulSet の reconcile ループで自動再試行 |

### 送信先決定ロジック

StatefulSet オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

```
PersistentVolumeClaim %s has a conflicting OwnerReference that acts as a manging controller, the retention policy is ignored for this claim
```

注: "manging" はソースコードのタイポであり、正しくは "managing"。

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| claimName | PVC 名 | getPersistentVolumeClaimName の結果 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | StatefulSet reconcile（Pod 更新） | hasUnexpectedController(claim, set, pod) == true | PVC に競合するコントローラ参照が存在 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| hasUnexpectedController == false | PVC に競合する OwnerReference がない場合 |
| PVC が存在しない | apierrors.IsNotFound の場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[UpdatePodClaimForRetentionPolicy] --> B[各 VolumeClaimTemplate をループ]
    B --> C[PVC 取得]
    C -->|NotFound| D[スキップ]
    C -->|エラー| E[エラー返却]
    C -->|成功| F{hasUnexpectedController?}
    F -->|Yes| G[ConflictingController イベント発行]
    F -->|No| H[通常の OwnerReference 更新]
    G --> I{isClaimOwnerUpToDate?}
    I -->|No| J[OwnerReference 更新]
    I -->|Yes| K[スキップ]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| StatefulSet | StatefulSet スペック取得 | コントローラ引数 |
| Pod | Pod 情報取得 | コントローラ引数 |
| PersistentVolumeClaim | PVC の OwnerReference 確認 | Lister キャッシュ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| PersistentVolumeClaim | UPDATE | OwnerReference の更新（競合があっても実行される） |
| Event | INSERT | Warning イベントの記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| PVC 取得失敗 | API エラー | エラーメッセージ付きで返却 |
| PVC 更新失敗 | API エラー | エラーメッセージ付きで返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | StatefulSet コントローラの requeue 設定に準拠 |
| リトライ間隔 | RateLimiter の設定に準拠 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- メッセージに PVC 名が含まれるが、秘匿情報は含まない

## 備考

- ConflictingController イベントが発行されても、OwnerReference の更新処理自体は続行される
- メッセージ中の "manging" はソースコード内のタイポ（正しくは "managing"）
- PVC 保持ポリシーは StatefulSetAutoDeletePVC feature gate で制御される
- hasUnexpectedController は PVC の OwnerReference に controller=true の参照が StatefulSet / Pod 以外のものを含むかチェックする

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/apps/v1/types.go` | StatefulSet, StatefulSetPersistentVolumeClaimRetentionPolicy の構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stateful_pod_control.go | `pkg/controller/statefulset/stateful_pod_control.go` | UpdatePodClaimForRetentionPolicy (行 227-255) |

**主要処理フロー**:
1. **行 229**: Pod の ordinal を取得
2. **行 230**: VolumeClaimTemplates をループ
3. **行 231**: PVC 名を生成
4. **行 232-233**: PVC を取得
5. **行 240**: hasUnexpectedController のチェック
6. **行 242-243**: ConflictingController イベント発行
7. **行 245-251**: isClaimOwnerUpToDate でない場合 OwnerReference 更新

#### Step 3: 競合判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stateful_set_utils.go | `pkg/controller/statefulset/stateful_set_utils.go` | hasUnexpectedController 関数の実装 |

### プログラム呼び出し階層図

```
StatefulPodControl.UpdatePodClaimForRetentionPolicy (行 227)
    |
    +-- getOrdinal(pod) (行 229)
    +-- getPersistentVolumeClaimName (行 231)
    +-- objectMgr.GetClaim (行 232)
    |
    +-- hasUnexpectedController(claim, set, pod) (行 240)
    |      (PVC の OwnerReference に予期しないコントローラ参照があるか)
    |
    +-- recorder.Event (行 243) ... ConflictingController 発行
    |
    +-- isClaimOwnerUpToDate(claim, set, pod) (行 245)
    +-- updateClaimOwnerRefForSetAndPod (行 247) ... OwnerReference 更新
    +-- objectMgr.UpdateClaim (行 248)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

StatefulSet Spec --------> UpdatePodClaimForRetentionPolicy -> Event: ConflictingController
Pod (ordinal) ----------->  hasUnexpectedController ------> PVC OwnerReference 更新
PVC (OwnerReference) ---->   (競合検出)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stateful_pod_control.go | `pkg/controller/statefulset/stateful_pod_control.go` | ソース | Pod/PVC 操作とイベント発行 |
| stateful_set_utils.go | `pkg/controller/statefulset/stateful_set_utils.go` | ソース | hasUnexpectedController 等のユーティリティ |
| stateful_set.go | `pkg/controller/statefulset/stateful_set.go` | ソース | StatefulSet コントローラのメインロジック |
