# 通知設計書 9-FailedKillPod

## 概要

本ドキュメントは、Kubernetesのkubeletがpodの強制終了に失敗した際に発行する「FailedKillPod」イベント通知の設計を記述する。

### 本通知の処理概要

kubeletがPodの停止処理（killPod）を実行した結果、エラーが返却された場合に、Kubernetes Event APIを用いて「FailedKillPod」イベントを記録する通知である。Pod内の一つ以上のコンテナの停止に失敗したことを示す。

**業務上の目的・背景**：Podの停止失敗は、コンテナランタイムの問題、プロセスがシグナルに応答しない、または内部的なエラーに起因する。この通知により、運用者はPodの停止処理に問題が発生していることを検知でき、ノードの状態やコンテナランタイムの健全性を調査するトリガーとなる。停止できないPodは「ゾンビPod」としてリソースを占有し続ける可能性がある。

**通知の送信タイミング**：kubelet.goの`syncTerminatingPod`関数および`SyncTerminatingRuntimePod`関数内で、killPodがエラーを返した場合に発行される（`kubelet.go` 2230行目、2330行目）。

**通知の受信者**：Kubernetes Event APIを通じて記録されるため、kubectl eventsやモニタリングツールを利用するクラスタ管理者が受信者となる。Warning Eventであるため監視アラート対象となる。

**通知内容の概要**：イベントにはEventType（Warning）、Reason（FailedKillPod）、およびエラーの詳細メッセージ"error killing pod: {エラー内容}"が含まれる。

**期待されるアクション**：運用者はノードのコンテナランタイム（containerd、CRI-O等）のログを確認し、停止失敗の原因を調査する。ノードの再起動やPodの強制削除（kubectl delete --force --grace-period=0）が必要になる場合がある。

## 通知種別

Kubernetes Eventオブジェクト（API内部通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Event APIへの書き込み） |
| 優先度 | 高（Warning Event） |
| リトライ | Event API書き込み失敗時はkubelet内部でリトライ |

### 送信先決定ロジック

停止対象のPodオブジェクトに対してrecorder.Eventfを呼び出し、Kubernetes Event APIサーバへ送信する。

## 通知テンプレート

### メール通知の場合

本通知はKubernetes Event APIオブジェクトとして発行されるため、メール通知は該当しない。

### 本文テンプレート

```
error killing pod: {エラー内容}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Pod名 | 対象Podの名前 | Pod.ObjectMeta.Name | Yes |
| Namespace | 対象PodのNamespace | Pod.ObjectMeta.Namespace | Yes |
| エラー内容 | killPodのエラーメッセージ | killPod()の戻り値err | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| kubelet内部 | syncTerminatingPod内のkillPod失敗 | killPodがnon-nilエラーを返した場合 | Pod停止処理のエラー |
| kubelet内部 | SyncTerminatingRuntimePod内のkillPod失敗 | killPodがnon-nilエラーを返した場合 | 孤児Podの停止処理のエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| killPod成功 | Podの停止が正常に完了した場合はイベント発行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncTerminatingPod / SyncTerminatingRuntimePod] --> B[Probe停止]
    B --> C[ConvertPodStatusToRunningPod]
    C --> D[killPod実行]
    D --> E{killPod成功?}
    E -->|成功| F[Probe全停止]
    E -->|失敗| G[recorder.Eventf: FailedKillPod]
    G --> H[utilruntime.HandleError]
    H --> I[エラー返却]
    F --> J[正常完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| etcd（Podオブジェクト） | Podメタデータ参照 | kube-apiserver経由 |
| kubelet内部キャッシュ | PodStatus参照 | 実行中コンテナのリスト取得 |

### テーブル別参照項目詳細

#### Podオブジェクト

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ObjectMeta.Name | イベントの対象Pod特定 | kubeletが管理するPod |
| ObjectMeta.Namespace | イベントの記録先Namespace | kubeletが管理するPod |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| etcd（Eventオブジェクト） | INSERT | FailedKillPodイベントオブジェクトの作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Reason | "FailedKillPod" | イベント理由 |
| INSERT | Event.Type | "Warning" | 警告イベント |
| INSERT | Event.Message | "error killing pod: {エラー}" | エラーメッセージ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| コンテナ停止失敗 | CRI StopContainer RPCのエラー | 次回syncPodで再試行 |
| サンドボックス停止失敗 | CRI StopPodSandbox RPCのエラー | 次回syncPodで再試行 |
| ランタイム通信失敗 | コンテナランタイムとの通信障害 | ノードのランタイム状態確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 次回のsyncPodループで自動リトライ |
| リトライ間隔 | Pod同期間隔に依存 |
| リトライ対象エラー | すべてのkillPodエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | EventRecorderのバースト制限に依存 |
| 1日あたり上限 | 明示的な上限なし（同一イベントは集約） |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- エラーメッセージにはコンテナランタイムからのエラー詳細が含まれるため、内部情報が露出する可能性がある。

## 備考

- 本イベントはkubelet.goの2箇所で発行される：`syncTerminatingPod`（2230行目）と`SyncTerminatingRuntimePod`（2330行目）。
- イベント定数は`pkg/kubelet/events/event.go` 33行目で`FailedToKillPod = "FailedKillPod"`として定義されている。
- イベント発行後、`utilruntime.HandleError(err)`でエラーハンドリングが行われ、エラーが呼び出し元に返却される。
- `SyncTerminatingRuntimePod`は孤児Pod（kubeletが管理情報を失ったPod）の停止処理であり、grace period=1秒で強制停止を試みる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | event.go | `pkg/kubelet/events/event.go` | 33行目: `FailedToKillPod = "FailedKillPod"` の定数定義 |

**読解のコツ**: FailedToKillPodはPod event reason listに含まれる（Container eventではない）。

#### Step 2: エントリーポイントを理解する（パス1: syncTerminatingPod）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 2220-2234行目: syncTerminatingPod内のkillPodエラーハンドリング |

**主要処理フロー**:
1. **2226行目**: LivenessとStartup Probeの停止
2. **2228行目**: ConvertPodStatusToRunningPodで実行中Pod情報取得
3. **2229行目**: killPod呼び出し
4. **2230行目**: 失敗時にrecorder.EventfでFailedKillPodイベント発行
5. **2232行目**: utilruntime.HandleError(err)
6. **2233行目**: エラー返却

#### Step 3: エントリーポイントを理解する（パス2: SyncTerminatingRuntimePod）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | kubelet.go | `pkg/kubelet/kubelet.go` | 2320-2334行目: SyncTerminatingRuntimePod内のkillPodエラーハンドリング |

**主要処理フロー**:
1. **2328行目**: gracePeriod=1秒（強制停止）
2. **2329行目**: killPod呼び出し
3. **2330行目**: 失敗時にrecorder.EventfでFailedKillPodイベント発行

### プログラム呼び出し階層図

```
podWorkers.managePodLoop()
    |
    +-- kubelet.syncTerminatingPod()             [kubelet.go:2220]
    |      |
    |      +-- probeManager.StopLivenessAndStartup()
    |      +-- ConvertPodStatusToRunningPod()
    |      +-- killPod()
    |      |      +-- [失敗] recorder.Eventf(FailedKillPod)  [行2230]
    |      |
    |      +-- probeManager.RemovePod()
    |
    +-- kubelet.SyncTerminatingRuntimePod()      [kubelet.go:2320]
           |
           +-- killPod(gracePeriod=1)
                  +-- [失敗] recorder.Eventf(FailedKillPod)  [行2330]
```

### データフロー図

```
[入力]                              [処理]                              [出力]

Pod停止要求        ------>  syncTerminatingPod()            ------>  Kubernetes Event
(TerminatingPod)             |                                       (Type: Warning,
                             +-- killPod()                           Reason: FailedKillPod,
                             +-- [エラー] recorder.Eventf()          Message: "error killing pod: {err}")
                             |
killPodエラー      <------  CRI StopContainer/StopPodSandbox
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| event.go | `pkg/kubelet/events/event.go` | ソース | イベント理由定数の定義 |
| kubelet.go | `pkg/kubelet/kubelet.go` | ソース | syncTerminatingPodおよびSyncTerminatingRuntimePod |
| kuberuntime_manager.go | `pkg/kubelet/kuberuntime/kuberuntime_manager.go` | ソース | KillPod関数の実装 |
| pod_workers.go | `pkg/kubelet/pod_workers.go` | ソース | Pod Workerループの管理 |
