# 通知設計書 90-SuccessfulCreate

## 概要

本ドキュメントは、Kubernetes CronJob コントローラが Job の作成に成功した際に発行される `SuccessfulCreate` イベント通知の設計を記載する。

### 本通知の処理概要

CronJob コントローラがスケジュールに基づいて新しい Job を作成し、その作成が成功した場合にこの通知が発行される。

**業務上の目的・背景**：CronJob は定期的なバッチ処理の実行基盤であり、Job の作成成功はスケジュールされたタスクが正常に開始されたことを示す。この通知により運用者は定期実行が正常に行われていることを監視・監査できる。

**通知の送信タイミング**：syncCronJob 関数内で jobControl.CreateJob が成功し（AlreadyExists でない新規作成の場合）、Job が正常に作成された直後に発行される。

**通知の受信者**：CronJob オブジェクトに関連付けられた Kubernetes Event として記録される。kubectl describe cronjob や外部モニタリングシステムを通じて運用者が受信する。

**通知内容の概要**：作成された Job 名が含まれる。フォーマット：「Created job %v」

**期待されるアクション**：通常、即座のアクションは不要。Job の実行結果はその後の SawCompletedJob イベントで確認する。

## 通知種別

Kubernetes Event（EventType: Normal）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncCronJob 内で即座に発行） |
| 優先度 | 低（Normal イベント、正常動作） |
| リトライ | なし（成功時のみ発行） |

### 送信先決定ロジック

CronJob オブジェクト自体に対する Kubernetes Event として記録される。

## 通知テンプレート

### 本文テンプレート

```
Created job %v
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| jobResp.Name | 作成された Job 名 | CreateJob の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | CronJob reconcile | jobControl.CreateJob 成功 かつ AlreadyExists でない | 新規 Job 作成成功 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Job が既に存在 (AlreadyExists) | 既存 Job の場合はイベントを発行しない |
| CronJob が Suspended | Suspend == true の場合は Job 作成自体が行われない |
| スケジュール時刻を逃した | StartingDeadlineSeconds を超過した場合 |
| ConcurrencyPolicy が Forbid で既存 Job 稼働中 | 並行実行が禁止されている場合 |
| NamespaceTerminating | Namespace が終了中の場合 |
| 既にスケジュール済み時刻 | inActiveListByName が true の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncCronJob] --> B{Suspended?}
    B -->|Yes| C[処理終了]
    B -->|No| D[スケジュール解析]
    D --> E{次回実行時刻?}
    E -->|なし| F[次回スケジュールで再キュー]
    E -->|あり| G{StartingDeadlineSeconds 超過?}
    G -->|Yes| H[MissSchedule イベント]
    G -->|No| I{ConcurrencyPolicy チェック}
    I -->|Forbid + 稼働中| J[JobAlreadyActive イベント]
    I -->|Replace| K[既存 Job 削除]
    I -->|Allow or 稼働なし| L[getJobFromTemplate2]
    K --> L
    L --> M[jobControl.CreateJob]
    M -->|成功| N[SuccessfulCreate イベント発行]
    M -->|AlreadyExists| O[既存 Job の再確認]
    M -->|NamespaceTerminating| P[エラー返却]
    M -->|その他エラー| Q[FailedCreate イベント]
    N --> R[Active リストに追加]
    R --> S[LastScheduleTime 更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CronJob | CronJob スペック・ステータス取得 | Informer キャッシュ経由 |
| Job | 既存 Job 一覧取得 | Informer キャッシュ経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Job | CREATE | 新しい Job の作成 |
| CronJob.Status | UPDATE | Active リストへの追加、LastScheduleTime 更新 |
| Event | INSERT | Normal イベントの記録 |

## エラー処理

### エラーケース一覧

該当なし（本通知は成功時にのみ発行される）

### リトライ仕様

該当なし

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetes Event レート制限に準拠 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- メッセージに Job 名が含まれるが、秘匿情報は含まない

## 備考

- Job 名は CronJob 名 + スケジュール時刻のハッシュ値から生成される（getJobName 関数）
- CronJobCreationSkew メトリクスが同時に記録される（Job 作成時刻とスケジュール時刻の差）
- AlreadyExists の場合、CronJob コントローラが所有する Job であれば Active リストに追加する処理が行われる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/batch/v1/types.go` | CronJob, CronJobSpec, CronJobStatus, Job の構造 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | sync (行 188) -> syncCronJob (行 426) |

**主要処理フロー**:
1. **行 519-526**: スケジュール解析
2. **行 528-535**: 次回実行時刻計算
3. **行 546-563**: StartingDeadlineSeconds チェック
4. **行 573-601**: ConcurrencyPolicy チェック
5. **行 604-607**: Job テンプレート生成
6. **行 609**: jobControl.CreateJob 呼び出し
7. **行 649**: SuccessfulCreate Eventf 発行
8. **行 663-670**: Active リスト更新、LastScheduleTime 更新

#### Step 3: Job 作成ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | 行 609-649 の CreateJob とエラーハンドリング |
| 3-2 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | getJobName (行 676-678) で Job 名生成 |

**主要処理フロー**:
- **行 611-614**: NamespaceTerminating エラー処理
- **行 615-637**: AlreadyExists エラー処理（既存 Job の所有権確認）
- **行 638-641**: その他のエラー処理（FailedCreate イベント）
- **行 644-649**: 新規作成成功時の処理

### プログラム呼び出し階層図

```
ControllerV2.sync (行 188)
    |
    +-- cronJobLister.CronJobs().Get (行 194) ... CronJob 取得
    +-- getJobsToBeReconciled (行 205) ... 関連 Job 一覧取得
    +-- cleanupFinishedJobs (行 214) ... 完了 Job クリーンアップ
    +-- syncCronJob (行 216)
           |
           +-- parsers.ParseCronScheduleWithPanicRecovery (行 519) ... スケジュール解析
           +-- nextScheduleTime (行 528) ... 次回実行時刻計算
           +-- getJobFromTemplate2 (行 604) ... Job テンプレート生成
           +-- jobControl.CreateJob (行 609)
           |      |
           |      +-- [成功] recorder.Eventf (行 649) ... SuccessfulCreate 発行
           |      +-- [AlreadyExists] 既存 Job 確認 (行 621)
           |      +-- [エラー] recorder.Eventf (行 640) ... FailedCreate 発行
           |
           +-- getRef (行 663) ... ObjectReference 生成
           +-- cronJob.Status.Active に追加 (行 668)
           +-- cronJob.Status.LastScheduleTime 更新 (行 669)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CronJob Spec ------------> syncCronJob -----------------> Event: SuccessfulCreate (Normal)
  .Schedule             -> スケジュール解析                Job (新規作成)
  .JobTemplate          -> getJobFromTemplate2            CronJob Status (Active, LastScheduleTime)
  .ConcurrencyPolicy    -> CreateJob                      CronJobCreationSkew メトリクス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | CronJob コントローラ V2 のメインロジック |
| cronjob_utils.go | `pkg/controller/cronjob/utils.go` | ソース | ユーティリティ関数 |
| cronjob_job_control.go | `pkg/controller/cronjob/cronjob_job_control.go` | ソース | Job 作成・削除インターフェース |
| metrics.go | `pkg/controller/cronjob/metrics/metrics.go` | ソース | CronJob メトリクス |
