# 通知設計書 92-SuccessfulDelete

## 概要

本ドキュメントは、CronJobコントローラが古いJobの削除に成功した際に発行されるKubernetesイベント通知「SuccessfulDelete」の設計を記述する。

### 本通知の処理概要

CronJobコントローラが管理するJobを正常に削除した際にNormalイベントとして発行される通知である。Jobの削除は、履歴保持上限を超えた古いJobのクリーンアップ時、またはConcurrencyPolicy=Replaceで新しいJobを作成する際に既存のアクティブJobを削除する時に発生する。

**業務上の目的・背景**：CronJobは定期的にJobを作成するため、完了済みや失敗したJobが蓄積する。SuccessfulJobsHistoryLimitやFailedJobsHistoryLimitの設定に基づいて古いJobを自動的に削除し、クラスタリソースを適切に管理する必要がある。本通知はJob削除が正常に完了したことを記録し、運用監視の一助とする。

**通知の送信タイミング**：`deleteJob`関数内で`jobControl.DeleteJob`が成功した直後に発行される。具体的には、(1) `cleanupFinishedJobs`によるHistoryLimit超過時のJob削除、(2) `syncCronJob`内のConcurrencyPolicy=Replace時のアクティブJob削除の2パターンがある。

**通知の受信者**：Kubernetesイベントとして該当CronJobオブジェクトに記録される。`kubectl get events`や`kubectl describe cronjob`で確認可能である。

**通知内容の概要**：EventTypeはNormal、Reasonは「SuccessfulDelete」、メッセージには削除されたJob名が含まれる。フォーマットは「Deleted job {Job名}」である。

**期待されるアクション**：通常は情報提供目的であり、特別なアクションは必要ない。CronJobの履歴管理が正常に動作していることの確認に利用できる。

## 通知種別

Kubernetesイベント（Event API リソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（deleteJob処理内で即座に発行） |
| 優先度 | 低（正常動作の記録） |
| リトライ | N/A（削除成功時のみ発行されるため） |

### 送信先決定ロジック

CronJobコントローラの`recorder.Eventf`メソッドにより、対象のCronJobオブジェクトに対してイベントが記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetesイベントであり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetesイベント） |
| 送信元名称 | cronjob-controller |
| 件名 | N/A |
| 形式 | Kubernetesイベントリソース |

### 本文テンプレート

```
Deleted job %v
```

変数`%v`には削除されたJobのName（`job.Name`）が挿入される。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| job.Name | 削除されたJob名 | batchv1.Job.Name | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | HistoryLimit超過によるクリーンアップ | jobControl.DeleteJobが成功した場合 | cleanupFinishedJobs -> removeOldestJobs -> deleteJob |
| コントローラ同期 | ConcurrencyPolicy=Replaceでの既存Job置換 | jobControl.DeleteJobが成功した場合 | syncCronJob -> deleteJob |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 削除失敗 | jobControl.DeleteJobがエラーを返した場合はFailedDeleteが代わりに発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[CronJob同期処理] --> B{トリガー判定}
    B -->|HistoryLimit超過| C[cleanupFinishedJobs]
    B -->|Replace Policy| D[syncCronJob Replace処理]
    C --> E[removeOldestJobs]
    E --> F[deleteJob]
    D --> F
    F --> G[jobControl.DeleteJob]
    G --> H{削除結果}
    H -->|成功| I[SuccessfulDeleteイベント発行]
    H -->|失敗| J[FailedDeleteイベント発行]
    I --> K[ActiveListから削除]
    K --> L[終了]
    J --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CronJob | HistoryLimit設定、ConcurrencyPolicy取得 | API Server経由 |
| Job | 削除対象Job特定 | Informerキャッシュ経由 |

### テーブル別参照項目詳細

#### CronJob

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.SuccessfulJobsHistoryLimit | 成功Job保持数 | cronJobLister経由 |
| Spec.FailedJobsHistoryLimit | 失敗Job保持数 | cronJobLister経由 |
| Spec.ConcurrencyPolicy | 並行実行ポリシー | cronJobLister経由 |
| Status.Active | アクティブJob一覧 | cronJobLister経由 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Job | DELETE | 対象Jobの削除（BackgroundPropagation） |
| Event | INSERT | SuccessfulDeleteイベント作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Type | Normal | イベント種別 |
| INSERT | Event.Reason | SuccessfulDelete | イベント理由 |
| INSERT | Event.Message | Deleted job {job.Name} | 削除されたJob名 |
| INSERT | Event.Source.Component | cronjob-controller | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 削除失敗 | API Serverへの削除リクエストが失敗 | FailedDeleteイベントが代わりに発行される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（本イベント自体はリトライ不要） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetesイベントのデフォルト集約ルールに従う |
| 1日あたり上限 | 特に制限なし |

### 配信時間帯

制限なし。CronJobのスケジュールおよびクリーンアップタイミングに応じて発行される。

## セキュリティ考慮事項

削除されたJob名がメッセージに含まれるが、Kubernetesイベントへのアクセスは通常RBACで制御されている。

## 備考

- Job削除はBackgroundPropagation（`metav1.DeletePropagationBackground`）で実行される（injection.go 行108）
- deleteJob関数はActiveListからのUID削除も同時に行う（行756）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/batch/v1/types.go` | CronJob.Spec.SuccessfulJobsHistoryLimit、FailedJobsHistoryLimit、ConcurrencyPolicyを理解する |

**読解のコツ**: HistoryLimitはポインタ型（*int32）であり、nilの場合はクリーンアップが無効となる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | sync関数（行188-235）からcleanupFinishedJobsとsyncCronJobが呼ばれる流れ |

**主要処理フロー**:
1. **行214**: cleanupFinishedJobs呼出
2. **行216**: syncCronJob呼出

#### Step 3: クリーンアップ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | cleanupFinishedJobs（行682-716）、removeOldestJobs（行728-745）、deleteJob（行748-760）の処理チェーン |

**主要処理フロー**:
- **行682-716**: cleanupFinishedJobsで完了Job/失敗Jobを分類
- **行728-745**: removeOldestJobsで古い順にソートして超過分を削除
- **行748-760**: deleteJobでAPI Server削除 -> SuccessfulDeleteイベント発行（行757）

#### Step 4: Replace処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | syncCronJob内のReplaceConcurrent処理（行588-601）でdeleteJobが呼ばれるパス |

### プログラム呼び出し階層図

```
ControllerV2.sync (行188)
    |
    +-- cleanupFinishedJobs (行214, 682)
    |    |
    |    +-- removeOldestJobs (行702-713, 728)
    |         |
    |         +-- deleteJob (行740, 748) ★本通知の発行箇所
    |              |
    |              +-- jobControl.DeleteJob (行750)
    |              +-- deleteFromActiveList (行756)
    |              +-- recorder.Eventf "SuccessfulDelete" (行757)
    |
    +-- syncCronJob (行216, 426)
         |
         +-- [ConcurrencyPolicy=Replace] (行588)
              |
              +-- deleteJob (行596, 748) ★本通知の発行箇所
```

### データフロー図

```
[入力]                         [処理]                         [出力]

CronJob Spec              --> cleanupFinishedJobs         --> SuccessfulDelete Event
  .SuccessfulJobsHistoryLimit   |                              (Normal)
  .FailedJobsHistoryLimit       +-- removeOldestJobs
  .ConcurrencyPolicy            +-- deleteJob
Job Status                      +-- jobControl.DeleteJob
  .Conditions                   +-- recorder.Eventf
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | deleteJob関数（行748-760）でSuccessfulDeleteイベント発行 |
| injection.go | `pkg/controller/cronjob/injection.go` | ソース | realJobControl.DeleteJob（行107-110）でAPI Serverに削除リクエスト |
| utils.go | `pkg/controller/cronjob/utils.go` | ソース | byJobStartTimeソート、deleteFromActiveList等のユーティリティ |
