# 通知設計書 93-FailedDelete

## 概要

本ドキュメントは、CronJobコントローラが古いJobの削除に失敗した際に発行されるKubernetesイベント通知「FailedDelete」の設計を記述する。

### 本通知の処理概要

CronJobコントローラが管理するJobを削除しようとした際に、API Serverへの削除リクエストが失敗した場合にWarningイベントとして発行される通知である。

**業務上の目的・背景**：CronJobコントローラは履歴保持上限（HistoryLimit）に基づく古いJobの削除や、ConcurrencyPolicy=ReplaceによるアクティブJobの置換を行う。削除に失敗した場合、Jobリソースが蓄積してクラスタリソースを圧迫する可能性があるため、この通知により運用者に問題を通知し早期対処を促す。

**通知の送信タイミング**：`deleteJob`関数内で`jobControl.DeleteJob`がエラーを返した直後に発行される。

**通知の受信者**：Kubernetesイベントとして該当CronJobオブジェクトに記録される。

**通知内容の概要**：EventTypeはWarning、Reasonは「FailedDelete」、メッセージには削除時のエラー内容が含まれる。フォーマットは「Deleted job: {エラー内容}」である（注：メッセージテンプレートが"Deleted job: %v"となっているが、引数はerrであるため実際にはエラーメッセージが挿入される）。

**期待されるアクション**：受信者はエラー内容を確認し、Job削除が失敗した原因を特定して対処する。一般的にはAPI Serverの一時的な障害やRBAC権限の問題が考えられる。

## 通知種別

Kubernetesイベント（Event API リソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（deleteJob処理内で即座に発行） |
| 優先度 | 中（Job蓄積によるリソース圧迫の可能性） |
| リトライ | 次回の同期サイクルで再度削除が試みられる |

### 送信先決定ロジック

CronJobコントローラの`recorder.Eventf`メソッドにより、対象のCronJobオブジェクトに対してイベントが記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetesイベントであり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetesイベント） |
| 送信元名称 | cronjob-controller |
| 件名 | N/A |
| 形式 | Kubernetesイベントリソース |

### 本文テンプレート

```
Deleted job: %v
```

変数`%v`にはJob削除時に返されたエラーオブジェクトの文字列表現が挿入される。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| err | Job削除時のエラー内容 | jobControl.DeleteJob戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | HistoryLimit超過によるクリーンアップ | jobControl.DeleteJobがエラーを返した場合 | cleanupFinishedJobs -> removeOldestJobs -> deleteJob |
| コントローラ同期 | ConcurrencyPolicy=Replaceでの既存Job置換 | jobControl.DeleteJobがエラーを返した場合 | syncCronJob -> deleteJob |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 削除成功 | 削除が成功した場合はSuccessfulDeleteが代わりに発行される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Job削除処理開始] --> B[jobControl.DeleteJob]
    B --> C{削除結果}
    C -->|成功| D[SuccessfulDeleteイベント発行]
    C -->|失敗| E[FailedDeleteイベント発行]
    E --> F[エラーログ出力]
    F --> G[false返却]
    D --> H[ActiveListから削除]
    H --> I[true返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| Job | 削除対象のJob情報 | API Server経由 |

### テーブル別参照項目詳細

#### Job

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Namespace | 削除先Namespace | deleteJob関数の引数 |
| Name | 削除対象Job名 | deleteJob関数の引数 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | FailedDeleteイベント作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Type | Warning | イベント種別 |
| INSERT | Event.Reason | FailedDelete | イベント理由 |
| INSERT | Event.Message | Deleted job: {err} | エラーメッセージ |
| INSERT | Event.Source.Component | cronjob-controller | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| API Serverエラー | API Serverへの削除リクエスト失敗 | 次回同期で再試行 |
| 権限不足 | CronJobコントローラにJob削除権限がない | RBAC設定を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 次回CronJob同期サイクルで再度削除を試行 |
| リトライ間隔 | CronJobの次回スケジュール時刻またはワークキューのリキュー間隔 |
| リトライ対象エラー | jobControl.DeleteJobが返すすべてのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetesイベントのデフォルト集約ルールに従う |
| 1日あたり上限 | 特に制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

エラーメッセージにはAPI Serverからのエラー詳細が含まれる可能性がある。Kubernetesイベントへのアクセスは通常RBACで制御されている。

## 備考

- ソースコード上のメッセージテンプレートは「Deleted job: %v」であり、引数がerrであるため、実際の出力は「Deleted job: {エラー内容}」となる。メッセージの文言がSuccessfulDeleteと紛らわしいが、EventTypeがWarningであり区別可能。
- deleteJob関数が失敗を返した場合、ActiveListからのJob参照削除は行われない（行756は実行されない）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | injection.go | `pkg/controller/cronjob/injection.go` | jobControlInterfaceのDeleteJobメソッド定義（行88）と実装（行107-110）を理解する |

**読解のコツ**: DeleteJobはDeletePropagationBackgroundを使用しており、関連Podも連鎖的に削除される。

#### Step 2: deleteJob関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | deleteJob関数（行748-760）の全体フローを理解する。特に行750-753がFailedDeleteの発行箇所 |

**主要処理フロー**:
1. **行750**: jobControl.DeleteJob呼出
2. **行751**: 失敗時にFailedDeleteイベント発行（recorder.Eventf）
3. **行752**: エラーログ出力
4. **行753**: false返却（削除失敗を呼出元に通知）

#### Step 3: 呼出元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | removeOldestJobs（行740）とsyncCronJobのReplace処理（行596）からdeleteJobが呼ばれるパスを理解する |

### プログラム呼び出し階層図

```
ControllerV2.sync (行188)
    |
    +-- cleanupFinishedJobs (行214, 682)
    |    |
    |    +-- removeOldestJobs (行702-713, 728)
    |         |
    |         +-- deleteJob (行740, 748)
    |              |
    |              +-- jobControl.DeleteJob (行750) -- 失敗時
    |              +-- recorder.Eventf "FailedDelete" (行751) ★本通知
    |
    +-- syncCronJob (行216, 426)
         |
         +-- [ConcurrencyPolicy=Replace] (行588)
              |
              +-- deleteJob (行596, 748)
                   |
                   +-- jobControl.DeleteJob (行750) -- 失敗時
                   +-- recorder.Eventf "FailedDelete" (行751) ★本通知
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Job (削除対象)       --> deleteJob                    --> FailedDelete Event
CronJob (親)              |                               (Warning)
                          +-- jobControl.DeleteJob
                          +-- recorder.Eventf
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | deleteJob関数（行748-760）でFailedDeleteイベント発行 |
| injection.go | `pkg/controller/cronjob/injection.go` | ソース | realJobControl.DeleteJob（行107-110） |
