# 通知設計書 94-SawCompletedJob

## 概要

本ドキュメントは、CronJobコントローラが完了済みJobを検出した際に発行されるKubernetesイベント通知「SawCompletedJob」の設計を記述する。

### 本通知の処理概要

CronJobコントローラの同期処理中に、管理対象のJobが完了（Complete/Failed）状態であることを検出し、そのJobをActiveListから除外した際にNormalイベントとして発行される通知である。

**業務上の目的・背景**：CronJobはスケジュールに従ってJobを作成し、それらをActiveListで管理する。Jobが完了した場合、ActiveListから除外してCronJobのステータスを更新する必要がある。本通知はJobの完了がCronJobコントローラによって正しく認識されたことを記録し、CronJobのライフサイクル管理の可視化を提供する。

**通知の送信タイミング**：`syncCronJob`メソッドの冒頭で、管理対象のJob一覧を走査し、ActiveListに存在するJobがComplete/Failed条件を持つ場合に発行される（行452-458）。

**通知の受信者**：Kubernetesイベントとして該当CronJobオブジェクトに記録される。`kubectl get events`や`kubectl describe cronjob`で確認可能である。

**通知内容の概要**：EventTypeはNormal、Reasonは「SawCompletedJob」、メッセージには完了したJob名とその完了条件（Complete/Failed）が含まれる。フォーマットは「Saw completed job: {Job名}, condition: {完了条件}」である。

**期待されるアクション**：通常は情報提供目的であり、特別なアクションは不要。CronJobのJobが正常に完了していることの確認、またはFailed条件の場合は失敗原因の調査に活用できる。

## 通知種別

Kubernetesイベント（Event API リソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncCronJob処理内で即座に発行） |
| 優先度 | 低（正常動作の記録） |
| リトライ | N/A（情報通知のため） |

### 送信先決定ロジック

CronJobコントローラの`recorder.Eventf`メソッドにより、対象のCronJobオブジェクトに対してイベントが記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetesイベントであり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetesイベント） |
| 送信元名称 | cronjob-controller |
| 件名 | N/A |
| 形式 | Kubernetesイベントリソース |

### 本文テンプレート

```
Saw completed job: %s, condition: %v
```

第1変数`%s`にはJob名（`j.Name`）、第2変数`%v`には完了条件（`jobutil.FinishedCondition`の結果）が挿入される。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| j.Name | 完了したJob名 | batchv1.Job.Name | Yes |
| condition | 完了条件（Complete/Failed） | jobutil.FinishedCondition(j) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | CronJob同期処理 | ActiveListに存在するJobがIsJobFinished=trueの場合 | syncCronJob内のJob状態チェック |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ActiveListに存在しない完了Job | ActiveListに含まれていないJobは、完了していてもこのイベントは発行されない（LastSuccessfulTimeの更新のみ行われる） |
| まだ完了していないJob | IsJobFinished(j)がfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncCronJob開始] --> B[管理対象Job一覧走査]
    B --> C{各Jobの状態チェック}
    C -->|ActiveListに存在 & 完了済み| D[FinishedCondition取得]
    D --> E[ActiveListから削除]
    E --> F[SawCompletedJobイベント発行]
    F --> G[LastSuccessfulTime更新判定]
    C -->|ActiveListに不在 & 未完了| H[UnexpectedJobイベント発行]
    C -->|ActiveListに不在 & 完了済み| I[LastSuccessfulTime更新のみ]
    C -->|ActiveListに存在 & 未完了| J[スキップ]
    G --> K[次のJobへ]
    I --> K
    J --> K
    H --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CronJob | ActiveList参照 | API Server / Informerキャッシュ経由 |
| Job | 完了状態確認 | Informerキャッシュ経由 |

### テーブル別参照項目詳細

#### Job

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ObjectMeta.UID | ActiveList照合 | OwnerReferenceがCronJobを指すJob |
| ObjectMeta.Name | イベントメッセージ用 | 同上 |
| Status.Conditions | 完了状態判定 | JobComplete/JobFailed条件 |
| Status.CompletionTime | LastSuccessfulTime更新用 | 成功Jobの完了時刻 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| CronJob | UPDATE | Status.Active（ActiveListから削除）、Status.LastSuccessfulTime更新 |
| Event | INSERT | SawCompletedJobイベント作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Type | Normal | イベント種別 |
| INSERT | Event.Reason | SawCompletedJob | イベント理由 |
| INSERT | Event.Message | Saw completed job: {j.Name}, condition: {condition} | 完了Job情報 |
| INSERT | Event.Source.Component | cronjob-controller | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | 本イベントの発行自体ではエラーは発生しない | N/A |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetesイベントのデフォルト集約ルールに従う |
| 1日あたり上限 | 特に制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

Job名と完了条件がメッセージに含まれるが、機密情報は含まれない。

## 備考

- `jobutil.FinishedCondition`は`pkg/controller/job/util`パッケージの関数であり、JobのStatus.Conditionsから完了条件を抽出する
- `jobutil.IsJobFinished`でJobがComplete/Failedのいずれかの条件を持つかを判定する
- `jobutil.IsJobSucceeded`でJobが成功完了したかを判定し、LastSuccessfulTimeの更新に使用する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/batch/v1/types.go` | Job.Status.Conditions（JobCondition型）のType（JobComplete/JobFailed）を理解する |
| 1-2 | utils.go | `pkg/controller/cronjob/utils.go` | inActiveList関数（行59-66）とdeleteFromActiveList関数（行79-92）を理解する |

**読解のコツ**: JobConditionのTypeがJobCompleteまたはJobFailedで、StatusがConditionTrueの場合に「完了」と判定される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | syncCronJob関数（行426-674）の冒頭部分（行434-472）でJob状態チェックが行われる |

**主要処理フロー**:
1. **行434-436**: childrenJobsマップの構築
2. **行437**: inActiveList関数でActiveList存在チェック
3. **行438**: IsJobFinished関数で完了状態チェック
4. **行452-458**: ActiveListに存在し完了済みの場合 - SawCompletedJobイベント発行
5. **行454**: FinishedCondition関数で完了条件取得
6. **行455**: deleteFromActiveList関数でActiveListから除外
7. **行456**: recorder.Eventf でSawCompletedJobイベント発行

#### Step 3: Job完了判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | util.go | `pkg/controller/job/util/util.go` | IsJobFinished、IsJobSucceeded、FinishedCondition関数の実装を理解する |

### プログラム呼び出し階層図

```
ControllerV2.syncCronJob (行426)
    |
    +-- [Job一覧走査] (行435-472)
         |
         +-- inActiveList (行437)
         +-- jobutil.IsJobFinished (行438, 452)
         |
         +-- [ActiveListに存在 & 完了済み] (行452)
         |    |
         |    +-- jobutil.FinishedCondition (行454)
         |    +-- deleteFromActiveList (行455)
         |    +-- recorder.Eventf "SawCompletedJob" (行456) ★本通知
         |    +-- jobutil.IsJobSucceeded (行459)
         |         +-- LastSuccessfulTime更新 (行461-468)
         |
         +-- [ActiveListに不在 & 未完了] (行438-447)
              +-- recorder.Eventf "UnexpectedJob" (行447)
```

### データフロー図

```
[入力]                         [処理]                         [出力]

Job.Status.Conditions    --> syncCronJob                  --> SawCompletedJob Event
  (Complete/Failed)           |                                (Normal)
CronJob.Status.Active         +-- inActiveList
  (ActiveList)                +-- IsJobFinished
Job.ObjectMeta.UID            +-- FinishedCondition
                              +-- deleteFromActiveList
                              +-- recorder.Eventf
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | syncCronJob内でSawCompletedJobイベント発行（行456） |
| utils.go | `pkg/controller/cronjob/utils.go` | ソース | inActiveList、deleteFromActiveList関数 |
| util.go | `pkg/controller/job/util/util.go` | ソース | IsJobFinished、IsJobSucceeded、FinishedCondition関数 |
