# 通知設計書 97-MissSchedule

## 概要

本ドキュメントは、CronJobのスケジュール実行が開始期限を超過して遅延した際に発行されるKubernetesイベント通知「MissSchedule」の設計を記述する。

### 本通知の処理概要

CronJobのスケジュール時刻が到来したが、StartingDeadlineSecondsで指定された期限内にJob作成が開始されなかった場合にWarningイベントとして発行される通知である。

**業務上の目的・背景**：CronJobは定期的にJobを作成するが、コントローラの負荷やクラスタの障害により、スケジュール時刻通りにJobを作成できない場合がある。StartingDeadlineSecondsが設定されている場合、期限を超過したスケジュールはスキップされる。本通知はスケジュールミスが発生したことを運用者に通知し、CronJobの実行信頼性の監視を可能にする。

**通知の送信タイミング**：`syncCronJob`メソッド内で、スケジュール時刻にStartingDeadlineSecondsを加算した時刻が現在時刻より前（tooLate=true）の場合に発行される（行552）。

**通知の受信者**：Kubernetesイベントとして該当CronJobオブジェクトに記録される。

**通知内容の概要**：EventTypeはWarning、Reasonは「MissSchedule」、メッセージにはミスしたスケジュール時刻が含まれる。フォーマットは「Missed scheduled time to start a job: {スケジュール時刻（RFC1123Z形式）}」である。

**期待されるアクション**：受信者はスケジュールミスの原因を調査する。StartingDeadlineSecondsの値が短すぎる場合は拡大を検討し、コントローラの負荷が原因の場合はコントローラのリソース増強を検討する。

## 通知種別

Kubernetesイベント（Event API リソース）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（syncCronJob処理内で即座に発行） |
| 優先度 | 高（スケジュールされたJobが実行されない） |
| リトライ | N/A（次回スケジュール時刻にリキューされる） |

### 送信先決定ロジック

CronJobコントローラの`recorder.Eventf`メソッドにより、対象のCronJobオブジェクトに対してイベントが記録される。

## 通知テンプレート

### メール通知の場合

本通知はKubernetesイベントであり、メール送信は行わない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A（Kubernetesイベント） |
| 送信元名称 | cronjob-controller |
| 件名 | N/A |
| 形式 | Kubernetesイベントリソース |

### 本文テンプレート

```
Missed scheduled time to start a job: %s
```

変数`%s`にはスケジュール時刻のUTC表記（`scheduledTime.UTC().Format(time.RFC1123Z)`）が挿入される。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| scheduledTime | ミスしたスケジュール時刻 | nextScheduleTime関数の戻り値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コントローラ同期 | CronJob同期処理 | scheduledTime + StartingDeadlineSeconds < now（tooLate=true）の場合 | syncCronJob内のデッドライン判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| StartingDeadlineSecondsが未設定 | Spec.StartingDeadlineSecondsがnilの場合、tooLate判定は行われずMissScheduleは発行されない |
| デッドライン内 | scheduledTime + StartingDeadlineSeconds >= nowの場合は通常のJob作成処理に進む |
| CronJobがSuspend中 | Suspend=trueの場合はスケジュール判定に到達しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[syncCronJob スケジュール判定] --> B[nextScheduleTime計算]
    B --> C{scheduledTimeが存在?}
    C -->|存在しない| D[次回スケジュールにリキュー]
    C -->|存在する| E{StartingDeadlineSeconds設定?}
    E -->|未設定| F[デッドライン判定スキップ]
    E -->|設定済み| G{tooLate判定}
    G -->|期限内| F
    F --> H[Job作成処理へ]
    G -->|期限超過| I[MissScheduleイベント発行]
    I --> J[次回スケジュールにリキュー]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CronJob | スケジュール情報、StartingDeadlineSeconds取得 | Informerキャッシュ経由 |

### テーブル別参照項目詳細

#### CronJob

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| Spec.Schedule | スケジュール時刻計算 | syncCronJob内 |
| Spec.StartingDeadlineSeconds | デッドライン判定 | syncCronJob内 |
| Spec.TimeZone | タイムゾーン考慮 | syncCronJob内 |
| Status.LastScheduleTime | 最終スケジュール時刻 | mostRecentScheduleTime内 |
| ObjectMeta.CreationTimestamp | CronJob作成時刻 | mostRecentScheduleTime内 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| Event | INSERT | MissScheduleイベント作成 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event.Type | Warning | イベント種別 |
| INSERT | Event.Reason | MissSchedule | イベント理由 |
| INSERT | Event.Message | Missed scheduled time to start a job: {scheduledTime} | ミス時刻 |
| INSERT | Event.Source.Component | cronjob-controller | 発行元コンポーネント |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| N/A | MissScheduleイベント発行自体はエラーを生じない | N/A |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（ミスしたスケジュールはリトライされない） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Kubernetesイベントのデフォルト集約ルールに従う |
| 1日あたり上限 | 特に制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

スケジュール時刻がメッセージに含まれるが、機密情報は含まれない。

## 備考

- ソースコードのコメント（行554-563）によると、LastScheduleTimeが更新されないため、次の同期サイクルでも同じミスを検出し続ける可能性がある。Status.LastMissedTimeフィールドの追加が提案されているが、未実装。
- MissSchedule後も次回スケジュール時刻にリキューされるため（行561-562）、次のスケジュールは通常通り実行される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/batch/v1/types.go` | CronJob.Spec.StartingDeadlineSeconds（*int64型）の意味を理解する |

**読解のコツ**: StartingDeadlineSecondsはポインタ型であり、nilの場合はデッドライン判定が無効となる。

#### Step 2: スケジュール計算を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | utils.go | `pkg/controller/cronjob/utils.go` | nextScheduleTime関数（行210-223）とmostRecentScheduleTime関数（行100-181）でスケジュール時刻がどのように計算されるかを理解する |

**主要処理フロー**:
- **行100-113**: earliestTime計算（LastScheduleTimeまたはCreationTimestamp）
- **行106-113**: StartingDeadlineSecondsによるearliestTimeの調整
- **行115-123**: 次回/次々回スケジュール時刻の計算
- **行169-175**: missedSchedulesTypeの判定（none/few/many）

#### Step 3: MissSchedule判定ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | syncCronJob内のデッドライン判定（行546-563）を理解する |

**主要処理フロー**:
1. **行546**: tooLate変数の初期化（false）
2. **行547-549**: StartingDeadlineSeconds設定時、scheduledTime + deadline < now かチェック
3. **行550**: tooLateがtrueの場合
4. **行552**: recorder.Eventf "MissSchedule" 発行
5. **行561-562**: nextScheduleTimeDurationで次回リキュー時刻を計算

### プログラム呼び出し階層図

```
ControllerV2.syncCronJob (行426)
    |
    +-- parsers.ParseCronScheduleWithPanicRecovery (行519)
    +-- nextScheduleTime (行528)
    |    |
    |    +-- mostRecentScheduleTime (行211)
    |
    +-- [デッドライン判定] (行546-563)
         |
         +-- scheduledTime + StartingDeadlineSeconds < now ?
         |
         +-- [tooLate=true]
              |
              +-- recorder.Eventf "MissSchedule" (行552) ★本通知
              +-- nextScheduleTimeDuration (行561)
```

### データフロー図

```
[入力]                              [処理]                         [出力]

CronJob.Spec.Schedule         --> syncCronJob                  --> MissSchedule Event
CronJob.Spec.StartingDeadline      |                               (Warning)
CronJob.Spec.TimeZone              +-- nextScheduleTime
CronJob.Status.LastScheduleTime    +-- mostRecentScheduleTime
now (現在時刻)                      +-- tooLate判定
                                   +-- recorder.Eventf
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cronjob_controllerv2.go | `pkg/controller/cronjob/cronjob_controllerv2.go` | ソース | MissScheduleイベント発行（行552）、デッドライン判定（行546-563） |
| utils.go | `pkg/controller/cronjob/utils.go` | ソース | nextScheduleTime（行210-223）、mostRecentScheduleTime（行100-181）、nextScheduleTimeDuration（行188-205） |
| parsers.go | `pkg/util/parsers/parsers.go` | ソース | Cronスケジュール解析 |
