---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：1-Created

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **EventRecorderのリトライ仕様詳細**：EventRecorder内部のリトライメカニズムの具体的なパラメータは未確認
  2. **レート制限のデフォルト値**：EventRecorderのQPS制限のデフォルト値は推定
  3. **ObjectReference生成失敗時の挙動**：エラーログ出力後のスキップは確認済みだが網羅性は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/kubelet/events/event.go` 21行目 - CreatedContainer定数定義
- E-02: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 288行目 - Createdイベント発行箇所
- E-03: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 84-102行目 - recordContainerEvent関数
- E-04: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 199行目 - startContainer関数定義
- E-05: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 276行目 - CRI CreateContainer RPC呼び出し
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 2行目 - 通知No.1の定義
- E-07: `pkg/kubelet/kuberuntime/kuberuntime_container.go` 98-100行目 - containerID置換処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベント定数は"Created"として定義されている | E-01 | ○ |
| C-02 | startContainer関数内でCreatedイベントが発行される | E-02, E-04 | ○ |
| C-03 | EventTypeはNormalである | E-02 | ○ |
| C-04 | メッセージは"Container created"である | E-02 | ○ |
| C-05 | CRI CreateContainer RPC成功後に発行される | E-02, E-05 | ○ |
| C-06 | recordContainerEvent関数でイベント記録される | E-03 | ○ |
| C-07 | containerIDがコンテナ名に置換される | E-07 | ○ |
| C-08 | ObjectReference生成失敗時はイベントスキップ | E-03 | ○ |
| C-09 | 発行元はkubelet | E-06 | ○ |
| C-10 | PreStartContainerフック後に発行される | E-02, E-04 | ○ |
| C-11 | 送信方式は非同期（Event APIへの書き込み） | E-03 | ○ |
| C-12 | EventRecorderのリトライ仕様の具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- EventRecorder内部のリトライ仕様（リトライ回数、間隔、キューサイズ）の具体値はkubelet本体のコードではなくclient-goのevent recorder実装に依存する
  - 候補：`staging/src/k8s.io/client-go/tools/record/event.go` / `staging/src/k8s.io/client-go/tools/record/events_cache.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - イベント発行の基本構造は明確にコードで確認済み
- 1: 中リスク - EventRecorderの内部バッファリング・リトライの詳細仕様は推定値を含む

## 6) レビュアーチェックリスト（最小）
- [ ] startContainer関数内のCreatedイベント発行箇所（288行目）を確認
- [ ] recordContainerEvent関数のcontainerID置換ロジックが意図通りか確認
- [ ] EventRecorderのリトライ仕様がclient-goの実装と整合するか確認
