---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：101-TooManyMissedTimes

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/cronjob/utils.go` 38-43行目（missedSchedulesType定義）
- E-02: `pkg/controller/cronjob/utils.go` 100-181行目（mostRecentScheduleTime関数）
- E-03: `pkg/controller/cronjob/utils.go` 210-223行目（nextScheduleTime関数）
- E-04: `pkg/controller/cronjob/utils.go` 170行目（閾値100のハードコード）
- E-05: `pkg/controller/cronjob/utils.go` 218行目（Eventf呼び出し）
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` 97行目（EventSource "cronjob-controller"）
- E-07: `pkg/controller/cronjob/cronjob_controllerv2.go` 528行目（nextScheduleTime呼び出し）
- E-08: `pkg/controller/cronjob/cronjob_controllerv2.go` 514行目（suspend判定）
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 102行目（通知定義）
- E-10: `pkg/controller/cronjob/utils.go` 136行目（numberOfMissedSchedules計算）
- E-11: `pkg/controller/cronjob/utils.go` 152-165行目（コメント：80以上のジョブミスの説明）
- E-12: `pkg/controller/cronjob/cronjob_controllerv2.go` 188-234行目（sync関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 未実行スケジュール数が100を超えた場合にイベント発行 | E-04, E-05 | ○ |
| C-02 | EventTypeはWarning | E-05 | ○ |
| C-03 | Reasonは"TooManyMissedTimes" | E-05 | ○ |
| C-04 | 発行元コンポーネントは"cronjob-controller" | E-06 | ○ |
| C-05 | メッセージは固定文言 | E-05 | ○ |
| C-06 | missedSchedulesTypeにnoneMissed/fewMissed/manyMissedがある | E-01 | ○ |
| C-07 | numberOfMissedSchedulesはtimeElapsed/timeBetweenTwoSchedules+1で計算 | E-10 | ○ |
| C-08 | 100回の閾値はハードコード | E-04 | ○ |
| C-09 | syncCronJobからnextScheduleTimeが呼ばれる | E-07 | ○ |
| C-10 | suspend=trueの場合はsyncCronJobがスキップされる | E-08 | ○ |
| C-11 | startingDeadlineSecondsで計算対象期間を制限できる | E-02 | ○ |
| C-12 | コントローラー長時間停止で80回以上のミスが発生しうる | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] utils.go 170行目の閾値100が現在のコードと一致するか確認
- [ ] nextScheduleTime関数のイベント発行メッセージが最新コードと一致するか確認
