---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：102-JobAlreadyActive

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` 573行目（ForbidConcurrent判定）
- E-02: `pkg/controller/cronjob/cronjob_controllerv2.go` 584行目（Eventf呼び出し）
- E-03: `pkg/controller/cronjob/cronjob_controllerv2.go` 97行目（EventSource）
- E-04: `pkg/controller/cronjob/cronjob_controllerv2.go` 514行目（suspend判定）
- E-05: `pkg/controller/cronjob/cronjob_controllerv2.go` 573-581行目（並行実行の可能性コメント）
- E-06: `pkg/controller/cronjob/cronjob_controllerv2.go` 588行目（ReplaceConcurrent処理）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 103行目（通知定義）
- E-08: `pkg/controller/cronjob/cronjob_controllerv2.go` 585行目（nextScheduleTimeDuration呼び出し）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConcurrencyPolicy=ForbidでActive Job存在時にイベント発行 | E-01, E-02 | ○ |
| C-02 | EventTypeはNormal | E-02 | ○ |
| C-03 | Reasonは"JobAlreadyActive" | E-02 | ○ |
| C-04 | 発行元は"cronjob-controller" | E-03 | ○ |
| C-05 | メッセージは固定文言 | E-02 | ○ |
| C-06 | suspend=trueの場合はスキップ | E-04 | ○ |
| C-07 | 理論的に並行実行が発生する可能性がある | E-05 | ○ |
| C-08 | Replace時は既存Jobが削除される | E-06 | ○ |
| C-09 | イベント発行後に次回スケジュール計算が行われる | E-08 | ○ |
| C-10 | len(cronJob.Status.Active) > 0 で判定 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 573行目のForbidConcurrent判定が最新コードと一致するか確認
- [ ] 584行目のイベントメッセージが最新コードと一致するか確認
